# PyScript

<p align="center">
    <img src="https://github.com/azzammuhyala/pyscript/blob/main/PyScript.png?raw=true" alt="PyScript Logo" width="200">
</p>

PyScript is a simple programming language built on top of Python. It combines some syntax from Python and JavaScript,
so if you're already familiar with Python or JavaScript, or both, it should be quite easy to learn.

## Introduction
PyScript may not be the language we'll be discussing, but the name PyScript already exists, a flexible and platform for
running Python in a browser. Since it's inception, the language was inspired by Python and JavaScript, which are
relatively easy for humans to read. This name was chosen because it wasn't immediately known whether this name was
already in use.

This language wasn't designed to compete with other modern programming languages, but rather as a learning for
understanding how programming languages ​​work and how human written code can be understood by machines. Furthermore, this
language was created as a relatively complex project. Using Python as the foundation for PyScript, it's easy to
understand syntax makes it easy to understand how the language is built without having to understand complex
instructions like those in C, C++, and other low-level languages.

To learn more about PyScript, you can see on [PyScript documentation](https://azzammuhyala.github.io/pyscript) or 
[PyScript repository](https://github.com/azzammuhyala/pyscript) for full source code.

## Installation
First, you'll need to download Python. Make sure you're using the latest version above `3.10`, to ensure the code runs
correctly. Visit the official [Python website](https://python.org) to download it.

Next, after downloading and configuring the Python application, you can download the PyScript interpreter from
[PyScript releases](https://github.com/azzammuhyala/pyscript/releases) or from Python Pip with this command
(_Recommended_):
```sh
python -m pip install -U pyscript-programming-language
```

After that, you can run the PyScript shell (_REPL_) with this command:
```sh
python -m pyscript
```
If successful, you can see the version, release date, and a `>>>` like Python shell (_REPL_).

> If you are using the VS Code editor, you can use the
[PyScript extension](https://marketplace.visualstudio.com/items?itemName=azzammuhyala.pyslang) for Syntax Highlight!

## Syntax
<pre><span style="color:#8CDCFE">a</span><span style="color:#D4D4D4"> = </span><span style="color:#4EC9B0">float</span><span style="color:#FFD705">(</span><span style="color:#DCDCAA">input</span><span style="color:#D45DBA">(</span><span style="color:#CE9178">&quot;Enter a first number : &quot;</span><span style="color:#D45DBA">)</span><span style="color:#FFD705">)</span><br><span style="color:#8CDCFE">b</span><span style="color:#D4D4D4"> = </span><span style="color:#4EC9B0">float</span><span style="color:#FFD705">(</span><span style="color:#DCDCAA">input</span><span style="color:#D45DBA">(</span><span style="color:#CE9178">&quot;Enter a second number: &quot;</span><span style="color:#D45DBA">)</span><span style="color:#FFD705">)</span><br><span style="color:#8CDCFE">op</span><span style="color:#D4D4D4"> = </span><span style="color:#DCDCAA">input</span><span style="color:#FFD705">(</span><span style="color:#CE9178">&quot;Enter an operation (+, -, *, /): &quot;</span><span style="color:#FFD705">)</span><br><br><span style="color:#C586C0">switch</span><span style="color:#D4D4D4"> </span><span style="color:#FFD705">(</span><span style="color:#8CDCFE">op</span><span style="color:#D4D4D4">.</span><span style="color:#DCDCAA">strip</span><span style="color:#D45DBA">()</span><span style="color:#FFD705">)</span><br><span style="color:#FFD705">{</span><br><span style="color:#D4D4D4">    </span><span style="color:#C586C0">case</span><span style="color:#D4D4D4"> </span><span style="color:#CE9178">&#x27;+&#x27;</span><span style="color:#D4D4D4">:</span><br><span style="color:#D4D4D4">        </span><span style="color:#8CDCFE">result</span><span style="color:#D4D4D4"> = </span><span style="color:#8CDCFE">a</span><span style="color:#D4D4D4"> + </span><span style="color:#8CDCFE">b</span><br><span style="color:#D4D4D4">        </span><span style="color:#DCDCAA">print</span><span style="color:#D45DBA">(</span><span style="color:#CE9178">&quot;Result of {} + {} = {}&quot;</span><span style="color:#D4D4D4">.</span><span style="color:#DCDCAA">format</span><span style="color:#1A9FFF">(</span><span style="color:#8CDCFE">a</span><span style="color:#D4D4D4">, </span><span style="color:#8CDCFE">b</span><span style="color:#D4D4D4">, </span><span style="color:#8CDCFE">result</span><span style="color:#1A9FFF">)</span><span style="color:#D45DBA">)</span><br><span style="color:#D4D4D4">        </span><span style="color:#C586C0">break</span><br><br><span style="color:#D4D4D4">    </span><span style="color:#C586C0">case</span><span style="color:#D4D4D4"> </span><span style="color:#CE9178">&#x27;-&#x27;</span><span style="color:#D4D4D4">:</span><br><span style="color:#D4D4D4">        </span><span style="color:#8CDCFE">result</span><span style="color:#D4D4D4"> = </span><span style="color:#8CDCFE">a</span><span style="color:#D4D4D4"> - </span><span style="color:#8CDCFE">b</span><br><span style="color:#D4D4D4">        </span><span style="color:#DCDCAA">print</span><span style="color:#D45DBA">(</span><span style="color:#CE9178">&quot;Result of {} - {} = {}&quot;</span><span style="color:#D4D4D4">.</span><span style="color:#DCDCAA">format</span><span style="color:#1A9FFF">(</span><span style="color:#8CDCFE">a</span><span style="color:#D4D4D4">, </span><span style="color:#8CDCFE">b</span><span style="color:#D4D4D4">, </span><span style="color:#8CDCFE">result</span><span style="color:#1A9FFF">)</span><span style="color:#D45DBA">)</span><br><span style="color:#D4D4D4">        </span><span style="color:#C586C0">break</span><br><br><span style="color:#D4D4D4">    </span><span style="color:#C586C0">case</span><span style="color:#D4D4D4"> </span><span style="color:#CE9178">&#x27;*&#x27;</span><span style="color:#D4D4D4">:</span><br><span style="color:#D4D4D4">        </span><span style="color:#8CDCFE">result</span><span style="color:#D4D4D4"> = </span><span style="color:#8CDCFE">a</span><span style="color:#D4D4D4"> * </span><span style="color:#8CDCFE">b</span><br><span style="color:#D4D4D4">        </span><span style="color:#DCDCAA">print</span><span style="color:#D45DBA">(</span><span style="color:#CE9178">&quot;Result of {} * {} = {}&quot;</span><span style="color:#D4D4D4">.</span><span style="color:#DCDCAA">format</span><span style="color:#1A9FFF">(</span><span style="color:#8CDCFE">a</span><span style="color:#D4D4D4">, </span><span style="color:#8CDCFE">b</span><span style="color:#D4D4D4">, </span><span style="color:#8CDCFE">result</span><span style="color:#1A9FFF">)</span><span style="color:#D45DBA">)</span><br><span style="color:#D4D4D4">        </span><span style="color:#C586C0">break</span><br><br><span style="color:#D4D4D4">    </span><span style="color:#C586C0">case</span><span style="color:#D4D4D4"> </span><span style="color:#CE9178">&#x27;/&#x27;</span><span style="color:#D4D4D4">:</span><br><span style="color:#D4D4D4">        </span><span style="color:#8CDCFE">result</span><span style="color:#D4D4D4"> = </span><span style="color:#8CDCFE">b</span><span style="color:#D4D4D4"> != </span><span style="color:#B5CEA8">0</span><span style="color:#D4D4D4"> ? </span><span style="color:#8CDCFE">a</span><span style="color:#D4D4D4"> / </span><span style="color:#8CDCFE">b</span><span style="color:#D4D4D4"> : </span><span style="color:#CE9178">&quot;Cannot be divided by 0!&quot;</span><br><span style="color:#D4D4D4">        </span><span style="color:#DCDCAA">print</span><span style="color:#D45DBA">(</span><span style="color:#CE9178">&quot;Result of {} / {} = {}&quot;</span><span style="color:#D4D4D4">.</span><span style="color:#DCDCAA">format</span><span style="color:#1A9FFF">(</span><span style="color:#8CDCFE">a</span><span style="color:#D4D4D4">, </span><span style="color:#8CDCFE">b</span><span style="color:#D4D4D4">, </span><span style="color:#8CDCFE">result</span><span style="color:#1A9FFF">)</span><span style="color:#D45DBA">)</span><br><span style="color:#D4D4D4">        </span><span style="color:#C586C0">break</span><br><br><span style="color:#D4D4D4">    </span><span style="color:#C586C0">default</span><span style="color:#D4D4D4">:</span><br><span style="color:#D4D4D4">        </span><span style="color:#DCDCAA">print</span><span style="color:#D45DBA">(</span><span style="color:#CE9178">&quot;Unknown operation&quot;</span><span style="color:#D45DBA">)</span><br><span style="color:#FFD705">}</span></pre>

## Behind it
This language created from based up on a
[YouTube tutorial](https://www.youtube.com/playlist?list=PLZQftyCk7_SdoVexSmwy_tBgs7P0b97yD) (check more on GitHub [here](https://github.com/davidcallanan/py-myopl-code)). At least, it takes
about 6 months to learn it, and also need to learn general things that exist in other programming languages.