/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.border.FocusStateMatteBorder;
import com.explodingpixels.macwidgets.BottomBarSize;
import com.explodingpixels.macwidgets.MacColorUtils;
import com.explodingpixels.macwidgets.TriAreaComponent;
import com.explodingpixels.painter.FocusStatePainter;
import com.explodingpixels.painter.GradientPainter;
import com.explodingpixels.painter.Painter;
import com.explodingpixels.util.PlatformUtils;
import com.explodingpixels.widgets.WindowDragger;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BottomBar {
    private final TriAreaComponent fBottomBar = new TriAreaComponent(5);
    private static final Color ACTIVE_TOP_COLOR = new Color(0xCCCCCC);
    private static final Color ACTIVE_BOTTOM_COLOR = new Color(0xA7A7A7);
    private static final Color INACTIVE_TOP_COLOR = new Color(0xE9E9E9);
    private static final Color INACTIVE_BOTTOM_COLOR = new Color(0xD8D8D8);
    private static final Color BORDER_HIGHLIGHT_COLOR = new Color(255, 255, 255, 100);
    private static final Color LEOPARD_ACTIVE_TOP_COLOR = new Color(0xBBBBBB);
    private static final Color LEOPARD_ACTIVE_BOTTOM_COLOR = new Color(0x969696);
    private static final Color LEOPARD_INACTIVE_TOP_COLOR = new Color(0xE3E3E3);
    private static final Color LEOPARD_INACTIVE_BOTTOM_COLOR = new Color(0xCFCFCF);
    private static final Color LEOPARD_BORDER_HIGHLIGHT_COLOR = new Color(255, 255, 255, 110);

    public BottomBar(BottomBarSize size) {
        this.createAndInstallBackgroundPainter();
        this.createAndInstallBorder();
        this.fBottomBar.forceAreasToHaveTheSameWidth();
        int height = size.getHeight() + 2;
        this.fBottomBar.getComponent().setPreferredSize(new Dimension(-1, height));
        WindowUtils.installJComponentRepainterOnWindowFocusChanged(this.fBottomBar.getComponent());
    }

    public void addComponentToLeft(JComponent toolToAdd) {
        this.fBottomBar.addComponentToLeft(toolToAdd);
    }

    public void addComponentToLeft(JComponent toolToAdd, int spacer_pixels) {
        this.fBottomBar.addComponentToLeft(toolToAdd, spacer_pixels);
    }

    public void addComponentToCenter(JComponent toolToAdd) {
        this.fBottomBar.addComponentToCenter(toolToAdd);
    }

    public void addComponentToCenter(JComponent toolToAdd, int spacer_pixels) {
        this.fBottomBar.addComponentToCenter(toolToAdd, spacer_pixels);
    }

    public void addComponentToRight(JComponent toolToAdd) {
        this.fBottomBar.addComponentToRight(toolToAdd);
    }

    public void addComponentToRight(JComponent toolToAdd, int spacer_pixels) {
        this.fBottomBar.addComponentToRight(toolToAdd, spacer_pixels);
    }

    public void installWindowDraggerOnWindow(Window window) {
        new WindowDragger(window, this.getComponent());
    }

    public JComponent getComponent() {
        return this.fBottomBar.getComponent();
    }

    private void createAndInstallBackgroundPainter() {
        this.fBottomBar.setBackgroundPainter(PlatformUtils.isLeopard() ? BottomBar.createLeopardPainter() : BottomBar.createDefaultPainter());
    }

    private void createAndInstallBorder() {
        FocusStateMatteBorder outterBorder = new FocusStateMatteBorder(1, 0, 0, 0, MacColorUtils.getTexturedWindowToolbarBorderFocusedColor(), MacColorUtils.getTexturedWindowToolbarBorderUnfocusedColor(), this.fBottomBar.getComponent());
        MatteBorder innerBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, BottomBar.getBorderHighlightColor());
        CompoundBorder lineBorders = BorderFactory.createCompoundBorder(outterBorder, innerBorder);
        int padding = 5;
        this.fBottomBar.getComponent().setBorder(BorderFactory.createCompoundBorder(lineBorders, BorderFactory.createEmptyBorder(0, padding, 0, padding)));
    }

    private static Painter<Component> createDefaultPainter() {
        GradientPainter focusedPainter = new GradientPainter(ACTIVE_TOP_COLOR, ACTIVE_BOTTOM_COLOR);
        GradientPainter unfocusedPainter = new GradientPainter(INACTIVE_TOP_COLOR, INACTIVE_BOTTOM_COLOR);
        return new FocusStatePainter(focusedPainter, focusedPainter, unfocusedPainter);
    }

    private static Painter<Component> createLeopardPainter() {
        GradientPainter focusedPainter = new GradientPainter(LEOPARD_ACTIVE_TOP_COLOR, LEOPARD_ACTIVE_BOTTOM_COLOR);
        GradientPainter unfocusedPainter = new GradientPainter(LEOPARD_INACTIVE_TOP_COLOR, LEOPARD_INACTIVE_BOTTOM_COLOR);
        return new FocusStatePainter(focusedPainter, focusedPainter, unfocusedPainter);
    }

    private static Color getBorderHighlightColor() {
        return PlatformUtils.isLeopard() ? LEOPARD_BORDER_HIGHLIGHT_COLOR : BORDER_HIGHLIGHT_COLOR;
    }
}

