/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.HudWindow;
import com.explodingpixels.macwidgets.MacWidgetFactory;
import com.explodingpixels.macwidgets.TriAreaComponent;
import com.explodingpixels.macwidgets.plaf.GradientButtonUI;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DGradientButtonUI {
    private static JPanel createButtonPanel(String description, GradientButtonUI.ButtonType buttonType) {
        FormLayout layout = new FormLayout("right:p:grow, 3dlu, left:p:grow", "3dlu, p, 0dlu, p, 3dlu");
        layout.setColumnGroups((int[][])new int[][]{{1, 3}});
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(layout);
        JButton button = new JButton("Button");
        button.setUI(new GradientButtonUI(buttonType));
        builder.addLabel(description, cc.xy(1, 2));
        builder.add((Component)button, cc.xy(3, 2));
        return builder.getPanel();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 1));
                FormLayout layout = new FormLayout("fill:p:grow", "p, 0dlu, p");
                CellConstraints cc = new CellConstraints();
                PanelBuilder builder = new PanelBuilder(layout);
                JPanel light = DGradientButtonUI.createButtonPanel("Light gradient", GradientButtonUI.ButtonType.LIGHT);
                light.setBackground(Color.WHITE);
                JPanel dark = DGradientButtonUI.createButtonPanel("Dark gradient", GradientButtonUI.ButtonType.DARK);
                dark.setOpaque(false);
                builder.add((Component)light, cc.xy(1, 1));
                builder.add((Component)dark, cc.xy(1, 3));
                JButton buttonOne = new JButton("Button One");
                buttonOne.setUI(new GradientButtonUI(GradientButtonUI.ButtonType.LIGHT));
                JButton buttonTwo = new JButton("Button Two");
                buttonTwo.setUI(new GradientButtonUI(GradientButtonUI.ButtonType.DARK));
                TriAreaComponent unifiedToolBar = MacWidgetFactory.createUnifiedToolBar();
                unifiedToolBar.addComponentToCenter(buttonOne);
                unifiedToolBar.addComponentToCenter(buttonTwo);
                HudWindow hudWindow = new HudWindow("");
                JDialog dialog = hudWindow.getJDialog();
                builder.getPanel().setOpaque(false);
                hudWindow.setContentPane(builder.getPanel());
                dialog.setSize(500, 400);
                dialog.setLocationRelativeTo(null);
                dialog.setDefaultCloseOperation(2);
                dialog.setVisible(true);
            }
        });
    }
}

