/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.MacWidgetFactory;
import com.explodingpixels.util.PlatformUtils;
import com.explodingpixels.widgets.WindowDragger;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class HudWindow {
    private final JDialog fDialog;
    private JComponent fContentPane;
    private final TitlePanel fTitlePanel;
    private final HudPanel fHudPanel = new HudPanel();
    private final BottomPanel fBottomPanel;
    private static final int ROUNDED_RECT_DIAMETER = 16;

    public HudWindow() {
        this("");
    }

    public HudWindow(String title) {
        this(title, null);
    }

    public HudWindow(String title, Frame owner) {
        this.fDialog = new JDialog(owner);
        this.fDialog.setTitle(title);
        this.fTitlePanel = new TitlePanel(title, this.createCloseButtonActionListener());
        this.fBottomPanel = new BottomPanel(this.fDialog);
        this.init();
    }

    private void init() {
        this.fDialog.getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
        this.fDialog.setUndecorated(true);
        WindowUtils.makeWindowNonOpaque(this.fDialog);
        this.fDialog.getRootPane().setBackground(Color.BLACK);
        this.fHudPanel.add((Component)this.fTitlePanel, "North");
        this.fDialog.setContentPane(this.fHudPanel);
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        this.setContentPane(panel);
        this.fDialog.addPropertyChangeListener("title", this.createTitlePropertyChangeListener());
        WindowUtils.createAndInstallRepaintWindowFocusListener(this.fDialog);
        new WindowDragger(this.fDialog, this.fTitlePanel);
    }

    public JDialog getJDialog() {
        return this.fDialog;
    }

    public void hideCloseButton() {
        this.fTitlePanel.hideCloseButton();
    }

    public void makeResizeable() {
        this.fHudPanel.add((Component)this.fBottomPanel, "South");
    }

    public JComponent getContentPane() {
        return this.fContentPane;
    }

    public void setContentPane(JComponent contentPane) {
        if (this.fContentPane != null) {
            this.fHudPanel.remove(this.fContentPane);
        }
        this.fContentPane = contentPane;
        this.fHudPanel.add((Component)this.fContentPane, "Center");
    }

    private PropertyChangeListener createTitlePropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                HudWindow.this.fTitlePanel.setTitle(HudWindow.this.fDialog.getTitle());
            }
        };
    }

    private ActionListener createCloseButtonActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HudWindow.this.fDialog.dispatchEvent(new WindowEvent(HudWindow.this.fDialog, 201));
            }
        };
    }

    private static class BottomPanel
    extends JPanel {
        private static final Icon RESIZE_ICON = new ImageIcon(TitlePanel.class.getResource("/com/explodingpixels/macwidgets/images/resize_corner_dark.png"));
        private final Window fWindow;
        private final JLabel fResizeCorner = new JLabel(RESIZE_ICON);
        private int fXOffsetToWindowEdge;
        private int fYOffsetToWidnowEdge;

        public BottomPanel(Window window) {
            super(new FlowLayout(4));
            this.fWindow = window;
            this.setOpaque(false);
            this.add(this.fResizeCorner);
            this.fResizeCorner.addMouseListener(this.createMouseListener());
            this.fResizeCorner.addMouseMotionListener(this.createMouseMotionListener());
        }

        private MouseAdapter createMouseListener() {
            return new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    Point windowPoint = SwingUtilities.convertPoint(BottomPanel.this.fResizeCorner, e.getPoint(), BottomPanel.this.fWindow);
                    BottomPanel.this.fXOffsetToWindowEdge = BottomPanel.this.fWindow.getWidth() - windowPoint.x;
                    BottomPanel.this.fYOffsetToWidnowEdge = BottomPanel.this.fWindow.getHeight() - windowPoint.y;
                }
            };
        }

        private MouseMotionListener createMouseMotionListener() {
            return new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent e) {
                    Point windowPoint = SwingUtilities.convertPoint(BottomPanel.this.fResizeCorner, e.getPoint(), BottomPanel.this.fWindow);
                    BottomPanel.this.fWindow.setSize(windowPoint.x + BottomPanel.this.fXOffsetToWindowEdge, windowPoint.y + BottomPanel.this.fYOffsetToWidnowEdge);
                    BottomPanel.this.fWindow.invalidate();
                    BottomPanel.this.fWindow.validate();
                }
            };
        }
    }

    private static class HudPanel
    extends JPanel {
        private static final Color HIGHLIGHT = new Color(255, 255, 255, 59);
        private static final Color HIGHLIGHT_BOTTOM = new Color(255, 255, 255, 25);
        private static final Color BACKGROUND = new Color(30, 30, 30, 216);

        private HudPanel() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
        }

        protected void paintBorder(Graphics g) {
            Graphics2D graphics2d = (Graphics2D)g.create();
            graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, HIGHLIGHT, 0.0f, this.getHeight(), HIGHLIGHT_BOTTOM);
            graphics2d.setPaint(paint);
            graphics2d.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 16, 16);
            graphics2d.dispose();
        }

        protected void paintComponent(Graphics g) {
            Graphics2D graphics2d = (Graphics2D)g.create();
            graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2d.setComposite(AlphaComposite.Src);
            graphics2d.setColor(BACKGROUND);
            graphics2d.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 16, 16);
            this.getRootPane().putClientProperty("apple.awt.windowShadow.revalidateNow", new Object());
            graphics2d.dispose();
        }
    }

    private static class TitlePanel
    extends JPanel {
        private static final Color FONT_COLOR = new Color(255, 255, 255, 255);
        private static final Color UNFOCUSED_FONT_COLOR = new Color(0xCCCCCC);
        private static final Color HIGHLIGHT = new Color(255, 255, 255, 25);
        private static final Color TOP_BACKGROUND_TOP = new Color(255, 255, 255, 59);
        private static final Color TOP_BACKGROUND_BOTTOM = new Color(196, 196, 196, 59);
        private static final Color BOTTOM_BACKGROUND = new Color(255, 255, 255, 30);
        private static final Color UNFOCUSED_BACKGROUND = new Color(0, 0, 0, 10);
        private static final Icon CLOSE_ICON = new ImageIcon(TitlePanel.class.getResource("/com/explodingpixels/macwidgets/images/close.png"));
        private static final Icon CLOSE_HOVER_ICON = new ImageIcon(TitlePanel.class.getResource("/com/explodingpixels/macwidgets/images/close_hover.png"));
        private static final Icon CLOSE_PRESSED_ICON = new ImageIcon(TitlePanel.class.getResource("/com/explodingpixels/macwidgets/images/close_pressed.png"));
        private final JButton fCloseButton = new JButton(CLOSE_ICON);
        private final JComponent fSpacer;
        private final JLabel fLabel;

        private TitlePanel(String title, ActionListener closeButtonActionListener) {
            this.fLabel = new JLabel(title, 0);
            this.fLabel.setFont(this.fLabel.getFont().deriveFont(1, 11.0f));
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(-1, 20));
            this.updateFocusState();
            this.fCloseButton.setBorder(this.getCloseButtonBorder());
            this.fCloseButton.setVerticalAlignment(0);
            this.fCloseButton.setOpaque(false);
            this.fCloseButton.setFocusable(false);
            this.fCloseButton.setBorderPainted(false);
            this.fCloseButton.setContentAreaFilled(false);
            this.fCloseButton.setRolloverIcon(CLOSE_HOVER_ICON);
            this.fCloseButton.setPressedIcon(CLOSE_PRESSED_ICON);
            this.fCloseButton.addActionListener(closeButtonActionListener);
            this.fSpacer = MacWidgetFactory.createSpacer(this.fCloseButton.getPreferredSize().width, 0);
            this.setLayout(new BorderLayout());
            this.add((Component)this.fLabel, "Center");
            this.add((Component)this.fCloseButton, PlatformUtils.isMac() ? "West" : "East");
            this.add((Component)this.fSpacer, PlatformUtils.isMac() ? "East" : "West");
        }

        private void hideCloseButton() {
            this.fCloseButton.setVisible(false);
            this.fSpacer.setVisible(false);
        }

        private Border getCloseButtonBorder() {
            return PlatformUtils.isMac() ? BorderFactory.createEmptyBorder(0, 5, 0, 0) : BorderFactory.createEmptyBorder(0, 0, 0, 5);
        }

        private void setTitle(String title) {
            this.fLabel.setText(title);
        }

        private void updateFocusState() {
            Boolean focused = WindowUtils.isParentWindowFocused(this);
            this.fLabel.setForeground(focused == null || focused != false ? FONT_COLOR : UNFOCUSED_FONT_COLOR);
        }

        protected void paintComponent(Graphics g) {
            Graphics2D graphics2d = (Graphics2D)g.create();
            graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int midPointY = 11;
            if (WindowUtils.isParentWindowFocused(this)) {
                GradientPaint paint = new GradientPaint(0.0f, 0.0f, TOP_BACKGROUND_TOP, 0.0f, midPointY, TOP_BACKGROUND_BOTTOM);
                graphics2d.setPaint(paint);
                Area titleArea = new Area(new Area(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 16.0, 16.0)));
                titleArea.subtract(new Area(new Rectangle(0, midPointY, this.getWidth(), midPointY)));
                graphics2d.fill(titleArea);
                int bottomHeight = this.getHeight() - midPointY;
                graphics2d.setColor(BOTTOM_BACKGROUND);
                graphics2d.fillRect(0, midPointY, this.getWidth(), bottomHeight);
            } else {
                graphics2d.setColor(UNFOCUSED_BACKGROUND);
                Area titleArea = new Area(new Area(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 16.0, 16.0)));
                titleArea.subtract(new Area(new Rectangle(0, midPointY, this.getWidth(), midPointY)));
                graphics2d.fill(titleArea);
                graphics2d.setColor(HIGHLIGHT);
                graphics2d.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            }
            graphics2d.dispose();
        }
    }
}

