/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.data.Rating;
import com.explodingpixels.macwidgets.ITunesRatingTableCellRenderer;
import com.explodingpixels.macwidgets.ITunesTableHeaderRenderer;
import com.explodingpixels.macwidgets.MacFontUtils;
import com.explodingpixels.widgets.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class ITunesTable
extends JTable {
    private static final Color ITUNES_SCROLLPANE_BORDER_COLOR = new Color(0x555555);
    private static final Color ITUNES_TABLE_SELECTION_ACTIVE_FOREGROUND_COLOR = Color.WHITE;
    private static final Color ITUNES_TABLE_SELECTION_INACTIVE_FOREGROUND_COLOR = Color.BLACK;
    private static final Color ITUNES_TABLE_SELECTION_ACTIVE_BACKGROUND_COLOR = new Color(4030687);
    private static final Color ITUNES_TABLE_SELECTION__INACTIVE_BACKGROUND_COLOR = new Color(192, 192, 192);
    private static final Color ITUNES_TABLE_GRID_COLOR = new Color(0xD9D9D9);
    private static final Color ITUNES_TABLE_SELECTED_FOCUSED_GRID_COLOR = new Color(3435966);
    private static final Color ITUNES_TABLE_SELECTED_UNFOCUSED_GRID_COLOR = new Color(0xACACAC);
    private static final Color ITUNES_TABLE_SELECTION_ACTIVE_BORDER_COLOR = new Color(125, 170, 234);
    private static final Color ITUNES_TABLE_SELECTION_INACTIVE_BORDER_COLOR = new Color(224, 224, 224);
    private static final Color ITUNES_ROW_COLOR = new Color(241, 245, 250);
    private static final Color ITUNES_RATING_DOT_SELECTED_INACTIVE_COLOR = new Color(0x999999);
    private static final Color ITUNES_RATING_DOT_SELECTED_ACTIVE_COLOR = new Color(255, 255, 255, 150);
    private final ITunesTableHeaderRenderer fHeaderRenderer = new ITunesTableHeaderRenderer(this);

    ITunesTable(TableModel dm) {
        super(dm);
        this.init();
    }

    private void init() {
        this.setFont(MacFontUtils.ITUNES_FONT);
        this.setShowVerticalLines(true);
        this.setShowHorizontalLines(false);
        this.setGridColor(ITUNES_TABLE_GRID_COLOR);
        this.setRowHeight(17);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.adjustColumnWidths();
        this.installCellRenderers();
        this.getTableHeader().setDefaultRenderer(this.fHeaderRenderer);
        this.addFocusListener(this.createFocusListener());
    }

    private FocusListener createFocusListener() {
        return new FocusListener(){

            public void focusGained(FocusEvent e) {
                TableUtils.repaintSelection((JTable)ITunesTable.this);
            }

            public void focusLost(FocusEvent e) {
                TableUtils.repaintSelection((JTable)ITunesTable.this);
            }
        };
    }

    private void adjustColumnWidths() {
    }

    private void installCellRenderers() {
        this.setDefaultRenderer(Rating.class, new ITunesRatingTableCellRenderer());
    }

    private Color getRowColor(int row) {
        return row % 2 == 0 ? ITUNES_ROW_COLOR : this.getBackground();
    }

    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            ITunesTableHeaderRenderer renderer = new ITunesTableHeaderRenderer();
            renderer.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ITUNES_SCROLLPANE_BORDER_COLOR));
            scrollPane.setCorner("UPPER_RIGHT_CORNER", renderer);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        boolean rowSelected = this.isRowSelected(row);
        if (!rowSelected) {
            component.setBackground(this.getRowColor(row));
        }
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Border spacer = BorderFactory.createEmptyBorder(0, 5, 0, 5);
            if (rowSelected && this.hasFocus()) {
                MatteBorder rightBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, ITUNES_TABLE_SELECTED_FOCUSED_GRID_COLOR);
                CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(rightBorder, spacer);
                jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ITUNES_TABLE_SELECTION_ACTIVE_BORDER_COLOR), compoundBorder));
            } else if (rowSelected) {
                MatteBorder rightBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, ITUNES_TABLE_SELECTED_UNFOCUSED_GRID_COLOR);
                CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(rightBorder, spacer);
                jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ITUNES_TABLE_SELECTION_INACTIVE_BORDER_COLOR), compoundBorder));
            } else {
                MatteBorder rightBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, ITUNES_TABLE_SELECTION_INACTIVE_BORDER_COLOR);
                CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(rightBorder, spacer);
                jComponent.setBorder(compoundBorder);
            }
        }
        return component;
    }

    public Color getSelectionForeground() {
        return this.hasFocus() ? ITUNES_TABLE_SELECTION_ACTIVE_FOREGROUND_COLOR : ITUNES_TABLE_SELECTION_INACTIVE_FOREGROUND_COLOR;
    }

    public Color getSelectionBackground() {
        return this.hasFocus() ? ITUNES_TABLE_SELECTION_ACTIVE_BACKGROUND_COLOR : ITUNES_TABLE_SELECTION__INACTIVE_BACKGROUND_COLOR;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        this.paintEmptyRows(g);
    }

    private void paintEmptyRows(Graphics g) {
        Graphics newGraphics = g.create();
        int firstNonExistentRowY = this.getRowCount() * this.getRowHeight();
        Rectangle clip = newGraphics.getClipBounds();
        for (int y = firstNonExistentRowY; y < this.getSize().height; y += this.getRowHeight()) {
            int row = y / this.getRowHeight();
            newGraphics.setColor(this.getRowColor(row));
            newGraphics.fillRect(clip.x, y, clip.width, this.getRowHeight());
        }
        int x = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            newGraphics.setColor(ITUNES_TABLE_GRID_COLOR);
            newGraphics.drawLine((x += column.getWidth()) - 1, firstNonExistentRowY, x - 1, this.getHeight());
        }
        newGraphics.dispose();
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && this.getPreferredSize().height < this.getParent().getHeight();
    }
}

