/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.MacButtonFactory;
import com.explodingpixels.macwidgets.MacPainterFactory;
import com.explodingpixels.macwidgets.MacUtils;
import com.explodingpixels.macwidgets.TriAreaComponent;
import com.explodingpixels.macwidgets.UnifiedToolBar;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class PreferencesTabBar {
    private TriAreaComponent fPreferencesTabBar = new TriAreaComponent();
    private ButtonGroup fButtonGroup = new ButtonGroup();

    public PreferencesTabBar() {
        Border b = BorderFactory.createEmptyBorder(0, 4, 0, 4);
        this.fPreferencesTabBar.getComponent().setBorder(b);
        UnifiedToolBar.installUnifiedToolBarBorder(this.fPreferencesTabBar.getComponent());
        PreferencesTabBar.fixUnifiedToolBarOnMacIfNeccessary(this.fPreferencesTabBar);
        WindowUtils.installJComponentRepainterOnWindowFocusChanged(this.fPreferencesTabBar.getComponent());
    }

    public void addTab(String title, Icon icon, ActionListener listener) {
        AbstractButton button = MacButtonFactory.makePreferencesTabBarButton(new JToggleButton(title, icon));
        this.fButtonGroup.add(button);
        button.addActionListener(listener);
        this.fPreferencesTabBar.addComponentToLeft(button);
    }

    public void showTab(String title) {
        this.getButton(title).doClick();
    }

    public void installWindowDraggerOnWindow(Window window) {
        this.fPreferencesTabBar.installWindowDraggerOnWindow(window);
    }

    public JComponent getComponent() {
        return this.fPreferencesTabBar.getComponent();
    }

    private AbstractButton getButton(String title) {
        AbstractButton retVal = null;
        Enumeration<AbstractButton> buttons = this.fButtonGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!button.getText().equals(title)) continue;
            retVal = button;
            break;
        }
        PreferencesTabBar.checkButtonFound(retVal);
        return retVal;
    }

    private static void checkButtonFound(AbstractButton button) {
        if (button == null) {
            throw new IllegalArgumentException("The given button title does not represent a preferences tab.");
        }
    }

    private static void fixUnifiedToolBarOnMacIfNeccessary(TriAreaComponent unifiedToolBar) {
        if (MacUtils.shouldManuallyPaintTexturedWindowBackground()) {
            unifiedToolBar.setBackgroundPainter(MacPainterFactory.createTexturedWindowWorkaroundPainter());
        }
    }
}

