/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.ComponentBottomBar;
import com.explodingpixels.macwidgets.MacButtonFactory;
import com.explodingpixels.widgets.PopdownButton;
import com.explodingpixels.widgets.PopupMenuCustomizer;
import java.awt.Cursor;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class SourceListControlBar {
    private static final ImageIcon SPLITTER_HANDLE = new ImageIcon(SourceListControlBar.class.getResource("/com/explodingpixels/macwidgets/images/splitter_handle.png"));
    private ComponentBottomBar fComponentBottomBar = new ComponentBottomBar();
    private JSplitPane fSplitPane;
    private final JLabel fSplitterHandle = new JLabel(SPLITTER_HANDLE);
    private final SplitterHandleMouseMovementHandler fMouseListener = new SplitterHandleMouseMovementHandler();

    public SourceListControlBar() {
        this.init();
    }

    private void init() {
        this.fComponentBottomBar.addComponentToRight(this.fSplitterHandle);
        this.fSplitterHandle.setCursor(Cursor.getPredefinedCursor(10));
    }

    public void installDraggableWidgetOnSplitPane(JSplitPane splitPane) {
        if (splitPane == null) {
            throw new IllegalArgumentException("JSplitPane cannot be null.");
        }
        this.fSplitPane = splitPane;
        this.fSplitterHandle.addMouseListener(this.fMouseListener);
        this.fSplitterHandle.addMouseMotionListener(this.fMouseListener);
    }

    public JComponent getComponent() {
        return this.fComponentBottomBar.getComponent();
    }

    private void addComponent(JComponent component) {
        this.fComponentBottomBar.addComponentToLeftWithBorder(component);
    }

    public void createAndAddPopdownButton(Icon icon, PopupMenuCustomizer popupMenuCustomizer) {
        PopdownButton button = MacButtonFactory.createGradientPopdownButton(icon, popupMenuCustomizer);
        SourceListControlBar.initSourceListButton(button.getComponent());
        this.addComponent(button.getComponent());
    }

    public void createAndAddButton(Icon icon, ActionListener actionListener) {
        JComponent button = MacButtonFactory.createGradientButton(icon, actionListener);
        SourceListControlBar.initSourceListButton(button);
        this.addComponent(button);
    }

    private static void initSourceListButton(JComponent component) {
        component.setBorder(BorderFactory.createEmptyBorder());
    }

    public void hideResizeHandle() {
        this.fSplitterHandle.setVisible(false);
    }

    private class SplitterHandleMouseMovementHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private int fDelta;

        private SplitterHandleMouseMovementHandler() {
        }

        public void mousePressed(MouseEvent e) {
            MouseEvent convertedEvent = SwingUtilities.convertMouseEvent(SourceListControlBar.this.fSplitterHandle, e, SourceListControlBar.this.fSplitPane);
            this.fDelta = SourceListControlBar.this.fSplitPane.getDividerLocation() - convertedEvent.getPoint().x;
        }

        public void mouseDragged(MouseEvent e) {
            MouseEvent convertedEvent = SwingUtilities.convertMouseEvent(SourceListControlBar.this.fSplitterHandle, e, SourceListControlBar.this.fSplitPane);
            int newLocation = convertedEvent.getPoint().x + this.fDelta;
            int boundedNewLocation = Math.max(SourceListControlBar.this.fSplitPane.getMinimumDividerLocation(), Math.min(newLocation, SourceListControlBar.this.fSplitPane.getMaximumDividerLocation()));
            SourceListControlBar.this.fSplitPane.setDividerLocation(boundedNewLocation);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

