/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

public class GradientButtonUI
extends BasicButtonUI {
    private static final String LIGHT_GRADIENT_BUTTON = "gradient.light";
    private static final Color LIGHT_TEXTURED_FONT_COLOR = Color.BLACK;
    private static final Color LIGHT_TEXTURED_BORDER_COLOR = new Color(0x727272);
    private static final Color LIGHT_TEXTURED_TOP_COLOR = new Color(0xFFFFFE);
    private static final Color LIGHT_TEXTURED_BOTTOM_COLOR = new Color(0xAFADAD);
    private static final Color LIGHT_TEXTURED_PRESSED_TOP_COLOR = new Color(0x848284);
    private static final Color LIGHT_TEXTURED_PRESSED_BOTTOM_COLOR = new Color(0xA6A6A7);
    private static final Color DARK_TEXTURED_FONT_COLOR = Color.WHITE;
    private static final Color DARK_TEXTURED_BORDER_COLOR = new Color(11909311);
    private static final Color DARK_TEXTURED_TOP_COLOR = new Color(0x2E2E2F);
    private static final Color DARK_TEXTURED_BOTTOM_COLOR = new Color(526344);
    private static final Color DARK_TEXTURED_PRESSED_TOP_COLOR = new Color(10001054);
    private static final Color DARK_TEXTURED_PRESSED_BOTTOM_COLOR = new Color(12542308);
    private final ButtonType fButtonType;

    public GradientButtonUI(ButtonType buttonType) {
        this.fButtonType = buttonType;
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setHorizontalTextPosition(0);
        b.setMargin(new Insets(3, 16, 3, 16));
        b.setForeground(this.fButtonType.getFontColor());
        b.setOpaque(false);
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(model.isPressed() ? this.fButtonType.getPressedPaint(c, 1) : this.fButtonType.getPaint(c, 1));
        int arcDiameter = c.getHeight() - 2;
        graphics.fillRoundRect(0, 1, c.getWidth(), c.getHeight() - 2, arcDiameter, arcDiameter);
        graphics.setColor(this.fButtonType.getBorderColor());
        graphics.drawRoundRect(0, 0, c.getWidth() - 1, c.getHeight() - 1, arcDiameter, arcDiameter);
        super.paint(g, c);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ButtonType {
        LIGHT(Color.BLACK, new Color(0x727272), new Color(0xFFFFFE), new Color(0xAFADAD), new Color(0x848284), new Color(0xA6A6A7)),
        DARK(Color.WHITE, new Color(11909311), new Color(0x2E2E2F), new Color(526344), new Color(10001054), new Color(6250852));

        private Color fFontColor;
        private Color fBorderColor;
        private Color fTopColor;
        private Color fBottomColor;
        private Color fTopPressedColor;
        private Color fBottomPressedColor;

        private ButtonType(Color fontColor, Color borderColor, Color topColor, Color bottomColor, Color topPressedColor, Color bottomPressedColor) {
            this.fFontColor = fontColor;
            this.fBorderColor = borderColor;
            this.fTopColor = topColor;
            this.fBottomColor = bottomColor;
            this.fTopPressedColor = topPressedColor;
            this.fBottomPressedColor = bottomPressedColor;
        }

        public Color getFontColor() {
            return this.fFontColor;
        }

        public Color getBorderColor() {
            return this.fBorderColor;
        }

        public Paint getPaint(JComponent component, int borderWidth_pixels) {
            return new GradientPaint(0.0f, borderWidth_pixels, this.fTopColor, 0.0f, component.getHeight() - borderWidth_pixels * 2, this.fBottomColor);
        }

        public Paint getPressedPaint(JComponent component, int borderWidth_pixels) {
            return new GradientPaint(0.0f, borderWidth_pixels, this.fTopPressedColor, 0.0f, component.getHeight() - borderWidth_pixels * 2, this.fBottomPressedColor);
        }
    }
}

