/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import com.explodingpixels.macwidgets.plaf.HudPaintingUtils;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class HudButtonUI
extends BasicButtonUI {
    private final HudPaintingUtils.Roundedness fRoundedness;
    private static final int TOP_AND_BOTTOM_MARGIN = 2;
    private static final int LEFT_AND_RIGHT_MARGIN = 16;

    public HudButtonUI() {
        this(HudPaintingUtils.Roundedness.ROUNDED_BUTTON);
    }

    public HudButtonUI(HudPaintingUtils.Roundedness roundedness) {
        this.fRoundedness = roundedness;
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        HudPaintingUtils.initHudComponent(b);
        b.setHorizontalTextPosition(0);
        int bottomMargin = 2 + HudPaintingUtils.getHudControlShadowSize(b);
        b.setBorder(BorderFactory.createEmptyBorder(2, 16, bottomMargin, 16));
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        Graphics2D graphics = (Graphics2D)g;
        HudPaintingUtils.updateGraphicsToPaintDisabledControlIfNecessary(graphics, button);
        int buttonHeight = button.getHeight() - HudPaintingUtils.getHudControlShadowSize(button);
        HudPaintingUtils.paintHudControlBackground(graphics, button, button.getWidth(), buttonHeight, this.fRoundedness);
        super.paint(g, c);
    }

    protected void paintText(Graphics g, AbstractButton button, Rectangle textRect, String text) {
        FontMetrics fontMetrics = g.getFontMetrics(button.getFont());
        int mnemonicIndex = button.getDisplayedMnemonicIndex();
        g.setColor(button.getForeground());
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fontMetrics.getAscent() + this.getTextShiftOffset());
    }
}

