/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import com.explodingpixels.macwidgets.HudWidgetFactory;
import com.explodingpixels.macwidgets.plaf.HudButtonUI;
import com.explodingpixels.macwidgets.plaf.HudPaintingUtils;
import com.explodingpixels.widgets.plaf.EPComboPopup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class HudComboBoxUI
extends BasicComboBoxUI {
    private HudButtonUI fArrowButtonUI;
    private ActionListener fSelectedItemChangedActionListener = this.createSelectedItemChangedActionListener();
    private PopupMenuListener fPopupMenuListener = this.createPopupMenuListener();
    private static final int LEFT_MARGIN = 7;
    private static final int RIGHT_MARGIN = 19;
    private static final int DEFAULT_WIDTH = 100;

    public HudComboBoxUI() {
        this.fArrowButtonUI = new HudButtonUI(HudPaintingUtils.Roundedness.COMBO_BUTTON);
    }

    protected void installDefaults() {
        super.installDefaults();
        HudPaintingUtils.initHudComponent(this.comboBox);
    }

    protected void installListeners() {
        super.installListeners();
        this.comboBox.addActionListener(this.createComboBoxListener());
        this.comboBox.addActionListener(this.fSelectedItemChangedActionListener);
        this.comboBox.addPopupMenuListener(this.fPopupMenuListener);
    }

    protected void uninstallListeners() {
        this.comboBox.removeActionListener(this.fSelectedItemChangedActionListener);
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    protected void installComponents() {
        super.installComponents();
        this.updateDisplayedItem();
    }

    private ActionListener createSelectedItemChangedActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HudComboBoxUI.this.updateDisplayedItem();
            }
        };
    }

    private void updateDisplayedItem() {
        String displayValue = this.comboBox.getSelectedItem() == null ? " " : this.comboBox.getSelectedItem().toString();
        this.arrowButton.setText(displayValue);
    }

    private EPComboPopup.ComboBoxVerticalCenterProvider createComboBoxVerticalCenterProvider() {
        return new EPComboPopup.ComboBoxVerticalCenterProvider(){

            public int provideCenter(JComboBox comboBox) {
                return HudComboBoxUI.this.calculateArrowButtonVisualVerticalCenter();
            }
        };
    }

    private ActionListener createComboBoxListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HudComboBoxUI.this.updateDisplayedItem();
            }
        };
    }

    private PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                HudComboBoxUI.this.arrowButton.getModel().setPressed(true);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                HudComboBoxUI.this.arrowButton.getModel().setPressed(false);
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
    }

    protected JButton createArrowButton() {
        JButton arrowButton = new JButton("");
        arrowButton.setModel(this.createButtonModel());
        arrowButton.setUI(this.fArrowButtonUI);
        Insets currentInsets = arrowButton.getInsets();
        arrowButton.setBorder(BorderFactory.createEmptyBorder(currentInsets.top, 7, currentInsets.bottom, 19));
        arrowButton.setHorizontalAlignment(2);
        return arrowButton;
    }

    private ButtonModel createButtonModel() {
        return new DefaultButtonModel(){

            public boolean isPressed() {
                return super.isPressed() || HudComboBoxUI.this.isPopupVisible(HudComboBoxUI.this.comboBox);
            }
        };
    }

    protected ListCellRenderer createRenderer() {
        return new JComboBox().getRenderer();
    }

    protected ComboPopup createPopup() {
        EPComboPopup popup = new EPComboPopup(this.comboBox);
        popup.setFont(HudPaintingUtils.getHudFont().deriveFont(0));
        popup.setVerticalComponentCenterProvider(this.createComboBoxVerticalCenterProvider());
        return popup;
    }

    public Dimension getMinimumSize(JComponent c) {
        int width = this.getDisplaySize().width;
        int height = this.arrowButton.getPreferredSize().height;
        return new Dimension(width, height);
    }

    protected Dimension getDefaultSize() {
        JButton button = HudWidgetFactory.createHudButton("Button");
        return new Dimension(100, button.getPreferredSize().height);
    }

    public void paint(Graphics g, JComponent c) {
        HudPaintingUtils.updateGraphicsToPaintDisabledControlIfNecessary((Graphics2D)g, c);
        super.paint(g, c);
        Graphics2D graphics = (Graphics2D)g.create();
        this.paintUpDownArrowsIcon(graphics);
        graphics.dispose();
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    protected Dimension getDisplaySize() {
        int maxWidth = this.comboBox.getPrototypeDisplayValue() != null ? this.getDisplayWidth(this.comboBox.getPrototypeDisplayValue()) : (this.comboBox.getItemCount() > 0 ? this.getMaxComboBoxModelDisplayWidth() : this.getDefaultSize().width);
        Insets arrowButtonInsets = this.arrowButton.getInsets();
        return new Dimension(maxWidth += arrowButtonInsets.left + arrowButtonInsets.right, this.arrowButton.getPreferredSize().height);
    }

    private int getMaxComboBoxModelDisplayWidth() {
        int maxWidth = 0;
        for (int i = 0; i < this.comboBox.getModel().getSize(); ++i) {
            int itemWidth = this.getDisplayWidth(this.comboBox.getModel().getElementAt(i));
            maxWidth = Math.max(maxWidth, itemWidth);
        }
        return maxWidth;
    }

    private int getDisplayWidth(Object object) {
        assert (object != null) : "The given object cannot be null";
        FontMetrics fontMetrics = this.comboBox.getFontMetrics(this.comboBox.getFont());
        return fontMetrics.stringWidth(object.toString());
    }

    protected LayoutManager createLayoutManager() {
        return new LayoutManager(){

            public void addLayoutComponent(String name, Component comp) {
                throw new UnsupportedOperationException("This operation is not supported.");
            }

            public void removeLayoutComponent(Component comp) {
                throw new UnsupportedOperationException("This operation is not supported.");
            }

            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(parent.getPreferredSize().width, ((HudComboBoxUI)HudComboBoxUI.this).arrowButton.getPreferredSize().height);
            }

            public Dimension minimumLayoutSize(Container parent) {
                return parent.getMinimumSize();
            }

            public void layoutContainer(Container parent) {
                int buttonHeight = ((HudComboBoxUI)HudComboBoxUI.this).arrowButton.getPreferredSize().height;
                int y = parent.getHeight() / 2 - buttonHeight / 2;
                HudComboBoxUI.this.arrowButton.setBounds(0, y, parent.getWidth(), buttonHeight);
            }
        };
    }

    private int calculateArrowButtonVisualVerticalCenter() {
        int arrowButtonShadowHeight = HudPaintingUtils.getHudControlShadowSize(this.arrowButton);
        return (this.comboBox.getHeight() - arrowButtonShadowHeight) / 2;
    }

    private void paintUpDownArrowsIcon(Graphics2D graphics) {
        Insets arrowButtonInsets = this.arrowButton.getInsets();
        int arrowButtonHeight = this.arrowButton.getHeight();
        int centerX = this.arrowButton.getWidth() - arrowButtonInsets.right / 2;
        int centerY = this.calculateArrowButtonVisualVerticalCenter();
        int verticalDistanceBetweenArrows = (int)((double)arrowButtonHeight * 0.125);
        int arrowSideLength = verticalDistanceBetweenArrows * 2;
        int upArrowX = centerX - arrowSideLength / 2;
        int upArrowY = centerY - verticalDistanceBetweenArrows / 2;
        graphics.setColor(HudPaintingUtils.FONT_COLOR);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(upArrowX, upArrowY);
        graphics.fill(HudComboBoxUI.createUpArrow(arrowSideLength));
        graphics.translate(0, verticalDistanceBetweenArrows);
        graphics.fill(HudComboBoxUI.createDownArrow(arrowSideLength));
    }

    private static GeneralPath createUpArrow(int arrowSideLength) {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(arrowSideLength, 0.0f);
        path.lineTo(arrowSideLength / 2, -arrowSideLength);
        path.closePath();
        return path;
    }

    private static GeneralPath createDownArrow(int arrowSideLength) {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(arrowSideLength, 0.0f);
        path.lineTo(arrowSideLength / 2, arrowSideLength);
        path.closePath();
        return path;
    }
}

