/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets.plaf;

import com.explodingpixels.painter.Painter;
import com.explodingpixels.swingx.EPPanel;
import com.explodingpixels.widgets.plaf.ScrollBarOrientation;
import com.explodingpixels.widgets.plaf.ScrollBarSkin;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonsSeparateScrollBarSkin
implements ScrollBarSkin {
    private JComponent fThumbContainer = new JPanel();
    private EPPanel fThumb = new EPPanel();
    private EPPanel fTrack = new EPPanel();
    private AbstractButton fDecrementButton;
    private AbstractButton fIncrementButton;
    private Dimension fMinimumThumbSize;
    private int fDecrementButtonTrackRecess;
    private int fIncrementButtonTrackRecess;
    private final Dimension fPreferredSize;
    private static final Rectangle EMPTY_BOUNDS = new Rectangle(0, 0, 0, 0);

    public ButtonsSeparateScrollBarSkin(AbstractButton decrementButton, AbstractButton incrementButton, Painter<Component> trackPainter, Painter<Component> scrollThumbPainter, int decrementButtonRecess, int incrementButtonRecess, Dimension minimumThumbSize, Dimension preferredSize) {
        this.fDecrementButton = decrementButton;
        this.fIncrementButton = incrementButton;
        this.fTrack.setBackgroundPainter(trackPainter);
        this.fThumb.setBackgroundPainter(scrollThumbPainter);
        this.fDecrementButtonTrackRecess = decrementButtonRecess;
        this.fIncrementButtonTrackRecess = incrementButtonRecess;
        this.fMinimumThumbSize = minimumThumbSize;
        this.fPreferredSize = preferredSize;
        this.fThumbContainer.setLayout(null);
        this.fThumbContainer.setOpaque(false);
        this.fThumb.setOpaque(false);
    }

    @Override
    public Dimension getMinimumThumbSize() {
        return this.fMinimumThumbSize;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.fPreferredSize;
    }

    @Override
    public Rectangle getScrollThumbBounds() {
        return this.fThumb.getBounds();
    }

    @Override
    public Rectangle getTrackBounds() {
        return this.fThumbContainer.getBounds();
    }

    @Override
    public void installComponents(JScrollBar scrollBar) {
        scrollBar.add(this.fThumbContainer);
        scrollBar.add(this.fIncrementButton);
        scrollBar.add(this.fDecrementButton);
        scrollBar.add(this.fTrack);
        this.fThumbContainer.add(this.fThumb);
    }

    @Override
    public void layoutTrackOnly(JScrollBar scrollBar, ScrollBarOrientation orientation) {
        this.fIncrementButton.setBounds(EMPTY_BOUNDS);
        this.fDecrementButton.setBounds(EMPTY_BOUNDS);
        this.fThumbContainer.setBounds(EMPTY_BOUNDS);
        Rectangle r = scrollBar.getBounds();
        this.fTrack.setBounds(0, 0, r.width, r.height);
    }

    @Override
    public void layoutEverything(JScrollBar scrollBar, ScrollBarOrientation orientation) {
        int incrementButtonHeight = orientation.getLength(this.fIncrementButton.getPreferredSize());
        int decrementButtonHeight = orientation.getLength(this.fDecrementButton.getPreferredSize());
        int scrollBarLength = orientation.getLength(scrollBar.getSize());
        int incrementButtonPosition = scrollBarLength - incrementButtonHeight;
        int decrementButtonPosition = 0;
        this.fIncrementButton.setBounds(orientation.createBounds(scrollBar, incrementButtonPosition, incrementButtonHeight));
        this.fDecrementButton.setBounds(orientation.createBounds(scrollBar, decrementButtonPosition, decrementButtonHeight));
        int trackAndThumbPosition = decrementButtonHeight - this.fDecrementButtonTrackRecess;
        int trackLength = incrementButtonPosition + this.fIncrementButtonTrackRecess - trackAndThumbPosition;
        Rectangle trackAndThumbBounds = orientation.createBounds(scrollBar, trackAndThumbPosition, trackLength);
        this.fTrack.setBounds(trackAndThumbBounds);
        this.fThumbContainer.setBounds(trackAndThumbBounds);
    }

    @Override
    public void installMouseListenersOnButtons(MouseListener decrementMoustListener, MouseListener incrementMouseListener) {
        this.fDecrementButton.addMouseListener(decrementMoustListener);
        this.fIncrementButton.addMouseListener(incrementMouseListener);
    }

    @Override
    public void setScrollThumbBounds(Rectangle bounds) {
        this.fThumb.setBounds(bounds);
    }
}

