/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.sikuli.script.Debug;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.Settings;
import org.sikuli.system.OSUtil;

public class App {
    protected static final OSUtil _osUtil = Settings.getOSUtil();
    protected String _appName;
    protected int _pid;

    public App(String string) {
        this._appName = string;
        this._pid = 0;
    }

    protected App(String string, int n) {
        this._appName = string;
        this._pid = n;
    }

    public static App open(String string) {
        return new App(string).open();
    }

    public static int close(String string) {
        return _osUtil.closeApp(string);
    }

    public static App focus(String string) {
        return new App(string).focus();
    }

    public static App focus(String string, int n) {
        return new App(string).focus(n);
    }

    public App focus() {
        return this.focus(0);
    }

    public App focus(int n) {
        Debug.history("App.focus " + this.toString() + " #" + n, new Object[0]);
        if (this._pid != 0) {
            if (_osUtil.switchApp(this._pid, n) == 0) {
                Debug.error("App.focus failed: " + this._appName + "(" + this._pid + ") not found", new Object[0]);
                return null;
            }
        } else {
            boolean bl = false;
            if (Settings.isWindows()) {
                this._pid = _osUtil.switchApp(this._appName, n);
                if (this._pid == 0) {
                    bl = true;
                }
            } else if (_osUtil.switchApp(this._appName, n) < 0) {
                bl = true;
            }
            if (bl) {
                Debug.error("App.focus failed: " + this._appName + " not found", new Object[0]);
                return null;
            }
        }
        return this;
    }

    public App open() {
        if (Settings.isWindows() || Settings.isLinux()) {
            int n;
            this._pid = n = _osUtil.openApp(this._appName);
            Debug.history("App.open " + this.toString(), new Object[0]);
            if (n == 0) {
                Debug.error("App.open failed: " + this._appName + " not found", new Object[0]);
                return null;
            }
        } else {
            Debug.history("App.open " + this.toString(), new Object[0]);
            if (_osUtil.openApp(this._appName) < 0) {
                Debug.error("App.open failed: " + this._appName + " not found", new Object[0]);
                return null;
            }
        }
        return this;
    }

    public int close() {
        int n;
        Debug.history("App.close " + this.toString(), new Object[0]);
        if (this._pid != 0 && (n = _osUtil.closeApp(this._pid)) >= 0) {
            return n;
        }
        return App.close(this._appName);
    }

    public String name() {
        return this._appName;
    }

    public Region window() {
        if (this._pid != 0) {
            return _osUtil.getWindow(this._pid);
        }
        return _osUtil.getWindow(this._appName);
    }

    public Region window(int n) {
        if (this._pid != 0) {
            return _osUtil.getWindow(this._pid, n);
        }
        return _osUtil.getWindow(this._appName, n);
    }

    public static Region focusedWindow() {
        return _osUtil.getFocusedWindow();
    }

    public static String getClipboard() {
        Transferable transferable = Clipboard.getSystemClipboard().getContents(null);
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Debug.error("Env.getClipboard: UnsupportedFlavorException: " + transferable, new Object[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return "";
    }

    public static void setClipboard(String string) {
        Clipboard.putText(Clipboard.PLAIN, Clipboard.UTF8, Clipboard.BYTE_BUFFER, string);
    }

    public String toString() {
        return this._appName + "(" + this._pid + ")";
    }

    static {
        new Screen();
    }

    private static class Clipboard {
        public static final TextType HTML = new TextType("text/html");
        public static final TextType PLAIN = new TextType("text/plain");
        public static final Charset UTF8 = new Charset("UTF-8");
        public static final Charset UTF16 = new Charset("UTF-16");
        public static final Charset UNICODE = new Charset("unicode");
        public static final Charset US_ASCII = new Charset("US-ASCII");
        public static final TransferType READER = new TransferType(Reader.class);
        public static final TransferType INPUT_STREAM = new TransferType(InputStream.class);
        public static final TransferType CHAR_BUFFER = new TransferType(CharBuffer.class);
        public static final TransferType BYTE_BUFFER = new TransferType(ByteBuffer.class);

        private Clipboard() {
        }

        public static void putText(CharSequence charSequence) {
            StringSelection stringSelection = new StringSelection(((Object)charSequence).toString());
            Clipboard.getSystemClipboard().setContents(stringSelection, stringSelection);
        }

        public static void putText(TextType textType, Charset charset, TransferType transferType, CharSequence charSequence) {
            String string = textType + "; charset=" + charset + "; class=" + transferType;
            TextTransferable textTransferable = new TextTransferable(string, ((Object)charSequence).toString());
            Clipboard.getSystemClipboard().setContents(textTransferable, textTransferable);
        }

        public static java.awt.datatransfer.Clipboard getSystemClipboard() {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }

        public static class TransferType {
            private Class dataClass;

            private TransferType(Class clazz) {
                this.dataClass = clazz;
            }

            public Class getDataClass() {
                return this.dataClass;
            }

            public String toString() {
                return this.dataClass.getName();
            }
        }

        public static class Charset {
            private String name;

            private Charset(String string) {
                this.name = string;
            }

            public String toString() {
                return this.name;
            }
        }

        public static class TextType {
            private String type;

            private TextType(String string) {
                this.type = string;
            }

            public String toString() {
                return this.type;
            }
        }

        private static class TextTransferable
        implements Transferable,
        ClipboardOwner {
            private String data;
            private DataFlavor flavor;

            public TextTransferable(String string, String string2) {
                this.flavor = new DataFlavor(string, "Text");
                this.data = string2;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{this.flavor, DataFlavor.stringFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                boolean bl = this.flavor.getPrimaryType().equals(dataFlavor.getPrimaryType());
                return bl || dataFlavor.equals(DataFlavor.stringFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (dataFlavor.isRepresentationClassInputStream()) {
                    return new StringReader(this.data);
                }
                if (dataFlavor.isRepresentationClassReader()) {
                    return new StringReader(this.data);
                }
                if (dataFlavor.isRepresentationClassCharBuffer()) {
                    return CharBuffer.wrap(this.data);
                }
                if (dataFlavor.isRepresentationClassByteBuffer()) {
                    return ByteBuffer.wrap(this.data.getBytes());
                }
                if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                    return this.data;
                }
                throw new UnsupportedFlavorException(dataFlavor);
            }

            @Override
            public void lostOwnership(java.awt.datatransfer.Clipboard clipboard, Transferable transferable) {
            }
        }
    }
}

