/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sikuli.script.Debug;

public class CommandArgs {
    Options _options;
    String _callerType;

    public static String[] getPyArgs(CommandLine commandLine) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (commandLine.hasOption("run")) {
            arrayList.add(commandLine.getOptionValue("run"));
        }
        if (commandLine.hasOption("args")) {
            arrayList.addAll(Arrays.asList(commandLine.getOptionValues("args")));
        } else {
            arrayList.addAll(Arrays.asList(commandLine.getArgs()));
        }
        return arrayList.toArray(new String[0]);
    }

    public static boolean isIDE(String string) {
        return "IDE".equals(string);
    }

    public static boolean isScript(String string) {
        return "SCRIPT".equals(string);
    }

    public static boolean isOther(String string) {
        return !CommandArgs.isIDE(string) && !CommandArgs.isScript(string);
    }

    public CommandArgs(String string) {
        if (!CommandArgs.isIDE(string) && !CommandArgs.isScript(string)) {
            Debug.error("Commandline Parser not configured for " + string, new Object[0]);
            this._callerType = "OTHER";
        } else {
            this._callerType = string;
        }
        this.init();
    }

    public CommandLine getCommandLine(String[] stringArray) {
        PosixParser posixParser = new PosixParser();
        CommandLine commandLine = null;
        try {
            commandLine = posixParser.parse(this._options, stringArray, true);
        }
        catch (ParseException parseException) {
            Debug.error(parseException.getMessage(), new Object[0]);
        }
        return commandLine;
    }

    private void init() {
        this._options = new Options();
        this._options.addOption("h", "help", false, "print this help message");
        if (CommandArgs.isIDE(this._callerType)) {
            this._options.addOption("s", "stderr", false, "print runtime errors to stderr instead of popping up a message box");
            OptionBuilder.withLongOpt("load");
            OptionBuilder.withDescription("peload scripts in IDE");
            OptionBuilder.hasOptionalArgs();
            OptionBuilder.withArgName("one or more foobar.sikuli");
            this._options.addOption(OptionBuilder.create('l'));
        }
        if (CommandArgs.isScript(this._callerType)) {
            this._options.addOption("i", "interactive", false, "start interactive Sikuli Jython session\n(Sikuli, sys, time already imported)");
            OptionBuilder.withLongOpt("test");
            OptionBuilder.withDescription("run script using Jython's unittest");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName("foobar.sikuli");
            this._options.addOption(OptionBuilder.create('t'));
            OptionBuilder.withLongOpt("run");
            OptionBuilder.withDescription("run script");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName("foobar.sikuli");
            this._options.addOption(OptionBuilder.create('r'));
        }
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt("args");
        OptionBuilder.withArgName("arguments");
        OptionBuilder.withDescription("arguments passed to Jython's sys.argv");
        this._options.addOption(OptionBuilder.create());
    }

    public void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        if (CommandArgs.isScript(this._callerType)) {
            helpFormatter.printHelp(80, "\n", "----- Running Sikuli script using sikuli-script.jar ---------------------------", this._options, "-----\n<foobar.sikuli>\npath relative to current working directory or absolute path\nthough deprecated: so called executables .skl can be used too\n-------------------------------------------------------------", true);
        } else if (CommandArgs.isIDE(this._callerType)) {
            helpFormatter.printHelp("Sikuli-IDE", this._options, true);
        } else {
            helpFormatter.printHelp("--?????--", this._options, true);
        }
    }
}

