/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import org.sikuli.script.FileManager;
import org.sikuli.script.Settings;

public class Debug {
    private static final int DEFAULT_LEVEL = 1;
    private static int DEBUG_LEVEL = 1;
    private long _beginTime;
    private static PrintStream printout = null;
    private static PrintStream printoutuser = null;
    private static String logfile;
    private static String logfileuser;
    private static final DateFormat df;

    public static int getDebugLevel() {
        return DEBUG_LEVEL;
    }

    public static int setDebugLevel() {
        Debug.setDebugLevel(1);
        return DEBUG_LEVEL;
    }

    public static void setDebugLevel(int n) {
        DEBUG_LEVEL = n;
    }

    public static void history(String string, Object ... objectArray) {
        if (Settings.ActionLogs) {
            Debug.log(-1, "log", string, objectArray);
        }
    }

    public static void info(String string, Object ... objectArray) {
        if (Settings.InfoLogs) {
            Debug.log(-1, "info", string, objectArray);
        }
    }

    public static void error(String string, Object ... objectArray) {
        Debug.log(-1, "error", string, objectArray);
    }

    public static void log(String string, Object ... objectArray) {
        Debug.log(1, string, objectArray);
    }

    public static void user(String string, Object ... objectArray) {
        if (Settings.UserLogs) {
            if (Settings.UserLogTime) {
                Debug.log(-99, String.format("%s (%s)", Settings.UserLogPrefix, df.format(new Date())), string, objectArray);
            } else {
                Debug.log(-99, String.format("%s", Settings.UserLogPrefix), string, objectArray);
            }
        }
    }

    public static void log(int n, String string, Object ... objectArray) {
        if (Settings.DebugLogs) {
            Debug.log(n, "debug", string, objectArray);
        }
    }

    private static void log(int n, String string, String string2, Object ... objectArray) {
        String string3 = "";
        if (Debug.isEnabled(n)) {
            if (Settings.LogTime && n != -99) {
                string3 = String.format(" (%s)", df.format(new Date()));
            }
            String string4 = objectArray.length != 0 ? String.format("[" + string + string3 + "] " + string2, objectArray) : "[" + string + string3 + "] " + string2;
            if (n == -99 && printoutuser != null) {
                printoutuser.print(string4);
                printoutuser.println();
            } else if (printout != null) {
                printout.print(string4);
                printout.println();
            } else {
                System.out.print(string4);
                System.out.println();
            }
        }
    }

    private static boolean isEnabled(int n) {
        return n <= DEBUG_LEVEL;
    }

    private static boolean isEnabled() {
        return Debug.isEnabled(1);
    }

    public static void profile(String string, Object ... objectArray) {
        if (Settings.ProfileLogs) {
            Debug.log(-1, "profile", string, objectArray);
        }
    }

    public void startTiming(String string, Object ... objectArray) {
        if ("".equals(string)) {
            Debug.profile("TimerStart: " + string, objectArray);
        }
        this._beginTime = new Date().getTime();
    }

    public void start() {
        this.startTiming("", new Object[0]);
    }

    public long endTiming(String string, Object ... objectArray) {
        long l = new Date().getTime();
        long l2 = l - this._beginTime;
        Debug.profile(String.format("TimerEnd (%.3f sec): ", Float.valueOf((float)l2 / 1000.0f)) + string, objectArray);
        return l2;
    }

    public long end() {
        return this.endTiming("", new Object[0]);
    }

    static {
        df = DateFormat.getDateTimeInstance(3, 2);
        String string = System.getProperty("sikuli.Debug");
        if (string != null && "".equals(string)) {
            DEBUG_LEVEL = 0;
            Settings.DebugLogs = false;
        } else {
            try {
                DEBUG_LEVEL = Integer.parseInt(string);
                Settings.DebugLogs = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        logfile = System.getProperty("sikuli.Logfile");
        if (logfile != null) {
            if ("".equals(logfile)) {
                logfile = FileManager.slashify(System.getProperty("user.dir"), true) + "SikuliLog.txt";
            }
            try {
                printout = new PrintStream(logfile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.printf("[Error] Logfile %s not accessible - check given path", logfile);
                System.out.println();
            }
        }
        if ((logfileuser = System.getProperty("sikuli.LogfileUser")) != null) {
            if ("".equals(logfileuser)) {
                logfileuser = FileManager.slashify(System.getProperty("user.dir"), true) + "UserLog.txt";
            }
            try {
                printoutuser = new PrintStream(logfileuser);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.printf("[Error] User logfile %s not accessible - check given path", logfileuser);
                System.out.println();
            }
        }
    }
}

