/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.sikuli.script.Debug;
import org.sikuli.script.Extension;
import org.sikuli.script.FileManager;
import org.sikuli.script.Settings;

public class ExtensionManager {
    private static ExtensionManager _instance = null;
    private ArrayList<Extension> extensions = new ArrayList();

    private ExtensionManager() {
        File file = new File(Settings.getUserExtPath());
        for (File file2 : file.listFiles()) {
            String string;
            if (!file2.getAbsolutePath().endsWith(".jar")) continue;
            String string2 = file2.getAbsolutePath();
            String string3 = file2.getName();
            if ((string3 = string3.substring(0, string3.length() - 4)).contains("-")) {
                string = string3.substring(string3.lastIndexOf("-") + 1);
                string3 = string3.substring(0, string3.lastIndexOf("-"));
            } else {
                string = "0.0";
            }
            Extension extension = new Extension(string3, string2, string);
            this.extensions.add(extension);
        }
    }

    public static ExtensionManager getInstance() {
        if (_instance == null) {
            _instance = new ExtensionManager();
        }
        return _instance;
    }

    public boolean install(String string, String string2, String string3) {
        if (string2.startsWith("---extensions---")) {
            string2 = Settings.SikuliRepo + string + "-" + string3 + ".jar";
        }
        String string4 = Settings.getUserExtPath();
        String string5 = Settings.BaseTempPath;
        try {
            File file = new File(FileManager.downloadURL(new URL(string2), string5));
            String string6 = file.getName();
            File file2 = new File(string4, string6);
            if (file2.exists()) {
                file2.delete();
            }
            if (!file.renameTo(file2)) {
                Debug.error("ExtensionManager: Failed to install " + file.getName() + " to " + file2.getAbsolutePath(), new Object[0]);
                return false;
            }
            this.addExtension(string, file.getAbsolutePath(), string3);
        }
        catch (IOException iOException) {
            Debug.error("ExtensionManager: Failed to download " + string2, new Object[0]);
            return false;
        }
        return true;
    }

    private void addExtension(String string, String string2, String string3) {
        Extension extension = this.find(string, string3);
        if (extension == null) {
            this.extensions.add(new Extension(string, string2, string3));
        } else {
            extension.path = string2;
        }
    }

    public boolean isInstalled(String string) {
        return this.find(string) != null;
    }

    public String getLoadPath(String string) {
        Extension extension = this.find(string);
        if (extension != null) {
            Debug.log(2, "ExtensionManager: found: " + string + " ( " + extension.version + " )", new Object[0]);
            return extension.path;
        }
        if (!string.endsWith(".jar")) {
            Debug.error("ExtensionManager: not found: " + string, new Object[0]);
        }
        return null;
    }

    public boolean isOutOfDate(String string, String string2) {
        String string3;
        Extension extension = this.find(string);
        if (extension == null) {
            return false;
        }
        String string4 = ExtensionManager.normalisedVersion(extension.version);
        int n = string4.compareTo(string3 = ExtensionManager.normalisedVersion(string2));
        return n < 0;
    }

    public String getVersion(String string) {
        Extension extension = this.find(string);
        if (extension != null) {
            return extension.version;
        }
        return null;
    }

    private Extension find(String string) {
        if (string.endsWith(".jar")) {
            string = string.substring(0, string.length() - 4);
        }
        if (string.contains("-")) {
            String string2 = string.substring(string.lastIndexOf("-") + 1);
            return this.find(string.substring(0, string.lastIndexOf("-")), string2);
        }
        String string3 = ExtensionManager.normalisedVersion("0.0");
        Extension extension = null;
        for (Extension extension2 : this.extensions) {
            if (!extension2.name.equals(string) || string3.compareTo(ExtensionManager.normalisedVersion(extension2.version)) > 0) continue;
            extension = extension2;
            string3 = ExtensionManager.normalisedVersion(extension2.version);
        }
        return extension;
    }

    private Extension find(String string, String string2) {
        String string3 = ExtensionManager.normalisedVersion(string2);
        for (Extension extension : this.extensions) {
            if (!extension.name.equals(string) || !ExtensionManager.normalisedVersion(extension.version).equals(string3)) continue;
            return extension;
        }
        return null;
    }

    private static String normalisedVersion(String string) {
        return ExtensionManager.normalisedVersion(string, ".", 4);
    }

    private static String normalisedVersion(String string, String string2, int n) {
        String[] stringArray = Pattern.compile(string2, 16).split(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            stringBuilder.append(String.format("%" + n + 's', string3));
        }
        return stringBuilder.toString();
    }
}

