/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import org.sikuli.script.Debug;
import org.sikuli.script.Settings;

public class FileManager {
    private static File jniDir = null;
    private static String jarResources = Settings.jarResources;
    private static String libSource = Settings.libSource;
    private static final ArrayList<String> libPaths = new ArrayList();
    private static StringBuffer alreadyLoaded = new StringBuffer("");
    static final int DOWNLOAD_BUFFER_SIZE = 153600;
    private static List<String> libsList = new ArrayList<String>();
    private static ClassLoader cl = FileManager.class.getClassLoader();

    public static void loadLibrary(String string) {
        if (libPaths.size() == 0) {
            libPaths.add(Settings.libPath);
        }
        File file = null;
        boolean bl = false;
        try {
            file = FileManager.extractJni(string);
            if (file == null) {
                Debug.log(2, "Native library already loaded: " + string, new Object[0]);
                return;
            }
            Debug.log(2, "Native library found: " + string, new Object[0]);
            bl = true;
        }
        catch (IOException iOException) {
            Debug.error(FileManager.class.getName() + ".loadLibrary: Native library could not be extracted nor found: " + string, new Object[0]);
            System.exit(1);
        }
        try {
            System.load(file.getAbsolutePath());
        }
        catch (Error error) {
            Debug.error(FileManager.class.getName() + ".loadLibrary: Native library could not be loaded: " + string, new Object[0]);
            if (bl) {
                Debug.error("Since native library was found, it might be a problem with needed dependent libraries", new Object[0]);
                error.printStackTrace();
            }
            System.exit(1);
        }
        Debug.log(2, "Native library loaded: " + string, new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File extractJni(String string) throws IOException {
        if (alreadyLoaded.indexOf("*" + string) >= 0) return null;
        alreadyLoaded.append("*" + string);
        String string2 = System.mapLibraryName(string);
        File file = new File(FileManager.getJniDir(), string2);
        if (file.exists()) return file;
        URL uRL = cl.getResource(libSource + string2);
        if (uRL != null) return FileManager.extractJniResource(libSource + string2, file);
        if (!string2.endsWith(".jnilib")) throw new IOException("Library " + string2 + " not on classpath nor in default location");
        string2 = string2.substring(0, string2.length() - 7) + ".dylib";
        String string3 = string2.toString();
        file = new File(FileManager.getJniDir(), string3);
        if (file.exists()) return file;
        if (cl.getResource(libSource + string2) != null) return FileManager.extractJniResource(libSource + string2, file);
        throw new IOException("Library " + string2 + " not on classpath nor in default location");
    }

    private static File getJniDir() throws IOException {
        if (jniDir == null) {
            Debug.log(2, "Checking JNI library working directory", new Object[0]);
            for (String string : libPaths) {
                if (string == null || "".equals(string) || !(jniDir = new File(string)).exists()) continue;
                System.setProperty("java.library.tmpdir", string);
                Debug.log(2, "Using as JNI library working directory: '" + jniDir + "'", new Object[0]);
                Debug.log(2, "Using JNI directory as OCR directory (tessdata) too", new Object[0]);
                Settings.OcrDataPath = jniDir.getAbsolutePath();
                return jniDir;
            }
            String string = Settings.BaseTempPath + File.separator + "tmplib";
            System.setProperty("java.library.tmpdir", string);
            jniDir = new File(string);
            Debug.log(2, "Initialised JNI library working directory to '" + jniDir + "'", new Object[0]);
        }
        if (!jniDir.exists() && !jniDir.mkdirs()) {
            throw new IOException("Unable to create JNI library working directory " + jniDir);
        }
        return jniDir;
    }

    private static File extractJniResource(String string, File file) throws IOException {
        InputStream inputStream = cl.getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("Resource " + string + " not on classpath");
        }
        Debug.log(2, "Extracting '" + string + "' to '" + file.getAbsolutePath() + "'", new Object[0]);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        FileManager.copy(inputStream, fileOutputStream);
        ((OutputStream)fileOutputStream).close();
        inputStream.close();
        return file;
    }

    private static File extractJniResource(String string, String string2) throws IOException {
        return FileManager.extractJniResource(string, new File(string2));
    }

    private static void extractLibs() {
        Debug.log(2, "FileManager: trying to acces jar", new Object[0]);
        CodeSource codeSource = FileManager.class.getProtectionDomain().getCodeSource();
        int n = 0;
        int n2 = 0;
        if (codeSource != null) {
            URL uRL = codeSource.getLocation();
            if (!uRL.toString().endsWith(".jar")) {
                Debug.log(2, "FileManager: not running from jar", new Object[0]);
            } else {
                try {
                    ZipEntry zipEntry;
                    ZipInputStream zipInputStream = new ZipInputStream(uRL.openStream());
                    Debug.log(2, "FileManager: accessing jar: " + uRL.toString(), new Object[0]);
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        String string = zipEntry.getName();
                        if (!string.startsWith("META-INF/libs")) continue;
                        libsList.add(string);
                        if (string.endsWith(File.separator)) {
                            ++n;
                            continue;
                        }
                        ++n2;
                    }
                    Debug.log(2, "FileManager: found in META-INF/libs: Dirs: " + n + " Files: " + n2, new Object[0]);
                }
                catch (IOException iOException) {
                    Debug.error("FileManager: List jar did not work", new Object[0]);
                }
            }
        } else {
            Debug.error("FileManager: cannot access jar", new Object[0]);
        }
    }

    public static String extract(String string) throws IOException {
        InputStream inputStream = cl.getResourceAsStream(string + "/filelist.txt");
        String string2 = Settings.BaseTempPath + File.separator + "sikuli" + File.separator + string;
        new File(string2).mkdirs();
        Debug.log(4, "extract resources " + string + " to " + string2, new Object[0]);
        FileManager.writeFileList(inputStream, string, string2);
        return string2 + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String string, String string2) throws IOException {
        Debug.log(7, "FileManager: JarResource: copy " + string + " to " + string2, new Object[0]);
        File file = new File(string2);
        file.getParentFile().mkdirs();
        InputStream inputStream = cl.getResourceAsStream(string);
        if (inputStream != null) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                FileManager.copy(inputStream, fileOutputStream);
            }
            catch (IOException iOException) {
                Debug.log(7, "FileManager: JarResource: Can't extract " + string + ": " + iOException.getMessage(), new Object[0]);
            }
            finally {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
        } else {
            Debug.log(7, "FileManager: JarResource: not found: " + string, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFileList(InputStream inputStream, String string, String string2) throws IOException {
        String string3;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string3 = bufferedReader.readLine()) != null) {
            Debug.log(7, "write " + string3, new Object[0]);
            if (string3.startsWith("./")) {
                string3 = string3.substring(1);
            }
            String string4 = string2 + string3;
            File file = new File(string4);
            file.getParentFile().mkdirs();
            InputStream inputStream2 = cl.getResourceAsStream(string + string3);
            if (inputStream2 != null) {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    FileManager.copy(inputStream2, fileOutputStream);
                    continue;
                }
                catch (IOException iOException) {
                    Debug.log("Can't extract " + string + string3 + ": " + iOException.getMessage(), new Object[0]);
                    continue;
                }
                finally {
                    if (fileOutputStream != null) {
                        ((OutputStream)fileOutputStream).close();
                    }
                    continue;
                }
            }
            Debug.log("Resource not found: " + string + string3, new Object[0]);
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[8192];
        int n = 0;
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static String downloadURL(URL uRL, String string) throws IOException {
        InputStream inputStream = uRL.openStream();
        String[] stringArray = uRL.getPath().split("/");
        String string2 = stringArray[stringArray.length - 1];
        File file = new File(string, string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[153600];
        int n = 0;
        int n2 = 0;
        while ((n2 = inputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n2);
            n += n2;
        }
        inputStream.close();
        fileOutputStream.close();
        return file.getAbsolutePath();
    }

    public static String unzipSKL(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                throw new IOException(string + ": No such file");
            }
            String string2 = file.getName();
            string2 = string2.substring(0, string2.lastIndexOf(46));
            File file2 = FileManager.createTempDir();
            File file3 = new File(file2 + File.separator + string2 + ".sikuli");
            file3.mkdir();
            FileManager.unzip(string, file3.getAbsolutePath());
            return file3.getAbsolutePath();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            return null;
        }
    }

    public static File createTempDir() {
        Random random = new Random();
        int n = 1 + random.nextInt();
        File file = new File(Settings.BaseTempPath + File.separator + "tmp-" + n + ".sikuli");
        if (!file.exists()) {
            file.mkdirs();
        }
        file.deleteOnExit();
        Debug.log(2, "FileManager: tempdir create: %s", file);
        return file;
    }

    public static void deleteTempDir(String string) {
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                new File(file, string2).delete();
            }
        }
        file.delete();
        if (file.exists()) {
            Debug.log(2, "FileManager: tempdir delete not possible: %s", file);
        } else {
            Debug.log(2, "FileManager: tempdir delete: %s", file);
        }
    }

    public static File createTempFile(String string) {
        return FileManager.createTempFile(string, null);
    }

    public static File createTempFile(String string, String string2) {
        String string3 = "sikuli-";
        String string4 = "." + string;
        File file = null;
        if (string2 != null) {
            file = new File(string2);
        }
        try {
            File file2 = File.createTempFile(string3, string4, file);
            file2.deleteOnExit();
            Debug.log(2, "FileManager: tempfile create: %s", file2.getAbsolutePath());
            return file2;
        }
        catch (IOException iOException) {
            Debug.error("FileManager.createTempFile: IOException: %s", file + File.pathSeparator + string3 + "12....56" + string4);
            return null;
        }
    }

    public static String saveTmpImage(BufferedImage bufferedImage) {
        return FileManager.saveTmpImage(bufferedImage, null);
    }

    public static String saveTmpImage(BufferedImage bufferedImage, String string) {
        try {
            File file = FileManager.createTempFile("png", string);
            if (file != null) {
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                return file.getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static void unzip(String string, String string2) throws IOException, FileNotFoundException {
        ZipEntry zipEntry;
        FileInputStream fileInputStream = new FileInputStream(string);
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            byte[] byArray = new byte[2048];
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string2, zipEntry.getName()));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
            while ((n = zipInputStream.read(byArray, 0, 2048)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.close();
        }
        zipInputStream.close();
    }

    public static void openURL(String string) {
        try {
            URL uRL = new URL(string);
            Desktop.getDesktop().browse(uRL.toURI());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void xcopy(String string, String string2, String string3) throws IOException {
        File file = new File(string);
        File file2 = new File(string2);
        if (file.getAbsolutePath().equals(file2.getAbsolutePath())) {
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray;
            if (!file2.exists()) {
                file2.mkdir();
            }
            for (String string4 : stringArray = file.list()) {
                if (string3 != null && (string4.endsWith(".py") || string4.endsWith(".html")) && string4.startsWith(string3 + ".")) {
                    Debug.log(2, "SaveAs: deleting %s", string4);
                    continue;
                }
                FileManager.xcopy(string + File.separator + string4, string2 + File.separator + string4, null);
            }
        } else {
            int n;
            if (file2.isDirectory()) {
                string2 = string2 + File.separator + file.getName();
            }
            FileInputStream fileInputStream = new FileInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static File smartCopy(String string, String string2) throws IOException {
        File file = new File(string);
        String string3 = file.getName();
        File file2 = new File(string2, string3);
        if (file.equals(file2)) {
            return file2;
        }
        while (file2.exists()) {
            string3 = FileManager.getAltFilename(string3);
            file2 = new File(string2, string3);
        }
        FileManager.xcopy(string, file2.getAbsolutePath(), null);
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }

    public static String getAltFilename(String string) {
        String string2;
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(45);
        int n3 = 1;
        String string3 = string.substring(n);
        if (n2 >= 0) {
            string2 = string.substring(0, n2);
            n3 = Integer.parseInt(string.substring(n2 + 1, n));
            ++n3;
        } else {
            string2 = string.substring(0, n);
        }
        return string2 + "-" + n3 + string3;
    }

    public static boolean exists(String string) {
        File file = new File(string);
        return file.exists();
    }

    public static void mkdir(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public static String getName(String string) {
        File file = new File(string);
        return file.getName();
    }

    public static String slashify(String string, boolean bl) {
        String string2;
        if (string == null) {
            string2 = "";
        } else {
            string2 = string;
            if (File.separatorChar != '/') {
                string2 = string2.replace(File.separatorChar, '/');
            }
            if (bl) {
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
            } else if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return string2;
    }
}

