/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import org.sikuli.script.Debug;
import org.sikuli.script.FileManager;
import org.sikuli.script.ImageLocator;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;
import org.sikuli.script.TextRecognizer;
import org.sikuli.script.natives.FindInput;
import org.sikuli.script.natives.FindResult;
import org.sikuli.script.natives.FindResults;
import org.sikuli.script.natives.OpenCV;
import org.sikuli.script.natives.Vision;

public class Finder
implements Iterator<Match> {
    private Region _region = null;
    private Pattern _pattern = null;
    private FindInput _findInput = new FindInput();
    private FindResults _results = null;
    private int _cur_result_i;
    private boolean repeating = false;

    public Finder(String string) throws IOException {
        this(string, null);
    }

    public Finder(String string, Region region) throws IOException {
        String string2 = ImageLocator.locate(string);
        this._findInput.setSource(string2);
        this._region = region;
    }

    public Finder(BufferedImage bufferedImage) {
        this._findInput.setSource(OpenCV.convertBufferedImageToMat(bufferedImage));
    }

    public Finder(ScreenImage screenImage) {
        this.initScreenFinder(screenImage, null);
    }

    public Finder(ScreenImage screenImage, Region region) {
        this.initScreenFinder(screenImage, region);
    }

    private void initScreenFinder(ScreenImage screenImage, Region region) {
        this.setScreenImage(screenImage);
        this._region = region;
    }

    public void destroy() {
        this._findInput.delete();
        this._findInput = null;
        this._results.delete();
        this._results = null;
        this._pattern = null;
    }

    public void setScreenImage(ScreenImage screenImage) {
        this._findInput.setSource(OpenCV.convertBufferedImageToMat(screenImage.getImage()));
    }

    public void setRepeating() {
        this.repeating = true;
    }

    public void findRepeat() {
        this._results = Vision.find(this._findInput);
        this._cur_result_i = 0;
    }

    public String find(String string, double d) {
        String string2 = this.setTargetSmartly(this._findInput, string);
        if (null == string2) {
            return null;
        }
        if (string2.equals(string + "???")) {
            return string2;
        }
        this._findInput.setSimilarity(d);
        this._results = Vision.find(this._findInput);
        this._cur_result_i = 0;
        return string2;
    }

    public String find(Pattern pattern) {
        this._pattern = pattern;
        String string = pattern.getFilename();
        if (string == null) {
            return null;
        }
        this._findInput.setTarget(0, string);
        this._findInput.setSimilarity(pattern.getSimilar());
        this._results = Vision.find(this._findInput);
        this._cur_result_i = 0;
        return string;
    }

    public String find(String string) {
        return this.find(string, Settings.MinSimilarity);
    }

    public void findAllRepeat() {
        Debug debug = new Debug();
        debug.startTiming("Finder.findAll", new Object[0]);
        this._results = Vision.find(this._findInput);
        this._cur_result_i = 0;
        debug.endTiming("Finder.findAll", new Object[0]);
    }

    public String findAll(String string, double d) {
        String string2 = this.setTargetSmartly(this._findInput, string);
        if (null == string2) {
            return null;
        }
        if (string2.equals(string + "???")) {
            return string2;
        }
        Debug debug = new Debug();
        debug.startTiming("Finder.findAll", new Object[0]);
        this.setTargetSmartly(this._findInput, string);
        this._findInput.setSimilarity(d);
        this._findInput.setFindAll(true);
        this._results = Vision.find(this._findInput);
        this._cur_result_i = 0;
        debug.endTiming("Finder.findAll", new Object[0]);
        return string2;
    }

    public String findAll(Pattern pattern) {
        this._pattern = pattern;
        String string = pattern.getFilename();
        if (string == null) {
            return null;
        }
        this._findInput.setTarget(0, string);
        this._findInput.setSimilarity(pattern.getSimilar());
        this._findInput.setFindAll(true);
        Debug debug = new Debug();
        debug.startTiming("Finder.findAll", new Object[0]);
        this._results = Vision.find(this._findInput);
        this._cur_result_i = 0;
        debug.endTiming("Finder.findAll", new Object[0]);
        return pattern.getFilename();
    }

    public String findAll(String string) {
        return this.findAll(string, Settings.MinSimilarity);
    }

    private String setTargetSmartly(FindInput findInput, String string) {
        block5: {
            if (Finder.isImageFile(string)) {
                try {
                    String string2 = ImageLocator.locate(string);
                    findInput.setTarget(0, string2);
                    return string2;
                }
                catch (IOException iOException) {
                    if (this.repeating) break block5;
                    Debug.error(string + " looks like a file, but not on disk. Assume it's text.", new Object[0]);
                }
            }
        }
        if (!Settings.OcrTextSearch) {
            Debug.error("Region.find(text): text search is currently switched off", new Object[0]);
            return string + "???";
        }
        findInput.setTarget(1, string);
        if (TextRecognizer.getInstance() == null) {
            Debug.error("Region.find(text): text search is now switched off", new Object[0]);
            return string + "???";
        }
        return string;
    }

    private static boolean isImageFile(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return false;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        return string2.equals("png") || string2.equals("jpg");
    }

    @Override
    public boolean hasNext() {
        return this._results != null && this._results.size() > (long)this._cur_result_i;
    }

    @Override
    public Match next() {
        Match match = null;
        if (this.hasNext()) {
            FindResult findResult = this._results.get(this._cur_result_i++);
            Screen screen = null;
            if (this._region != null) {
                screen = this._region.getScreen();
            }
            match = new Match(findResult, screen);
            findResult.delete();
            if (this._region != null) {
                match = this._region.toGlobalCoord(match);
            }
            if (this._pattern != null) {
                Location location = this._pattern.getTargetOffset();
                match.setTargetOffset(location);
            }
        }
        return match;
    }

    @Override
    public void remove() {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    static {
        FileManager.loadLibrary("VisionProxy");
    }
}

