/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.event.KeyEvent;
import java.lang.reflect.Constructor;
import org.sikuli.script.Debug;
import org.sikuli.script.HotkeyListener;
import org.sikuli.script.Key;
import org.sikuli.script.Settings;

public abstract class HotkeyManager {
    protected static HotkeyManager _instance = null;

    public static HotkeyManager getInstance() {
        String string;
        if (_instance == null && (string = HotkeyManager.getOSHotkeyManagerClass()) != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                _instance = (HotkeyManager)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                Debug.error("Can't create " + string + ": " + exception.getMessage(), new Object[0]);
            }
        }
        return _instance;
    }

    private static String getOSHotkeyManagerClass() {
        String string = "org.sikuli.system.";
        int n = Settings.getOS();
        switch (n) {
            case 1: {
                return string + "MacHotkeyManager";
            }
            case 0: {
                return string + "WindowsHotkeyManager";
            }
            case 2: {
                return string + "LinuxHotkeyManager";
            }
        }
        Debug.error("Error: Hotkey registration is not supported on your OS.", new Object[0]);
        return null;
    }

    protected String getKeyCodeText(int n) {
        return KeyEvent.getKeyText(n).toUpperCase();
    }

    protected String getKeyModifierText(int n) {
        String string = KeyEvent.getKeyModifiersText(n).toUpperCase();
        if (Settings.isMac()) {
            string = string.replace("META", "CMD");
            string = string.replace("WINDOWS", "CMD");
        } else {
            string = string.replace("META", "WIN");
            string = string.replace("WINDOWS", "WIN");
        }
        return string;
    }

    public boolean addHotkey(String string, int n, HotkeyListener hotkeyListener) {
        return this.addHotkey(string.charAt(0), n, hotkeyListener);
    }

    public boolean addHotkey(char c, int n, HotkeyListener hotkeyListener) {
        int[] nArray = Key.toJavaKeyCode(c);
        int n2 = nArray[nArray.length - 1];
        String string = this.getKeyModifierText(n);
        String string2 = this.getKeyCodeText(n2);
        Debug.info("add hotkey: " + string + " " + string2, new Object[0]);
        return _instance._addHotkey(n2, n, hotkeyListener);
    }

    public boolean removeHotkey(String string, int n) {
        return this.removeHotkey(string.charAt(0), n);
    }

    public boolean removeHotkey(char c, int n) {
        int[] nArray = Key.toJavaKeyCode(c);
        int n2 = nArray[nArray.length - 1];
        String string = this.getKeyModifierText(n);
        String string2 = this.getKeyCodeText(n2);
        Debug.info("remove hotkey: " + string + " " + string2, new Object[0]);
        return _instance._removeHotkey(n2, n);
    }

    public abstract boolean _addHotkey(int var1, int var2, HotkeyListener var3);

    public abstract boolean _removeHotkey(int var1, int var2);

    public abstract void cleanUp();
}

