/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import javax.imageio.ImageIO;
import org.sikuli.script.Debug;
import org.sikuli.script.FileManager;
import org.sikuli.script.Settings;

public class ImageLocator {
    static ArrayList<String> pathList = new ArrayList();
    static int firstEntries = 1;
    static File _cache_dir_global = new File(Settings.BaseTempPath, "sikuli_cache/SIKULI_GLOBAL/");
    static Map<URI, String> _cache = new HashMap<URI, String>();

    private static String[] splitImagePath(String string) {
        if (string == null || "".equals(string)) {
            return new String[0];
        }
        string = string.replaceAll("[Hh][Tt][Tt][Pp]://", "__http__//");
        string = string.replaceAll("[Hh][Tt][Tt][Pp][Ss]://", "__https__//");
        String[] stringArray = string.split(Settings.getPathSeparator());
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            string = stringArray[i];
            if (string.indexOf("__http__") >= 0) {
                string = string.replaceAll("__http__//", "http://");
                bl = true;
            } else if (string.indexOf("__https__") >= 0) {
                string = string.replaceAll("__https__//", "https://");
                bl = true;
            }
            if (bl) {
                if ((string = ImageLocator.getURL(string).getPath()) != null) {
                    if (string.endsWith("/")) continue;
                    stringArray[i] = string + "/";
                    continue;
                }
                stringArray[i] = null;
                continue;
            }
            File file = new File(string);
            if (file.exists()) {
                stringArray[i] = file.getAbsolutePath() + File.separator;
                continue;
            }
            pathList.remove(stringArray[i]);
            stringArray[i] = null;
        }
        return stringArray;
    }

    private static URL getURL(String string) {
        try {
            URL uRL = new URL(string);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String[] getImagePath() {
        return pathList.toArray(new String[0]);
    }

    private static String addImagePath(String[] stringArray, boolean bl) {
        int n = firstEntries;
        if (n == pathList.size()) {
            bl = false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i] == null || pathList.contains(string = stringArray[i])) continue;
            if (!bl) {
                pathList.add(string);
                continue;
            }
            pathList.add(n, string);
            ++n;
        }
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    private static String addImagePath(String string, boolean bl) {
        String[] stringArray = ImageLocator.splitImagePath(string);
        ImageLocator.removeImagePath(stringArray);
        return ImageLocator.addImagePath(stringArray, bl);
    }

    public static String addImagePath(String string) {
        return ImageLocator.addImagePath(string, false);
    }

    public static String addImagePathFirst(String string) {
        return ImageLocator.addImagePath(string, true);
    }

    public static String addImagePath(String[] stringArray) {
        return ImageLocator.addImagePath(stringArray, false);
    }

    public static String addImagePathFirst(String[] stringArray) {
        return ImageLocator.addImagePath(stringArray, true);
    }

    public static void removeImagePath(String string) {
        String[] stringArray = ImageLocator.splitImagePath(string);
        pathList.set(0, null);
        ImageLocator.removeImagePath(stringArray);
        pathList.set(0, Settings.BundlePath + File.separator);
    }

    public static void removeImagePath(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            pathList.remove(stringArray[i]);
        }
    }

    private static void clearImagePath() {
        ListIterator<String> listIterator = pathList.listIterator(1);
        while (listIterator.hasNext()) {
            if (((String)listIterator.next()).endsWith(".sikuli" + File.separator)) continue;
            listIterator.remove();
        }
        if (firstEntries == pathList.size()) {
            ImageLocator.addImagePath(System.getenv("SIKULI_IMAGE_PATH"));
            ImageLocator.addImagePath(System.getProperty("SIKULI_IMAGE_PATH"));
        } else {
            ImageLocator.addImagePathFirst(System.getProperty("SIKULI_IMAGE_PATH"));
            ImageLocator.addImagePathFirst(System.getenv("SIKULI_IMAGE_PATH"));
        }
    }

    public static void resetImagePath(String string) {
        ImageLocator.clearImagePath();
        ImageLocator.addImagePath(string);
    }

    public static void resetImagePath(String[] stringArray) {
        ImageLocator.clearImagePath();
        ImageLocator.addImagePath(stringArray);
    }

    public static void setBundlePath(String string) {
        String[] stringArray = ImageLocator.splitImagePath(string);
        if (stringArray.length > 0) {
            pathList.set(0, stringArray[0]);
            Settings.BundlePath = stringArray[0].substring(0, stringArray[0].length() - 1);
        }
    }

    public static String getBundlePath() {
        return Settings.BundlePath;
    }

    private static String searchFile(String string) {
        for (String string2 : pathList) {
            File file;
            URL uRL = ImageLocator.getURL(string2);
            if (uRL != null) {
                try {
                    String string3 = ImageLocator.getFileFromURL(new URL(uRL, string));
                    if (string3 != null) {
                        return string3;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (!(file = new File(string2, string)).exists()) continue;
            Debug.log(2, "ImageLocator: found " + string + " in " + string2, new Object[0]);
            return file.getAbsolutePath();
        }
        return null;
    }

    private static String getFileFromURL(URL uRL) {
        if (_cache_dir_global == null) {
            Debug.error("ImageLocator.getFileFromURL: Local cache dir not available - cannot download from url" + uRL, new Object[0]);
            return null;
        }
        try {
            URI uRI = uRL.toURI();
            if (_cache.containsKey(uRI)) {
                Debug.log(2, "ImageLocator.getFileFromURL: " + uRI + " taken from cache", new Object[0]);
                return _cache.get(uRI);
            }
            String string = FileManager.downloadURL(uRL, _cache_dir_global.getPath());
            Debug.log(2, "ImageLocator.getFileFromURL: download " + uRI + " to local: " + string, new Object[0]);
            _cache.put(uRI, string);
            return string;
        }
        catch (URISyntaxException uRISyntaxException) {
            Debug.log(2, "ImageLocator.getFileFromURL: URI syntax error: " + uRL + ", " + uRISyntaxException.getMessage(), new Object[0]);
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String locate(String string) throws IOException {
        if (string != null) {
            String string2;
            URL uRL = ImageLocator.getURL(string);
            if (uRL != null && (string2 = ImageLocator.getFileFromURL(uRL)) != null) {
                return string2;
            }
            File file = new File(string);
            if (file.isAbsolute()) {
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
            } else {
                string2 = ImageLocator.searchFile(string);
                if (string2 != null) {
                    return string2;
                }
            }
        } else {
            string = "*** not known ***";
        }
        throw new FileNotFoundException("ImageLocator.locate: " + string + " does not exist or cannot be found on ImagePath");
    }

    public static BufferedImage getImage(String string) {
        try {
            return ImageIO.read(new File(ImageLocator.locate(string)));
        }
        catch (IOException iOException) {
            Debug.log(2, "ImageLocator.getImage: " + string + " does not exist or cannot be found on ImagePath", new Object[0]);
            return null;
        }
    }

    static {
        pathList.add("");
        ImageLocator.resetImagePath("");
        if (pathList.size() >= 1 && "".equals(pathList.get(0))) {
            pathList.set(0, System.getProperty("user.dir"));
        }
        if (!_cache_dir_global.exists()) {
            try {
                _cache_dir_global.mkdir();
            }
            catch (Exception exception) {
                Debug.error("ImageLocator: Local cache dir not possible: " + _cache_dir_global, new Object[0]);
                _cache_dir_global = null;
            }
        }
    }
}

