/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Point;
import java.awt.Rectangle;
import org.sikuli.script.Debug;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;

public class Location
extends Point {
    public Location(float f, float f2) {
        super((int)f, (int)f2);
    }

    public Location(int n, int n2) {
        super(n, n2);
    }

    public Location(Location location) {
        super(location.x, location.y);
    }

    public Location(Point point) {
        super(point);
    }

    public Screen getScreenContaining(boolean bl) {
        for (int i = 0; i < Screen.getNumberScreens(); ++i) {
            Rectangle rectangle = Screen.getBounds(i);
            rectangle.setSize(rectangle.width + 1, rectangle.height + 1);
            if (!rectangle.contains(this)) continue;
            return Screen.getScreen(i);
        }
        if (bl) {
            Debug.error("Location: outside any screen (%s, %s) - subsequent actions might not work as expected", this.x, this.y);
        }
        return null;
    }

    public Screen getScreen() {
        Screen screen = this.getScreenContaining(false);
        if (screen == null) {
            return Screen.getPrimaryScreen();
        }
        return screen;
    }

    public int getColor() {
        if (this.getScreenContaining(true) == null) {
            return -1;
        }
        return this.getScreen().getActionRobot().getColorAt(this.x, this.y).getRGB();
    }

    public Point getPoint() {
        return new Point(this);
    }

    public Location getOffset(Location location) {
        return new Location(location.x - this.x, location.y - this.y);
    }

    public Region grow(int n, int n2) {
        return Region.grow(this, n, n2);
    }

    public Region grow(int n) {
        return this.grow(n, n);
    }

    public Region grow() {
        return this.grow(3, 3);
    }

    public Region grow(int n, int n2, int n3, int n4) {
        Region region = Region.create(0, 0, n3, n4);
        if (n == 0) {
            if (n2 == 0) {
                region.setLocation(this);
            } else {
                region.setBottomLeft(this);
            }
        } else if (n2 == 0) {
            region.setTopRight(this);
        } else {
            region.setBottomRight(this);
        }
        return region;
    }

    public Location moveFor(int n, int n2) {
        super.translate(n, n2);
        return this;
    }

    public Location moveTo(int n, int n2) {
        super.move(n, n2);
        return this;
    }

    public Location offset(int n, int n2) {
        return new Location(this.x + n, this.y + n2);
    }

    public Location left(int n) {
        return new Location(this.x - n, this.y);
    }

    public Location right(int n) {
        return new Location(this.x + n, this.y);
    }

    public Location above(int n) {
        return new Location(this.x, this.y - n);
    }

    public Location below(int n) {
        return new Location(this.x, this.y + n);
    }

    public Location copyTo() {
        return this.copyTo(Screen.getPrimaryScreen());
    }

    public Location copyTo(int n) {
        return this.copyTo(Screen.getScreen(n));
    }

    public Location copyTo(Screen screen) {
        Location location = new Location(this.getScreen().getBounds().getLocation());
        Location location2 = new Location(screen.getBounds().getLocation());
        return new Location(location2.x + this.x - location.x, location2.y + this.y - location.y);
    }

    public Location copyTo(Region region) {
        return this.copyTo(region.getScreen());
    }

    @Override
    public String toString() {
        return "L(" + this.x + "," + this.y + ")@" + this.getScreen().toStringShort();
    }
}

