/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.image.BufferedImage;
import org.sikuli.script.ImageLocator;
import org.sikuli.script.Location;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.Settings;
import org.sikuli.script.natives.FindResult;

public class Match
extends Region
implements Comparable {
    private double simScore;
    private Location target = null;
    private String image = null;
    private String ocrText = null;

    public Match(Match match) {
        this.init(match.x, match.y, match.w, match.h, match.getScreen());
        this.copy(match);
    }

    private Match(Match match, Screen screen) {
        this.init(match.x, match.y, match.w, match.h, screen);
        this.copy(match);
    }

    protected Match(int n, int n2, int n3, int n4, double d, Screen screen, String string) {
        this.init(n, n2, n3, n4, screen);
        this.simScore = d;
        this.ocrText = string;
    }

    private Match(int n, int n2, int n3, int n4, double d, Screen screen) {
        this.init(n, n2, n3, n4, screen);
        this.simScore = d;
    }

    protected Match(FindResult findResult, Screen screen) {
        this.init(findResult.getX(), findResult.getY(), findResult.getW(), findResult.getH(), screen);
        this.simScore = findResult.getScore();
    }

    private void init(int n, int n2, int n3, int n4, Screen screen) {
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        this.setScreen(screen);
    }

    private void copy(Match match) {
        this.simScore = match.simScore;
        this.ocrText = match.ocrText;
        this.image = match.image;
        this.target = null;
        if (match.target != null) {
            this.target = (Location)match.target.clone();
        }
    }

    public double getScore() {
        return this.simScore;
    }

    @Override
    public Location getTarget() {
        if (this.target != null) {
            return this.target;
        }
        return this.getCenter();
    }

    public void setTargetOffset(Location location) {
        this.target = new Location(this.getCenter());
        this.target.translate(location.x, location.y);
    }

    public void setTargetOffset(int n, int n2) {
        this.setTargetOffset(new Location(n, n2));
    }

    public Location getTargetOffset() {
        return this.getCenter().getOffset(this.getTarget());
    }

    protected void setImage(String string) {
        this.image = string;
        if (Settings.Highlight) {
            this.highlight(DEFAULT_HIGHLIGHT_TIME);
        }
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            return null;
        }
        return ImageLocator.getImage(this.image);
    }

    public String getImageFilename() {
        return this.image;
    }

    public String getText() {
        return this.ocrText;
    }

    public int compareTo(Object object) {
        Match match = (Match)object;
        if (this.simScore != match.simScore) {
            return this.simScore < match.simScore ? -1 : 1;
        }
        if (this.x != match.x) {
            return this.x - match.x;
        }
        if (this.y != match.y) {
            return this.y - match.y;
        }
        if (this.w != match.w) {
            return this.w - match.w;
        }
        if (this.h != match.h) {
            return this.h - match.h;
        }
        if (this.equals(object)) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Match)) {
            return false;
        }
        Match match = (Match)object;
        return this.x == match.x && this.y == match.y && this.w == match.w && this.h == match.h && Math.abs(this.simScore - match.simScore) < 1.0E-5 && this.getTarget().equals(match.getTarget());
    }

    @Override
    public String toString() {
        Location location = this.getCenter();
        String string = this.target != null && !location.equals(this.target) ? String.format("Target:%d,%d", this.target.x, this.target.y) : String.format("Center:%d,%d", location.x, location.y);
        return String.format("M[%d,%d %dx%d]@%s S:%.2f %s", this.x, this.y, this.w, this.h, this.getScreen() == null ? "Screen???" : this.getScreen().toStringShort(), this.simScore, string);
    }
}

