/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RescaleOp;
import org.sikuli.script.Debug;
import org.sikuli.script.EventObserver;
import org.sikuli.script.EventSubject;
import org.sikuli.script.OverlayTransparentWindow;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.ScreenUnion;
import org.sikuli.script.Settings;

public class OverlayCapturePrompt
extends OverlayTransparentWindow
implements EventSubject {
    static Color _overlayColor = new Color(0.0f, 0.0f, 0.0f, 0.6f);
    static final float MIN_DARKER_FACTOR = 0.6f;
    static final long MSG_DISPLAY_TIME = 2000L;
    static final long WIN_FADE_IN_TIME = 200L;
    static final Font fontMsg = new Font("Arial", 0, 60);
    static final Color selFrameColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    static final Color selCrossColor = new Color(1.0f, 0.0f, 0.0f, 0.6f);
    static final Color screenFrameColor = new Color(1.0f, 0.0f, 0.0f, 0.6f);
    static final BasicStroke strokeScreenFrame = new BasicStroke(5.0f);
    static final BasicStroke _StrokeCross = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f);
    static final BasicStroke bs = new BasicStroke(1.0f);
    EventObserver _obs;
    Screen _scr;
    BufferedImage _scr_img = null;
    BufferedImage _darker_screen = null;
    BufferedImage bi = null;
    float _darker_factor;
    Rectangle rectSelection;
    int srcScreenId = 0;
    int srcx;
    int srcy;
    int destx;
    int desty;
    boolean _canceled = false;
    String _msg;

    public OverlayCapturePrompt(Screen screen, EventObserver eventObserver) {
        this.init(screen, eventObserver);
    }

    private void init(Screen screen, EventObserver eventObserver) {
        this.addObserver(eventObserver);
        if (screen == null) {
            screen = Screen.getNumberScreens() > 1 ? new ScreenUnion() : Screen.getPrimaryScreen();
        }
        this._scr = screen;
        this._canceled = false;
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.rectSelection = new Rectangle();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (OverlayCapturePrompt.this._scr_img == null) {
                    return;
                }
                OverlayCapturePrompt.this.destx = OverlayCapturePrompt.this.srcx = mouseEvent.getX();
                OverlayCapturePrompt.this.desty = OverlayCapturePrompt.this.srcy = mouseEvent.getY();
                OverlayCapturePrompt.this.srcScreenId = new ScreenUnion().getIdFromPoint(OverlayCapturePrompt.this.srcx, OverlayCapturePrompt.this.srcy);
                Debug.log(2, "CapturePrompt: started at " + OverlayCapturePrompt.this.srcx + "," + OverlayCapturePrompt.this.srcy + " at screen " + OverlayCapturePrompt.this.srcScreenId, new Object[0]);
                OverlayCapturePrompt.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (OverlayCapturePrompt.this._scr_img == null) {
                    return;
                }
                if (mouseEvent.getButton() == 3) {
                    OverlayCapturePrompt.this._canceled = true;
                    Debug.log(2, "CapturePrompt: aborted using right mouse button", new Object[0]);
                } else {
                    Debug.log(2, "CapturePrompt: finished at " + mouseEvent.getX() + "," + mouseEvent.getY(), new Object[0]);
                }
                OverlayCapturePrompt.this.setVisible(false);
                OverlayCapturePrompt.this.notifyObserver();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (OverlayCapturePrompt.this._scr_img == null) {
                    return;
                }
                OverlayCapturePrompt.this.destx = mouseEvent.getX();
                OverlayCapturePrompt.this.desty = mouseEvent.getY();
                OverlayCapturePrompt.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    OverlayCapturePrompt.this._canceled = true;
                    Debug.log(2, "CapturePrompt: aborted using key ESC", new Object[0]);
                    OverlayCapturePrompt.this.setVisible(false);
                    OverlayCapturePrompt.this.notifyObserver();
                }
            }
        });
    }

    @Override
    public void close() {
        Debug.log(2, "CapturePrompt.close: freeing resources", new Object[0]);
        this.dispose();
        this._scr_img = null;
        this._darker_screen = null;
        this.bi = null;
    }

    @Override
    public void addObserver(EventObserver eventObserver) {
        this._obs = eventObserver;
    }

    @Override
    public void notifyObserver() {
        this._obs.update(this);
    }

    public void prompt(String string, int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.prompt(string);
    }

    public void prompt(int n) {
        this.prompt(null, n);
    }

    public void prompt() {
        this.prompt(null);
    }

    public void prompt(String string) {
        this.captureScreen(this._scr);
        this.setBounds(this._scr.getBounds());
        this.setAlwaysOnTop(true);
        this._msg = string;
        this.setVisible(true);
        if (!Settings.isJava7() && Settings.isMac()) {
            Settings.getOSUtil().bringWindowToFront(this, false);
        }
        this.requestFocus();
    }

    private void captureScreen(Screen screen) {
        ScreenImage screenImage = screen.capture();
        this._scr_img = screenImage.getImage();
        this._darker_factor = 0.6f;
        RescaleOp rescaleOp = new RescaleOp(this._darker_factor, 0.0f, null);
        this._darker_screen = rescaleOp.filter(this._scr_img, null);
    }

    public ScreenImage getSelection() {
        if (this._canceled) {
            return null;
        }
        BufferedImage bufferedImage = this.cropSelection();
        if (bufferedImage == null) {
            return null;
        }
        this.rectSelection.x += this._scr.getBounds().x;
        this.rectSelection.y += this._scr.getBounds().y;
        ScreenImage screenImage = new ScreenImage(this.rectSelection, bufferedImage);
        return screenImage;
    }

    private BufferedImage cropSelection() {
        int n = this.rectSelection.width;
        int n2 = this.rectSelection.height;
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.drawImage(this._scr_img.getSubimage(this.rectSelection.x, this.rectSelection.y, n, n2), null, 0, 0);
        }
        catch (RasterFormatException rasterFormatException) {
            rasterFormatException.printStackTrace();
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    void drawMessage(Graphics2D graphics2D) {
        if (this._msg == null) {
            return;
        }
        graphics2D.setFont(fontMsg);
        graphics2D.setColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        int n = graphics2D.getFontMetrics().stringWidth(this._msg);
        int n2 = graphics2D.getFontMetrics().getMaxAscent();
        Rectangle rectangle = new ScreenUnion().getBounds();
        for (int i = 0; i < Screen.getNumberScreens(); ++i) {
            Rectangle rectangle2 = Screen.getBounds(i);
            int n3 = rectangle2.x + (rectangle2.width - n) / 2 - rectangle.x;
            int n4 = rectangle2.y + (rectangle2.height - n2) / 2 - rectangle.y;
            graphics2D.drawString(this._msg, n3, n4);
        }
    }

    private void drawSelection(Graphics2D graphics2D) {
        if (this.srcx != this.destx || this.srcy != this.desty) {
            int n;
            int n2 = this.srcx < this.destx ? this.srcx : this.destx;
            int n3 = this.srcy < this.desty ? this.srcy : this.desty;
            int n4 = this.srcx > this.destx ? this.srcx : this.destx;
            int n5 = n = this.srcy > this.desty ? this.srcy : this.desty;
            if (Screen.getNumberScreens() > 1) {
                Rectangle rectangle = new Rectangle(n2, n3, n4 - n2, n - n3);
                Rectangle rectangle2 = new ScreenUnion().getBounds();
                rectangle.x += rectangle2.x;
                rectangle.y += rectangle2.y;
                Rectangle rectangle3 = rectangle.intersection(Screen.getBounds(this.srcScreenId));
                n2 = rectangle3.x - rectangle2.x;
                n3 = rectangle3.y - rectangle2.y;
                n4 = n2 + rectangle3.width - 1;
                n = n3 + rectangle3.height - 1;
            }
            this.rectSelection.x = n2;
            this.rectSelection.y = n3;
            this.rectSelection.width = n4 - n2 + 1;
            this.rectSelection.height = n - n3 + 1;
            if (this.rectSelection.width > 0 && this.rectSelection.height > 0) {
                graphics2D.drawImage(this._scr_img.getSubimage(n2, n3, n4 - n2 + 1, n - n3 + 1), null, n2, n3);
            }
            graphics2D.setColor(selFrameColor);
            graphics2D.setStroke(bs);
            graphics2D.draw(this.rectSelection);
            int n6 = (n2 + n4) / 2;
            int n7 = (n3 + n) / 2;
            graphics2D.setColor(selCrossColor);
            graphics2D.setStroke(_StrokeCross);
            graphics2D.drawLine(n6, n3, n6, n);
            graphics2D.drawLine(n2, n7, n4, n7);
            if (Screen.getNumberScreens() > 1) {
                this.drawScreenFrame(graphics2D, this.srcScreenId);
            }
        }
    }

    private void drawScreenFrame(Graphics2D graphics2D, int n) {
        Rectangle rectangle = Screen.getBounds(n);
        Rectangle rectangle2 = new ScreenUnion().getBounds();
        graphics2D.setColor(screenFrameColor);
        graphics2D.setStroke(strokeScreenFrame);
        rectangle.x -= rectangle2.x;
        rectangle.y -= rectangle2.y;
        int n2 = (int)(strokeScreenFrame.getLineWidth() / 2.0f);
        rectangle.x += n2;
        rectangle.y += n2;
        rectangle.width -= n2 * 2;
        rectangle.height -= n2 * 2;
        graphics2D.draw(rectangle);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this._scr_img != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.bi == null) {
                this.bi = new BufferedImage(this._scr.getBounds().width, this._scr.getBounds().height, 1);
            }
            Graphics2D graphics2D2 = this.bi.createGraphics();
            graphics2D2.drawImage((Image)this._darker_screen, 0, 0, this);
            this.drawMessage(graphics2D2);
            this.drawSelection(graphics2D2);
            graphics2D.drawImage((Image)this.bi, 0, 0, this);
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }
}

