/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.image.BufferedImage;
import java.io.IOException;
import org.sikuli.script.ImageLocator;
import org.sikuli.script.Location;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;

public class Pattern {
    private String imgURL = null;
    private BufferedImage imgBuf = null;
    private float similarity = (float)Settings.MinSimilarity;
    private Location offset = new Location(0, 0);
    private static final String isBImg = "-- BufferedImage --";

    public Pattern() {
    }

    public Pattern(Pattern pattern) {
        if (pattern.imgBuf != null) {
            this.imgBuf = pattern.imgBuf.getSubimage(0, 0, pattern.imgBuf.getWidth(), this.imgBuf.getHeight());
        }
        this.imgURL = pattern.imgURL;
        this.similarity = pattern.similarity;
        this.offset.x = pattern.offset.x;
        this.offset.y = pattern.offset.y;
    }

    public Pattern(String string) {
        this.imgURL = string;
    }

    public Pattern(BufferedImage bufferedImage) {
        this.imgBuf = bufferedImage;
        this.imgURL = isBImg;
    }

    public Pattern(ScreenImage screenImage) {
        this.imgBuf = screenImage.getImage();
        this.imgURL = isBImg;
    }

    public Pattern similar(float f) {
        this.similarity = f;
        return this;
    }

    public Pattern exact() {
        this.similarity = 0.99f;
        return this;
    }

    public float getSimilar() {
        return this.similarity;
    }

    public Pattern targetOffset(int n, int n2) {
        this.offset.x = n;
        this.offset.y = n2;
        return this;
    }

    public Pattern targetOffset(Location location) {
        this.offset.x = location.x;
        this.offset.y = location.y;
        return this;
    }

    public Location getTargetOffset() {
        return this.offset;
    }

    public Pattern setFilename(String string) {
        this.imgURL = string;
        return this;
    }

    public String getFilename() {
        if (this.imgURL != null) {
            if (isBImg.equals(this.imgURL)) {
                return isBImg;
            }
            try {
                return ImageLocator.locate(this.imgURL);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public String checkFile() {
        if (this.imgBuf != null) {
            return this.imgURL;
        }
        try {
            ImageLocator.locate(this.imgURL);
            return this.imgURL;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public BufferedImage getImage() {
        if (this.imgBuf != null) {
            return this.imgBuf;
        }
        if (null != this.getFilename()) {
            return ImageLocator.getImage(this.getFilename());
        }
        return null;
    }

    public Pattern setImage(BufferedImage bufferedImage) {
        this.imgBuf = bufferedImage;
        return this;
    }

    public Pattern setImage(ScreenImage screenImage) {
        this.imgBuf = screenImage.getImage();
        return this;
    }

    public String toString() {
        String string = "P(" + this.imgURL + ")";
        string = string + " S: " + this.similarity;
        if (this.offset.x != 0 || this.offset.y != 0) {
            string = string + " T: " + this.offset.x + "," + this.offset.y;
        }
        return string;
    }
}

