/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.sikuli.script.App;
import org.sikuli.script.Debug;
import org.sikuli.script.FindFailed;
import org.sikuli.script.FindFailedDialog;
import org.sikuli.script.FindFailedResponse;
import org.sikuli.script.Finder;
import org.sikuli.script.ImageLocator;
import org.sikuli.script.Key;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Pattern;
import org.sikuli.script.RobotDesktop;
import org.sikuli.script.RobotIF;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenHighlighter;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;
import org.sikuli.script.SikuliEventManager;
import org.sikuli.script.SikuliEventObserver;
import org.sikuli.script.TextRecognizer;

public class Region {
    static final float DEFAULT_HIGHLIGHT_TIME = Settings.DefaultHighlightTime;
    static final int PADDING = 50;
    private String scriptingType = "";
    private Screen scr;
    private ScreenHighlighter overlay = null;
    public int x;
    public int y;
    public int w;
    public int h;
    protected int vWidth = -1;
    protected int vHeight = -1;
    private FindFailedResponse findFailedResponse = Settings.defaultFindFailedResponse;
    protected boolean throwException = Settings.ThrowException;
    protected double autoWaitTimeout = Settings.AutoWaitTimeout;
    private boolean observing = false;
    private SikuliEventManager evtMgr = null;
    private Match lastMatch = null;
    private Iterator<Match> lastMatches;

    public String toString() {
        return String.format("R[%d,%d %dx%d]@%s E:%s, T:%.1f", this.x, this.y, this.w, this.h, this.getScreen() == null ? "Screen???" : this.getScreen().toStringShort(), this.throwException ? "Y" : "N", this.autoWaitTimeout);
    }

    private boolean isJythonScreen() {
        return "JythonScreen".equals(this.scriptingType);
    }

    private boolean isJythonRegion() {
        return "JythonRegion".equals(this.scriptingType);
    }

    public void setScriptingType(String string) {
        this.scriptingType = string;
    }

    public String getScriptingType() {
        return this.scriptingType;
    }

    private Region initialize(int n, int n2, int n3, int n4, Screen screen) {
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        if (screen != null) {
            this.setScreen(screen);
        }
        this.initScreen(this.getScreen());
        return this;
    }

    protected int getVW() {
        return this.vWidth < 0 ? this.w : this.vWidth;
    }

    protected int getVH() {
        return this.vHeight < 0 ? this.h : this.vHeight;
    }

    private void initScreen(Screen screen) {
        if (!(this instanceof Screen) && !this.isJythonScreen()) {
            Screen screen2;
            Rectangle rectangle = new Rectangle(this.x, this.y, this.getVW(), this.getVH());
            this.setScreen(null);
            for (int i = 0; i < Screen.getNumberScreens(); ++i) {
                Rectangle rectangle2 = Screen.getBounds(i);
                if (!rectangle2.contains(rectangle.getLocation())) continue;
                this.setScreen(Screen.getScreen(i));
                break;
            }
            if ((screen2 = this.getScreen()) == null) {
                this.w = this.getVW();
                this.h = this.getVH();
                if (screen == null) {
                    Debug.error("Region (%s, %s) outside any screen - subsequent actions might not work as expected", this.w, this.h);
                } else {
                    screen2 = screen;
                }
            }
            if (screen2 != null) {
                this.setScreen(screen2);
                rectangle = screen2.getBounds().intersection(rectangle);
                if (rectangle.width < this.w || rectangle.height < this.h) {
                    Debug.log(1, "%s cropped to screen", this);
                    if (this.vWidth < 0) {
                        this.vWidth = this.w;
                        this.vHeight = this.h;
                    }
                }
                this.x = (int)rectangle.getX();
                this.y = (int)rectangle.getY();
                this.w = (int)rectangle.getWidth();
                this.h = (int)rectangle.getHeight();
                return;
            }
        }
        this.updateSelf();
    }

    public Region(int n, int n2, int n3, int n4) {
        this.initialize(n, n2, n3, n4, null);
    }

    public Region(Rectangle rectangle) {
        this.initialize(rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
    }

    public Region(Region region) {
        this.autoWaitTimeout = region.autoWaitTimeout;
        this.findFailedResponse = region.findFailedResponse;
        this.throwException = region.throwException;
        this.initialize(region.x, region.y, region.w, region.h, region.getScreen());
    }

    private static Region toJythonRegion(Region region) {
        if (region == null) {
            return null;
        }
        PythonInterpreter pythonInterpreter = new PythonInterpreter();
        pythonInterpreter.exec("from sikuli import Region");
        PyObject pyObject = pythonInterpreter.get("Region");
        PyObject pyObject2 = pyObject.__call__(Py.java2py(region));
        Region region2 = (Region)pyObject2.__tojava__(Region.class);
        Debug.log(2, "Region.toJythonRegion (%s): %s", region2.isJythonRegion(), region2);
        return region2;
    }

    protected Region() {
    }

    public static Region create(int n, int n2, int n3, int n4) {
        return Region.create(n, n2, n3, n4, null);
    }

    private static Region create(int n, int n2, int n3, int n4, Screen screen) {
        Region region = new Region();
        region = region.initialize(n, n2, n3, n4, screen);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string = stackTraceElementArray[stackTraceElementArray.length - 1].toString();
        if (string.contains("SikuliIDE") || string.contains("SikuliScript")) {
            String string2;
            String string3 = string2 = screen != null ? screen.toStringShort() : "N/A";
            if (Settings.makeJythonRegion) {
                Debug.log(2, "JythonRegion.create(%d, %d, %d, %d)@%s", n, n2, n3, n4, string2);
                return Region.toJythonRegion(region);
            }
            return region;
        }
        return region;
    }

    public static Region create(Location location, int n, int n2) {
        return Region.create(location.x, location.y, n, n2, null);
    }

    public static Region create(Location location, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n3;
        int n8 = n4;
        if (n == 0) {
            if (n2 == 0) {
                n6 = location.x;
                n5 = location.y;
            } else {
                n6 = location.x;
                n5 = location.y - n4;
            }
        } else if (n2 == 0) {
            n6 = location.x - n3;
            n5 = location.y;
        } else {
            n6 = location.x - n3;
            n5 = location.y - n4;
        }
        return Region.create(n6, n5, n7, n8);
    }

    public static Region grow(Location location, int n, int n2, int n3, int n4) {
        return Region.create(location, n, n2, n3, n4);
    }

    public static Region create(Rectangle rectangle) {
        return Region.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
    }

    protected static Region create(Rectangle rectangle, Screen screen) {
        return Region.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height, screen);
    }

    public static Region create(Region region) {
        Region region2 = Region.create(region.x, region.y, region.w, region.h, null);
        region2.autoWaitTimeout = region.autoWaitTimeout;
        region2.findFailedResponse = region.findFailedResponse;
        region2.throwException = region.throwException;
        return region2;
    }

    public static Region grow(Location location, int n, int n2) {
        int n3 = location.x - n / 2;
        int n4 = location.y - n2 / 2;
        return Region.create(n3, n4, n, n2);
    }

    public static Region grow(Location location) {
        return Region.grow(location, 3, 3);
    }

    public boolean contains(Location location) {
        return this.getRect().contains(location.x, location.y);
    }

    public boolean containsMouse() {
        return this.contains(Region.atMouse());
    }

    public Region copyTo() {
        return this.copyTo(Screen.getPrimaryScreen());
    }

    public Region copyTo(int n) {
        return this.copyTo(Screen.getScreen(n));
    }

    public Region copyTo(Screen screen) {
        Location location = new Location(this.getScreen().getBounds().getLocation());
        Location location2 = new Location(screen.getBounds().getLocation());
        return Region.create(location2.x + this.x - location.x, location2.y + this.y - location.y, this.getVW(), this.getVH());
    }

    public Region copyTo(Region region) {
        return this.copyTo(region.getScreen());
    }

    protected Match toGlobalCoord(Match match) {
        match.x += this.x;
        match.y += this.y;
        return match;
    }

    public void setThrowException(boolean bl) {
        this.throwException = bl;
        this.findFailedResponse = this.throwException ? FindFailedResponse.ABORT : FindFailedResponse.SKIP;
    }

    public boolean getThrowException() {
        return this.throwException;
    }

    public void setAutoWaitTimeout(double d) {
        this.autoWaitTimeout = d;
    }

    public double getAutoWaitTimeout() {
        return this.autoWaitTimeout;
    }

    public void setFindFailedResponse(FindFailedResponse findFailedResponse) {
        this.findFailedResponse = findFailedResponse;
    }

    public FindFailedResponse getFindFailedResponse() {
        return this.findFailedResponse;
    }

    public Screen getScreen() {
        return this.scr;
    }

    public Screen getScreenContaining() {
        for (int i = 0; i < Screen.getNumberScreens(); ++i) {
            Rectangle rectangle = Screen.getBounds(i);
            if (!rectangle.contains(this.getTopLeft())) continue;
            return Screen.getScreen(i);
        }
        return Screen.getPrimaryScreen();
    }

    protected void setScreen(Screen screen) {
        this.scr = screen;
    }

    protected void setScreen(int n) {
        this.scr = Screen.getScreen(n);
    }

    public void showScreens() {
        Screen.showMonitors();
    }

    public void resetScreens() {
        Screen.resetMonitors();
    }

    public Location getCenter() {
        return new Location(this.x + this.w / 2, this.y + this.h / 2);
    }

    public Location getTarget() {
        return this.getCenter();
    }

    public Region setCenter(Location location) {
        Location location2 = this.getCenter();
        this.x = this.x - location2.x + location.x;
        this.y = this.y - location2.y + location.y;
        this.initScreen(location.getScreen());
        return this;
    }

    public Location getTopLeft() {
        return new Location(this.x, this.y);
    }

    public Region setTopLeft(Location location) {
        return this.setLocation(location);
    }

    public Location getTopRight() {
        return new Location(this.x + this.w, this.y);
    }

    public Region setTopRight(Location location) {
        Location location2 = this.getTopRight();
        this.x = this.x - location2.x + location.x;
        this.y = this.y - location2.y + location.y;
        this.initScreen(this.getScreen());
        return this;
    }

    public Location getBottomLeft() {
        return new Location(this.x, this.y + this.h);
    }

    public Region setBottomLeft(Location location) {
        Location location2 = this.getBottomLeft();
        this.x = this.x - location2.x + location.x;
        this.y = this.y - location2.y + location.y;
        this.initScreen(this.getScreen());
        return this;
    }

    public Location getBottomRight() {
        return new Location(this.x + this.w, this.y + this.h);
    }

    public Region setBottomRight(Location location) {
        Location location2 = this.getBottomRight();
        this.x = this.x - location2.x + location.x;
        this.y = this.y - location2.y + location.y;
        this.initScreen(null);
        return this;
    }

    @Deprecated
    public int getX() {
        return this.x;
    }

    @Deprecated
    public int getY() {
        return this.y;
    }

    @Deprecated
    public int getW() {
        return this.w;
    }

    @Deprecated
    public int getH() {
        return this.h;
    }

    @Deprecated
    public void setX(int n) {
        this.x = n;
    }

    @Deprecated
    public void setY(int n) {
        this.y = n;
    }

    @Deprecated
    public void setW(int n) {
        this.w = n;
    }

    @Deprecated
    public void setH(int n) {
        this.h = n;
    }

    public Region setSize(int n, int n2) {
        this.w = n;
        this.h = n2;
        this.initScreen(null);
        return this;
    }

    public Rectangle getRect() {
        return new Rectangle(this.x, this.y, this.w, this.h);
    }

    public Region setRect(Rectangle rectangle) {
        this.setRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return this;
    }

    public Region setRect(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        this.initScreen(this.getScreen());
        return this;
    }

    public Region setRect(Region region) {
        this.setRect(region.x, region.y, region.w, region.h);
        return this;
    }

    public Region getROI() {
        return Region.create(this.getScreen().getCurROI());
    }

    public void setROI(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        this.initScreen(this.getScreen());
        this.getScreen().setCurROI(new Rectangle(n, n2, n3, n4));
    }

    public void setROI(Rectangle rectangle) {
        this.x = (int)rectangle.getX();
        this.y = (int)rectangle.getY();
        this.w = (int)rectangle.getWidth();
        this.h = (int)rectangle.getHeight();
        this.initScreen(this.getScreen());
        this.getScreen().setCurROI(rectangle);
    }

    public void setROI(Region region) {
        this.x = region.x;
        this.y = region.y;
        this.w = region.w;
        this.h = region.h;
        this.initScreen(this.getScreen());
        this.getScreen().setCurROI(region.getRect());
    }

    public void resetROI() {
        if (this instanceof Screen || this.isJythonScreen()) {
            Rectangle rectangle = this.getScreen().getBounds();
            this.x = (int)rectangle.getX();
            this.y = (int)rectangle.getY();
            this.w = (int)rectangle.getWidth();
            this.h = (int)rectangle.getHeight();
            this.getScreen().setCurROI(rectangle);
        }
    }

    @Deprecated
    public Region inside() {
        return this;
    }

    @Deprecated
    public Region moveTo(Location location) {
        return this.setLocation(location);
    }

    public Region setLocation(Location location) {
        this.x = location.x;
        this.y = location.y;
        this.initScreen(this.getScreen());
        return this;
    }

    @Deprecated
    public Region morphTo(Region region) {
        return this.setRect(region);
    }

    public Region add(int n, int n2, int n3, int n4) {
        this.x -= n;
        this.y -= n3;
        this.w = this.w + n + n2;
        this.h = this.h + n3 + n4;
        this.initScreen(this.getScreen());
        return this;
    }

    public Region add(Region region) {
        Rectangle rectangle = this.getRect();
        rectangle.add(region.getRect());
        this.setRect(rectangle);
        this.initScreen(this.getScreen());
        return this;
    }

    public Region add(Location location) {
        Rectangle rectangle = this.getRect();
        rectangle.add(location.x, location.y);
        this.setRect(rectangle);
        this.initScreen(this.getScreen());
        return this;
    }

    public Match getLastMatch() {
        return this.lastMatch;
    }

    public Iterator<Match> getLastMatches() {
        return this.lastMatches;
    }

    public ScreenImage getLastScreenImage() {
        return this.getScreen().lastScreenImage;
    }

    public String getLastScreenImageFile() throws IOException {
        return this.getLastScreenImageFile(Settings.BundlePath, null);
    }

    public String getLastScreenImageFile(String string) throws IOException {
        return this.getScreen().lastScreenImage.getFile(Settings.BundlePath, string);
    }

    public String getLastScreenImageFile(String string, String string2) throws IOException {
        return this.getScreen().lastScreenImage.getFile(string, string2);
    }

    public boolean contains(Region region) {
        return this.getRect().contains(region.getRect());
    }

    public Region offset(Location location) {
        return Region.create(this.x + location.x, this.y + location.y, this.getVW(), this.getVH());
    }

    @Deprecated
    public Region nearby() {
        return this.grow(50, 50);
    }

    @Deprecated
    public Region nearby(int n) {
        return this.grow(n, n);
    }

    public Region grow(int n) {
        return this.grow(n, n);
    }

    public Region grow(int n, int n2) {
        Rectangle rectangle = this.getRect();
        rectangle.setSize(this.getVW(), this.getVH());
        rectangle.grow(n, n2);
        return Region.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.scr);
    }

    public Region grow(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getRect();
        int n5 = this.x - n;
        int n6 = this.y - n4;
        int n7 = this.getVW() + n + n2;
        int n8 = this.getVH() + n3 + n4;
        return Region.create(n5, n6, n7, n8);
    }

    public Location rightAt() {
        return this.rightAt(0);
    }

    public Location rightAt(int n) {
        return new Location(this.x + this.w + n, this.y + this.h / 2);
    }

    public Region right() {
        return this.right(9999999);
    }

    public Region right(int n) {
        int n2 = this.x + this.w;
        int n3 = this.y;
        int n4 = n;
        int n5 = this.h;
        return Region.create(n2, n3, n4, n5);
    }

    public Location leftAt() {
        return this.leftAt(0);
    }

    public Location leftAt(int n) {
        return new Location(this.x + n, this.y + this.h / 2);
    }

    public Region left() {
        return this.left(9999999);
    }

    public Region left(int n) {
        Rectangle rectangle = this.getScreen().getBounds();
        int n2 = this.x - n < rectangle.x ? rectangle.x : this.x - n;
        int n3 = this.y;
        int n4 = this.x - n2;
        int n5 = this.h;
        return Region.create(n2, n3, n4, n5);
    }

    public Location aboveAt() {
        return this.aboveAt(0);
    }

    public Location aboveAt(int n) {
        return new Location(this.x + this.w / 2, this.y + n);
    }

    public Region above() {
        return this.above(9999999);
    }

    public Region above(int n) {
        Rectangle rectangle = this.getScreen().getBounds();
        int n2 = this.x;
        int n3 = this.y - n < rectangle.y ? rectangle.y : this.y - n;
        int n4 = this.w;
        int n5 = this.y - n3;
        return Region.create(n2, n3, n4, n5);
    }

    public Location belowAt() {
        return this.belowAt(0);
    }

    public Location belowAt(int n) {
        return new Location(this.x + this.w / 2, this.y + this.h - n);
    }

    public Region below() {
        return this.below(999999);
    }

    public Region below(int n) {
        int n2 = this.x;
        int n3 = this.y + this.h;
        int n4 = this.w;
        int n5 = n;
        return Region.create(n2, n3, n4, n5);
    }

    public Region union(Region region) {
        Rectangle rectangle = this.getRect();
        rectangle.setSize(this.getVW(), this.getVH());
        rectangle = rectangle.union(region.getRect());
        return Region.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Region intersection(Region region) {
        Rectangle rectangle = this.getRect();
        rectangle.setSize(this.getVW(), this.getVH());
        rectangle = rectangle.intersection(region.getRect());
        return Region.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void updateSelf() {
        if (this.overlay != null) {
            this.highlight(false);
            this.highlight(true);
        }
    }

    public Region highlight() {
        if (!(this.getScreen() instanceof Screen)) {
            Debug.error("highlight only works on the physical desktop screens.", new Object[0]);
            return this;
        }
        if (this.overlay == null) {
            this.highlight(true);
        } else {
            this.highlight(false);
        }
        return this;
    }

    private void highlight(boolean bl) {
        Debug.history("toggle highlight " + this.toString() + ": " + bl, new Object[0]);
        if (bl) {
            this.overlay = new ScreenHighlighter(this.getScreen());
            this.overlay.highlight(this);
        } else if (this.overlay != null) {
            this.overlay.close();
            this.overlay = null;
        }
    }

    public Region highlight(float f) {
        if ((double)f < 0.1) {
            return this.highlight((int)f);
        }
        Debug.history("highlight " + this.toString() + " for " + f + " secs", new Object[0]);
        if (!(this.getScreen() instanceof Screen)) {
            Debug.error("highlight only work on the physical desktop screens.", new Object[0]);
            return this;
        }
        ScreenHighlighter screenHighlighter = new ScreenHighlighter(this.getScreen());
        screenHighlighter.highlight(this, f);
        return this;
    }

    public Region highlight(int n) {
        if (n > 0) {
            return this.highlight((float)n);
        }
        if (this.lastMatch != null) {
            if (n < 0) {
                return this.lastMatch.highlight((float)(-n));
            }
            return this.lastMatch.highlight(Settings.DefaultHighlightTime);
        }
        return this;
    }

    public void wait(double d) {
        try {
            Thread.sleep((long)(d * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private <PatternOrString> String getImageFilename(PatternOrString PatternOrString) {
        String string = null;
        if (PatternOrString instanceof Pattern) {
            string = ((Pattern)PatternOrString).getFilename();
        } else if (PatternOrString instanceof String) {
            string = (String)PatternOrString;
        }
        try {
            return ImageLocator.locate(string);
        }
        catch (IOException iOException) {
            return "*** not known ***";
        }
    }

    private <PatternOrString> boolean handleFindFailed(PatternOrString PatternOrString) throws FindFailed {
        FindFailedResponse findFailedResponse;
        if (this.findFailedResponse == FindFailedResponse.PROMPT) {
            FindFailedDialog findFailedDialog = new FindFailedDialog(PatternOrString);
            findFailedDialog.setVisible(true);
            findFailedResponse = findFailedDialog.getResponse();
            findFailedDialog.dispose();
            this.wait(0.5);
        } else {
            findFailedResponse = this.findFailedResponse;
        }
        if (findFailedResponse == FindFailedResponse.SKIP) {
            return false;
        }
        if (findFailedResponse == FindFailedResponse.RETRY) {
            return true;
        }
        if (findFailedResponse == FindFailedResponse.ABORT) {
            throw new FindFailed("can not find " + PatternOrString + " on the screen.");
        }
        return false;
    }

    public <PatternOrString> Match find(PatternOrString PatternOrString) throws FindFailed {
        if (this.autoWaitTimeout > 0.0) {
            return this.wait(PatternOrString, this.autoWaitTimeout);
        }
        do {
            try {
                this.lastMatch = this.doFind(PatternOrString, null);
            }
            catch (Exception exception) {
                throw new FindFailed(exception.getMessage());
            }
            if (this.lastMatch == null) continue;
            this.lastMatch.setImage(this.getImageFilename(PatternOrString));
            return this.lastMatch;
        } while (this.handleFindFailed(PatternOrString));
        return null;
    }

    public <PatternOrString> Iterator<Match> findAll(PatternOrString PatternOrString) throws FindFailed {
        do {
            try {
                if (this.autoWaitTimeout > 0.0) {
                    RepeatableFindAll repeatableFindAll = new RepeatableFindAll(PatternOrString);
                    repeatableFindAll.repeat(this.autoWaitTimeout);
                    this.lastMatches = repeatableFindAll.getMatches();
                } else {
                    this.lastMatches = this.doFindAll(PatternOrString, null);
                }
            }
            catch (Exception exception) {
                throw new FindFailed(exception.getMessage());
            }
            if (this.lastMatches == null) continue;
            return this.lastMatches;
        } while (this.handleFindFailed(PatternOrString));
        return null;
    }

    public <PatternOrString> Match wait(PatternOrString PatternOrString) throws FindFailed {
        return this.wait(PatternOrString, this.autoWaitTimeout);
    }

    public <PatternOrString> Match wait(PatternOrString PatternOrString, double d) throws FindFailed {
        RepeatableFind repeatableFind;
        block4: {
            do {
                try {
                    Debug.log(2, "waiting for " + PatternOrString + " to appear", new Object[0]);
                    repeatableFind = new RepeatableFind(PatternOrString);
                    repeatableFind.repeat(d);
                    this.lastMatch = repeatableFind.getMatch();
                    if (this.lastMatch != null) {
                        this.lastMatch.setImage(repeatableFind._imagefilename);
                    }
                }
                catch (Exception exception) {
                    throw new FindFailed(exception.getMessage());
                }
                if (this.lastMatch != null) break block4;
                Debug.log(2, "" + PatternOrString + " has not appeared.", new Object[0]);
            } while (this.handleFindFailed(PatternOrString));
            return null;
        }
        this.lastMatch.setImage(repeatableFind._imagefilename);
        Debug.log(2, "" + PatternOrString + " has appeared.", new Object[0]);
        return this.lastMatch;
    }

    public <PatternOrString> Match exists(PatternOrString PatternOrString) {
        return this.exists(PatternOrString, this.autoWaitTimeout);
    }

    public <PatternOrString> Match exists(PatternOrString PatternOrString, double d) {
        try {
            RepeatableFind repeatableFind = new RepeatableFind(PatternOrString);
            if (repeatableFind.repeat(d)) {
                this.lastMatch = repeatableFind.getMatch();
                this.lastMatch.setImage(this.getImageFilename(PatternOrString));
                return this.lastMatch;
            }
        }
        catch (Exception exception) {
            Debug.error("Region.exists: seems that imagefile could not be found on disk", PatternOrString);
        }
        return null;
    }

    public Match findText(String string, double d) throws FindFailed {
        throw new FindFailed("Region.findText: not yet implemented");
    }

    public Match findText(String string) throws FindFailed {
        return this.findText(string, this.autoWaitTimeout);
    }

    public Match findAllText(String string, double d) throws FindFailed {
        throw new FindFailed("Region.findText: not yet implemented");
    }

    public Match findAllText(String string) throws FindFailed {
        return this.findText(string, this.autoWaitTimeout);
    }

    public <PatternOrString> boolean waitVanish(PatternOrString PatternOrString) {
        return this.waitVanish(PatternOrString, this.autoWaitTimeout);
    }

    public <PatternOrString> boolean waitVanish(PatternOrString PatternOrString, double d) {
        try {
            Debug.log(2, "waiting for " + PatternOrString + " to vanish", new Object[0]);
            RepeatableVanish repeatableVanish = new RepeatableVanish(PatternOrString);
            if (repeatableVanish.repeat(d)) {
                Debug.log(2, "" + PatternOrString + " has vanished", new Object[0]);
                return true;
            }
            Debug.log(2, "" + PatternOrString + " has not vanished before timeout", new Object[0]);
            return false;
        }
        catch (Exception exception) {
            Debug.error("Region.waitVanish: seems that imagefile could not be found on disk", PatternOrString);
            return false;
        }
    }

    private <PatternOrString> Match doFind(PatternOrString PatternOrString, RepeatableFind repeatableFind) throws IOException {
        Finder finder;
        ScreenImage screenImage = this.getScreen().capture(this.x, this.y, this.w, this.h);
        if (repeatableFind != null && repeatableFind._finder != null) {
            finder = repeatableFind._finder;
            finder.setScreenImage(screenImage);
            finder.setRepeating();
            finder.findRepeat();
        } else {
            String string;
            finder = new Finder(screenImage, this);
            if (PatternOrString instanceof String) {
                string = finder.find((String)PatternOrString);
                if (null == string) {
                    throw new IOException("ImageFile " + PatternOrString + " not found on disk");
                }
                if (((String)PatternOrString + "???").equals(string)) {
                    throw new IOException("Text search currently switched off");
                }
            } else {
                string = ((Pattern)PatternOrString).getFilename();
                if (null == finder.find((Pattern)PatternOrString)) {
                    throw new IOException("ImageFile " + string + " not found on disk");
                }
            }
            if (repeatableFind != null) {
                repeatableFind._finder = finder;
                repeatableFind._imagefilename = string;
            }
        }
        if (finder.hasNext()) {
            return finder.next();
        }
        return null;
    }

    private <PatternOrString> Iterator<Match> doFindAll(PatternOrString PatternOrString, RepeatableFindAll repeatableFindAll) throws IOException {
        Finder finder;
        ScreenImage screenImage = this.getScreen().capture(this.x, this.y, this.w, this.h);
        if (repeatableFindAll != null && repeatableFindAll._finder != null) {
            finder = repeatableFindAll._finder;
            finder.setScreenImage(screenImage);
            finder.setRepeating();
            finder.findAllRepeat();
        } else {
            finder = new Finder(screenImage, this);
            if (PatternOrString instanceof String) {
                if (null == finder.findAll((String)PatternOrString)) {
                    throw new IOException();
                }
            } else if (null == finder.findAll((Pattern)PatternOrString)) {
                throw new IOException("ImageFile " + ((Pattern)PatternOrString).getFilename() + " not found on disk");
            }
        }
        if (finder.hasNext()) {
            return finder;
        }
        return null;
    }

    @Deprecated
    public <PatternOrString> Match findNow(PatternOrString PatternOrString) throws FindFailed {
        ScreenImage screenImage = this.getScreen().capture(this.x, this.y, this.w, this.h);
        Finder finder = new Finder(screenImage, this);
        Match match = null;
        if (PatternOrString instanceof String) {
            if (null == finder.find((String)PatternOrString)) {
                throw new FindFailed("ImageFile not found");
            }
        } else if (null == finder.find((Pattern)PatternOrString)) {
            throw new FindFailed("ImageFile " + ((Pattern)PatternOrString).getFilename() + " not found on disk");
        }
        if (finder.hasNext()) {
            match = finder.next();
        }
        finder.destroy();
        return match;
    }

    @Deprecated
    public <PatternOrString> Iterator<Match> findAllNow(PatternOrString PatternOrString) throws FindFailed {
        ScreenImage screenImage = this.getScreen().capture(this.x, this.y, this.w, this.h);
        Finder finder = new Finder(screenImage, this);
        if (PatternOrString instanceof String) {
            if (null == finder.findAll((String)PatternOrString)) {
                throw new FindFailed("ImageFile not found");
            }
        } else if (null == finder.findAll((Pattern)PatternOrString)) {
            throw new FindFailed("ImageFile " + ((Pattern)PatternOrString).getFilename() + " not found on disk");
        }
        if (finder.hasNext()) {
            return finder;
        }
        finder.destroy();
        return null;
    }

    @Deprecated
    public <PatternOrString> Iterator<Match> waitAll(PatternOrString PatternOrString, double d) throws FindFailed {
        block3: {
            do {
                try {
                    RepeatableFindAll repeatableFindAll = new RepeatableFindAll(PatternOrString);
                    repeatableFindAll.repeat(d);
                    this.lastMatches = repeatableFindAll.getMatches();
                }
                catch (Exception exception) {
                    throw new FindFailed(exception.getMessage());
                }
                if (this.lastMatches != null) break block3;
            } while (this.handleFindFailed(PatternOrString));
            return null;
        }
        return this.lastMatches;
    }

    private <PatternStringRegionMatch> Region getRegionFromTarget(PatternStringRegionMatch PatternStringRegionMatch) throws FindFailed {
        if (PatternStringRegionMatch instanceof Pattern || PatternStringRegionMatch instanceof String) {
            Match match = this.find(PatternStringRegionMatch);
            if (match != null) {
                return match;
            }
            return null;
        }
        if (PatternStringRegionMatch instanceof Region) {
            return (Region)PatternStringRegionMatch;
        }
        return null;
    }

    private <PatternStringRegionMatchLocation> Location getLocationFromTarget(PatternStringRegionMatchLocation PatternStringRegionMatchLocation) throws FindFailed {
        if (PatternStringRegionMatchLocation instanceof Pattern || PatternStringRegionMatchLocation instanceof String) {
            Match match = this.find(PatternStringRegionMatchLocation);
            if (match != null) {
                return match.getTarget();
            }
            return null;
        }
        if (PatternStringRegionMatchLocation instanceof Match) {
            return ((Match)PatternStringRegionMatchLocation).getTarget();
        }
        if (PatternStringRegionMatchLocation instanceof Region) {
            return ((Region)PatternStringRegionMatchLocation).getCenter();
        }
        if (PatternStringRegionMatchLocation instanceof Location) {
            return (Location)PatternStringRegionMatchLocation;
        }
        return null;
    }

    private SikuliEventManager getEventManager() {
        if (this.evtMgr == null) {
            this.evtMgr = new SikuliEventManager(this);
        }
        return this.evtMgr;
    }

    public <PatternOrString> void onAppear(PatternOrString PatternOrString, Object object) {
        if (!object.getClass().getName().startsWith("org.python.core.PyFunction")) {
            this.getEventManager().addAppearObserver(PatternOrString, (SikuliEventObserver)object);
        } else {
            Debug.error("onAppear(%s): invalid Region - use r = Region(r) before as workaround", PatternOrString);
        }
    }

    public <PatternOrString> void onVanish(PatternOrString PatternOrString, Object object) {
        if (!object.getClass().getName().startsWith("org.python.core.PyFunction")) {
            this.getEventManager().addVanishObserver(PatternOrString, (SikuliEventObserver)object);
        } else {
            Debug.error("onVanish(%s): invalid Region - use r = Region(r) before as workaround", PatternOrString);
        }
    }

    public void onChange(int n, Object object) {
        if (!object.getClass().getName().startsWith("org.python.core.PyFunction")) {
            this.getEventManager().addChangeObserver(n, (SikuliEventObserver)object);
        } else {
            Debug.error("onChange(%s): invalid Region - use r = Region(r) before as workaround", n);
        }
    }

    public void onChange(SikuliEventObserver sikuliEventObserver) {
        if (!sikuliEventObserver.getClass().getName().startsWith("org.python.core.PyFunction")) {
            this.getEventManager().addChangeObserver(Settings.ObserveMinChangedPixels, sikuliEventObserver);
        } else {
            Debug.error("onChange(): invalid Region - use r = Region(r) before as workaround", new Object[0]);
        }
    }

    public void observe() {
        this.observe(Double.POSITIVE_INFINITY);
    }

    public void observeInBackground(final double d) {
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                Region.this.observe(d);
            }
        };
        thread2.start();
    }

    public void stopObserver() {
        this.observing = false;
    }

    public void observe(double d) {
        if (this.evtMgr == null) {
            Debug.error("observe(): Nothing to observe (for Jython: region might be invalid)", new Object[0]);
            return;
        }
        int n = (int)(1000.0 / (double)Settings.ObserveScanRate);
        long l = new Date().getTime();
        this.observing = true;
        this.evtMgr.initialize();
        while (this.observing) {
            Date date = new Date();
            if (!((double)l + d * 1000.0 > (double)date.getTime())) break;
            long l2 = new Date().getTime();
            ScreenImage screenImage = this.getScreen().capture(this.x, this.y, this.w, this.h);
            if (!this.evtMgr.update(screenImage)) {
                this.stopObserver();
                break;
            }
            long l3 = new Date().getTime();
            try {
                if (l3 - l2 >= (long)n) continue;
                Thread.sleep((int)((long)n - (l3 - l2)));
            }
            catch (Exception exception) {}
        }
    }

    private Location checkMatch() {
        if (this.lastMatch != null) {
            return this.lastMatch.getTarget();
        }
        return this.getTarget();
    }

    public int hover() {
        try {
            return this.hover(this.checkMatch());
        }
        catch (FindFailed findFailed) {
            return 0;
        }
    }

    public <PatternFilenameRegionMatchLocation> int hover(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation) throws FindFailed {
        return this.mouseMove(PatternFilenameRegionMatchLocation);
    }

    public int click() {
        try {
            return this.click(this.checkMatch(), 0);
        }
        catch (FindFailed findFailed) {
            return 0;
        }
    }

    public <PatternFilenameRegionMatchLocation> int click(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation) throws FindFailed {
        return this.click(PatternFilenameRegionMatchLocation, 0);
    }

    public <PatternFilenameRegionMatchLocation> int click(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation, int n) throws FindFailed {
        Location location = this.getLocationFromTarget(PatternFilenameRegionMatchLocation);
        int n2 = this._click(location, 16, n, false);
        return n2;
    }

    public int doubleClick() {
        try {
            return this.doubleClick(this.checkMatch(), 0);
        }
        catch (FindFailed findFailed) {
            return 0;
        }
    }

    public <PatternFilenameRegionMatchLocation> int doubleClick(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation) throws FindFailed {
        return this.doubleClick(PatternFilenameRegionMatchLocation, 0);
    }

    public <PatternFilenameRegionMatchLocation> int doubleClick(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation, int n) throws FindFailed {
        Location location = this.getLocationFromTarget(PatternFilenameRegionMatchLocation);
        int n2 = this._click(location, 16, n, true);
        return n2;
    }

    public int rightClick() {
        try {
            return this.rightClick(this.checkMatch(), 0);
        }
        catch (FindFailed findFailed) {
            return 0;
        }
    }

    public <PatternFilenameRegionMatchLocation> int rightClick(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation) throws FindFailed {
        return this.rightClick(PatternFilenameRegionMatchLocation, 0);
    }

    public <PatternFilenameRegionMatchLocation> int rightClick(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation, int n) throws FindFailed {
        Location location = this.getLocationFromTarget(PatternFilenameRegionMatchLocation);
        int n2 = this._click(location, 4, n, false);
        return n2;
    }

    private int _click(Location location, int n, int n2, boolean bl) {
        if (location == null) {
            return 0;
        }
        Debug.history(this.getClickMsg(location, n, n2, bl), new Object[0]);
        this.getScreen().showTarget(location);
        RobotDesktop robotDesktop = this.getScreen().getActionRobot();
        robotDesktop.pressModifiers(n2);
        robotDesktop.smoothMove(location);
        robotDesktop.mouseDown(n);
        robotDesktop.mouseUp(n);
        if (bl) {
            robotDesktop.mouseDown(n);
            robotDesktop.mouseUp(n);
        }
        robotDesktop.releaseModifiers(n2);
        robotDesktop.waitForIdle();
        return 1;
    }

    private String getClickMsg(Location location, int n, int n2, boolean bl) {
        String string = "";
        if (n2 != 0) {
            string = string + KeyEvent.getKeyModifiersText(n2) + "+";
        }
        if (n == 16 && !bl) {
            string = string + "CLICK";
        }
        if (n == 16 && bl) {
            string = string + "DOUBLE CLICK";
        }
        if (n == 4) {
            string = string + "RIGHT CLICK";
        } else if (n == 8) {
            string = string + "MID CLICK";
        }
        string = string + " on " + location;
        return string;
    }

    public <PatternFilenameRegionMatchLocation> int dragDrop(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation) throws FindFailed {
        return this.dragDrop(this.lastMatch, PatternFilenameRegionMatchLocation);
    }

    public <PatternFilenameRegionMatchLocation> int dragDrop(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation, PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation2) throws FindFailed {
        Location location = this.getLocationFromTarget(PatternFilenameRegionMatchLocation);
        Location location2 = this.getLocationFromTarget(PatternFilenameRegionMatchLocation2);
        if (location != null && location2 != null) {
            this.getScreen().showTarget(location);
            RobotDesktop robotDesktop = this.getScreen().getActionRobot();
            robotDesktop.smoothMove(location);
            robotDesktop.mouseDown(16);
            robotDesktop.delay((int)(Settings.DelayAfterDrag * 1000.0));
            this.getScreen().showTarget(location2);
            robotDesktop.smoothMove(location2);
            robotDesktop.delay((int)(Settings.DelayBeforeDrop * 1000.0));
            robotDesktop.mouseUp(16);
            return 1;
        }
        return 0;
    }

    public <PatternFilenameRegionMatchLocation> int drag(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation) throws FindFailed {
        Location location = this.getLocationFromTarget(PatternFilenameRegionMatchLocation);
        if (location != null) {
            RobotDesktop robotDesktop = this.getScreen().getActionRobot();
            this.getScreen().showTarget(location);
            robotDesktop.smoothMove(location);
            robotDesktop.mouseDown(16);
            robotDesktop.delay((int)(Settings.DelayAfterDrag * 1000.0));
            robotDesktop.waitForIdle();
            return 1;
        }
        return 0;
    }

    public <PatternFilenameRegionMatchLocation> int dropAt(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation) throws FindFailed {
        Location location = this.getLocationFromTarget(PatternFilenameRegionMatchLocation);
        if (location != null) {
            this.getScreen().showTarget(location);
            RobotDesktop robotDesktop = this.getScreen().getActionRobot();
            robotDesktop.smoothMove(location);
            robotDesktop.delay((int)(Settings.DelayBeforeDrop * 1000.0));
            robotDesktop.mouseUp(16);
            robotDesktop.waitForIdle();
            return 1;
        }
        return 0;
    }

    public void mouseDown(int n) {
        this.getScreen().getActionRobot().mouseDown(n);
    }

    public void mouseUp() {
        this.mouseUp(0);
    }

    public void mouseUp(int n) {
        this.getScreen().getActionRobot().mouseUp(n);
    }

    public int mouseMove() {
        if (this.lastMatch != null) {
            try {
                return this.mouseMove(this.lastMatch);
            }
            catch (FindFailed findFailed) {
                return 0;
            }
        }
        return 0;
    }

    public <PatternFilenameRegionMatchLocation> int mouseMove(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation) throws FindFailed {
        Location location = this.getLocationFromTarget(PatternFilenameRegionMatchLocation);
        if (location != null) {
            this.getScreen().showTarget(location);
            RobotDesktop robotDesktop = this.getScreen().getActionRobot();
            robotDesktop.smoothMove(location);
            robotDesktop.waitForIdle();
            return 1;
        }
        return 0;
    }

    public int wheel(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            RobotDesktop robotDesktop = this.getScreen().getActionRobot();
            robotDesktop.mouseWheel(n);
            robotDesktop.delay(50);
        }
        return 1;
    }

    public <PatternFilenameRegionMatchLocation> int wheel(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation, int n, int n2) throws FindFailed {
        if (PatternFilenameRegionMatchLocation == null || this.mouseMove(PatternFilenameRegionMatchLocation) != 0) {
            return this.wheel(n, n2);
        }
        return 0;
    }

    public static Location atMouse() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        return new Location(point.x, point.y);
    }

    public void keyDown(int n) {
        this.getScreen().getActionRobot().keyDown(n);
    }

    public void keyDown(String string) {
        this.getScreen().getActionRobot().keyDown(string);
    }

    public void keyUp() {
        this.keyUp("");
    }

    public void keyUp(int n) {
        this.getScreen().getActionRobot().keyUp(n);
    }

    public void keyUp(String string) {
        this.getScreen().getActionRobot().keyUp(string);
    }

    public int type(String string) {
        try {
            return this.keyin(null, string, 0);
        }
        catch (FindFailed findFailed) {
            return 0;
        }
    }

    public int type(String string, int n) {
        try {
            return this.keyin(null, string, n);
        }
        catch (FindFailed findFailed) {
            return 0;
        }
    }

    public int type(String string, String string2) {
        String string3 = null;
        int n = Key.convertModifiers(string2);
        if (n == 0) {
            string3 = string;
            string = string2;
        }
        try {
            return this.keyin(string3, string, n);
        }
        catch (FindFailed findFailed) {
            return 0;
        }
    }

    public <PatternFilenameRegionMatchLocation> int type(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation, String string) throws FindFailed {
        return this.keyin(PatternFilenameRegionMatchLocation, string, 0);
    }

    public <PatternFilenameRegionMatchLocation> int type(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation, String string, int n) throws FindFailed {
        return this.keyin(PatternFilenameRegionMatchLocation, string, n);
    }

    public <PatternFilenameRegionMatchLocation> int type(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation, String string, String string2) throws FindFailed {
        int n = Key.convertModifiers(string2);
        return this.keyin(PatternFilenameRegionMatchLocation, string, n);
    }

    private <PatternFilenameRegionMatchLocation> int keyin(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation, String string, int n) throws FindFailed {
        if (PatternFilenameRegionMatchLocation != null && 0 == this.click(PatternFilenameRegionMatchLocation, 0)) {
            return 0;
        }
        if (string != null && !"".equals(string)) {
            String string2 = "";
            for (int i = 0; i < string.length(); ++i) {
                string2 = string2 + Key.toJavaKeyCodeText(string.charAt(i));
            }
            Debug.history((n != 0 ? KeyEvent.getKeyModifiersText(n) + "+" : "") + "TYPE \"" + string2 + "\"", new Object[0]);
            RobotDesktop robotDesktop = this.getScreen().getActionRobot();
            for (int i = 0; i < string.length(); ++i) {
                robotDesktop.pressModifiers(n);
                robotDesktop.typeChar(string.charAt(i), RobotIF.KeyMode.PRESS_RELEASE);
                robotDesktop.releaseModifiers(n);
                robotDesktop.delay(20);
            }
            robotDesktop.waitForIdle();
            return 1;
        }
        return 0;
    }

    public int paste(String string) {
        try {
            return this.paste(null, string);
        }
        catch (FindFailed findFailed) {
            return 1;
        }
    }

    public <PatternFilenameRegionMatchLocation> int paste(PatternFilenameRegionMatchLocation PatternFilenameRegionMatchLocation, String string) throws FindFailed {
        this.click(PatternFilenameRegionMatchLocation, 0);
        if (string != null) {
            App.setClipboard(string);
            int n = Key.getHotkeyModifier();
            RobotDesktop robotDesktop = this.getScreen().getActionRobot();
            robotDesktop.keyDown(n);
            robotDesktop.keyDown(86);
            robotDesktop.keyUp(86);
            robotDesktop.keyUp(n);
            return 1;
        }
        return 0;
    }

    public String text() {
        if (Settings.OcrTextRead) {
            ScreenImage screenImage = this.getScreen().capture(this.x, this.y, this.w, this.h);
            TextRecognizer textRecognizer = TextRecognizer.getInstance();
            if (textRecognizer == null) {
                Debug.error("Region.text: text recognition is now switched off", new Object[0]);
                return "--- no text ---";
            }
            String string = textRecognizer.recognize(screenImage);
            Debug.log(2, "Region.text: #(" + string + ")#", new Object[0]);
            return string;
        }
        Debug.error("Region.text: text recognition is currently switched off", new Object[0]);
        return "--- no text ---";
    }

    public List<Match> listText() {
        if (Settings.OcrTextRead) {
            ScreenImage screenImage = this.getScreen().capture(this.x, this.y, this.w, this.h);
            TextRecognizer textRecognizer = TextRecognizer.getInstance();
            if (textRecognizer == null) {
                Debug.error("Region.text: text recognition is now switched off", new Object[0]);
                return null;
            }
            Debug.log(2, "Region.listText", new Object[0]);
            return textRecognizer.listText(screenImage, this);
        }
        Debug.error("Region.text: text recognition is currently switched off", new Object[0]);
        return null;
    }

    private class RepeatableFindAll
    extends Repeatable {
        Object _target;
        Iterator<Match> _matches;
        Finder _finder;

        public <PatternOrString> RepeatableFindAll(PatternOrString PatternOrString) {
            this._matches = null;
            this._finder = null;
            this._target = PatternOrString;
        }

        public Iterator<Match> getMatches() {
            return this._matches;
        }

        @Override
        public void run() throws IOException {
            this._matches = Region.this.doFindAll(this._target, this);
        }

        @Override
        boolean ifSuccessful() {
            return this._matches != null;
        }
    }

    private class RepeatableVanish
    extends RepeatableFind {
        public <PatternOrString> RepeatableVanish(PatternOrString PatternOrString) {
            super(PatternOrString);
        }

        @Override
        boolean ifSuccessful() {
            return this._match == null;
        }
    }

    private class RepeatableFind
    extends Repeatable {
        Object _target;
        Match _match;
        Finder _finder;
        String _imagefilename;

        public <PatternOrString> RepeatableFind(PatternOrString PatternOrString) {
            this._match = null;
            this._finder = null;
            this._imagefilename = null;
            this._target = PatternOrString;
        }

        public Match getMatch() {
            if (this._finder != null) {
                this._finder.destroy();
            }
            return this._match == null ? this._match : new Match(this._match);
        }

        @Override
        public void run() throws IOException {
            this._match = Region.this.doFind(this._target, this);
        }

        @Override
        boolean ifSuccessful() {
            return this._match != null;
        }
    }

    private abstract class Repeatable {
        private Repeatable() {
        }

        abstract void run() throws Exception;

        abstract boolean ifSuccessful();

        boolean repeat(double d) throws Exception {
            int n = (int)(1000.0 / (double)Settings.WaitScanRate);
            int n2 = n / 1000;
            long l = new Date().getTime();
            do {
                long l2 = new Date().getTime();
                this.run();
                if (this.ifSuccessful()) {
                    return true;
                }
                if (d < (double)n2) {
                    return false;
                }
                long l3 = new Date().getTime();
                if (l3 - l2 < (long)n) {
                    Region.this.getScreen().getActionRobot().delay((int)((long)n - (l3 - l2)));
                    continue;
                }
                Region.this.getScreen().getActionRobot().delay(10);
            } while ((double)l + d * 1000.0 > (double)new Date().getTime());
            return false;
        }
    }
}

