/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.sikuli.script.Debug;
import org.sikuli.script.HotkeyManager;
import org.sikuli.script.Key;
import org.sikuli.script.Location;
import org.sikuli.script.OutQuarticEase;
import org.sikuli.script.RobotIF;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;
import org.sikuli.script.TimeBasedAnimator;

public class RobotDesktop
extends Robot
implements RobotIF {
    static final int MAX_DELAY = 60000;
    private static int heldButtons = 0;
    private static String heldKeys = "";
    private static ArrayList<Integer> heldKeyCodes = new ArrayList();
    private Screen scr = null;

    public RobotDesktop(Screen screen) throws AWTException {
        super(screen.getGraphicsDevice());
        this.scr = screen;
    }

    @Override
    public GraphicsDevice getDevice() {
        return this.scr.getGraphicsDevice();
    }

    @Override
    public void smoothMove(Location location) {
        this.smoothMove(Screen.atMouse(), location, (long)(Settings.MoveMouseDelay * 1000.0f));
    }

    @Override
    public void smoothMove(Location location, Location location2, long l) {
        if (l == 0L) {
            Debug.log(2, "smoothMove: " + location.toString() + "---" + location2.toString(), new Object[0]);
            this.mouseMove(location2.x, location2.y);
            return;
        }
        TimeBasedAnimator timeBasedAnimator = new TimeBasedAnimator(new OutQuarticEase(location.x, location2.x, l));
        TimeBasedAnimator timeBasedAnimator2 = new TimeBasedAnimator(new OutQuarticEase(location.y, location2.y, l));
        while (timeBasedAnimator.running()) {
            float f = timeBasedAnimator.step();
            float f2 = timeBasedAnimator2.step();
            this.mouseMove((int)f, (int)f2);
            this.delay(50);
        }
    }

    @Override
    public void mouseDown(int n) {
        if (heldButtons != 0) {
            Debug.error("mouseDown: buttons still pressed - using all", n, heldButtons);
            heldButtons |= n;
        } else {
            heldButtons = n;
        }
        this.mousePress(heldButtons);
        this.waitForIdle();
    }

    @Override
    public void mouseUp(int n) {
        if (n == 0) {
            this.mouseRelease(heldButtons);
            heldButtons = 0;
        } else {
            this.mouseRelease(n);
            heldButtons &= ~n;
        }
        this.waitForIdle();
    }

    @Override
    public void delay(int n) {
        if (n < 0) {
            return;
        }
        while (n > 60000) {
            super.delay(60000);
            n -= 60000;
        }
        super.delay(n);
    }

    @Override
    public ScreenImage captureScreen(Rectangle rectangle) {
        BufferedImage bufferedImage = this.createScreenCapture(rectangle);
        Debug.log(6, "DesktoRobot.captureScreen img: " + bufferedImage, new Object[0]);
        return new ScreenImage(rectangle, bufferedImage);
    }

    @Override
    public Color getColorAt(int n, int n2) {
        return this.getPixelColor(n, n2);
    }

    @Override
    public void pressModifiers(int n) {
        if ((n & 1) != 0) {
            this.keyPress(16);
        }
        if ((n & 2) != 0) {
            this.keyPress(17);
        }
        if ((n & 8) != 0) {
            this.keyPress(18);
        }
        if ((n & 4) != 0) {
            if (Settings.isWindows()) {
                this.keyPress(524);
            } else {
                this.keyPress(157);
            }
        }
    }

    @Override
    public void releaseModifiers(int n) {
        if ((n & 1) != 0) {
            this.keyRelease(16);
        }
        if ((n & 2) != 0) {
            this.keyRelease(17);
        }
        if ((n & 8) != 0) {
            this.keyRelease(18);
        }
        if ((n & 4) != 0) {
            if (Settings.isWindows()) {
                this.keyRelease(524);
            } else {
                this.keyRelease(157);
            }
        }
    }

    @Override
    public void keyDown(String string) {
        if (string != null && !"".equals(string)) {
            for (int i = 0; i < string.length(); ++i) {
                if (heldKeys.indexOf(string.charAt(i)) != -1) continue;
                Debug.log(5, "press: " + string.charAt(i), new Object[0]);
                this.typeChar(string.charAt(i), RobotIF.KeyMode.PRESS_ONLY);
                heldKeys = heldKeys + string.charAt(i);
            }
            this.waitForIdle();
        }
    }

    @Override
    public void keyUp(String string) {
        if (string != null && !"".equals(string)) {
            for (int i = 0; i < string.length(); ++i) {
                int n = heldKeys.indexOf(string.charAt(i));
                if (n == -1) continue;
                Debug.log(5, "release: " + string.charAt(i), new Object[0]);
                this.typeChar(string.charAt(i), RobotIF.KeyMode.RELEASE_ONLY);
                heldKeys = heldKeys.substring(0, n) + heldKeys.substring(n + 1);
            }
            this.waitForIdle();
        }
    }

    @Override
    public void keyDown(int n) {
        if (!heldKeyCodes.contains(n)) {
            this.keyPress(n);
            heldKeyCodes.add(n);
        }
        this.waitForIdle();
    }

    @Override
    public void keyUp(int n) {
        if (heldKeyCodes.contains(n)) {
            this.keyRelease(n);
            heldKeyCodes.remove((Object)n);
        }
        this.waitForIdle();
    }

    @Override
    public void keyUp() {
        this.keyUp(heldKeys);
        for (int n : heldKeyCodes) {
            this.keyUp(n);
        }
    }

    private void doType(RobotIF.KeyMode keyMode, int ... nArray) {
        if (keyMode == RobotIF.KeyMode.PRESS_ONLY) {
            for (int i = 0; i < nArray.length; ++i) {
                this.keyPress(nArray[i]);
            }
        } else if (keyMode == RobotIF.KeyMode.RELEASE_ONLY) {
            for (int i = 0; i < nArray.length; ++i) {
                this.keyRelease(nArray[i]);
            }
        } else {
            int n;
            for (n = 0; n < nArray.length; ++n) {
                this.keyPress(nArray[n]);
            }
            for (n = 0; n < nArray.length; ++n) {
                this.keyRelease(nArray[n]);
            }
        }
    }

    @Override
    public void typeChar(char c, RobotIF.KeyMode keyMode) {
        this.doType(keyMode, Key.toJavaKeyCode(c));
    }

    @Override
    public void cleanup() {
        HotkeyManager.getInstance().cleanUp();
        this.keyUp();
    }
}

