/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import org.sikuli.script.Debug;
import org.sikuli.script.EventObserver;
import org.sikuli.script.EventSubject;
import org.sikuli.script.Location;
import org.sikuli.script.OverlayCapturePrompt;
import org.sikuli.script.Region;
import org.sikuli.script.RobotDesktop;
import org.sikuli.script.ScreenHighlighter;
import org.sikuli.script.ScreenIF;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;

public class Screen
extends Region
implements EventObserver,
ScreenIF {
    static GraphicsEnvironment genv = null;
    static GraphicsDevice[] gdevs;
    static RobotDesktop[] robots;
    static Screen[] screens;
    protected static int primaryScreen;
    protected static RobotDesktop actionRobot;
    private int curID = 0;
    private GraphicsDevice curGD;
    private Rectangle curROI;
    protected boolean waitPrompt;
    protected OverlayCapturePrompt prompt;
    protected ScreenImage lastScreenImage;

    private static void initScreens() {
        Screen.initScreens(false);
    }

    private static void initScreens(boolean bl) {
        int n;
        if (genv != null && !bl) {
            return;
        }
        genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        gdevs = genv.getScreenDevices();
        robots = new RobotDesktop[gdevs.length];
        screens = new Screen[gdevs.length];
        for (n = 0; n < gdevs.length; ++n) {
            Screen.screens[n] = new Screen(n, true);
            screens[n].initScreen();
            try {
                Screen.robots[n] = new RobotDesktop(screens[n]);
            }
            catch (AWTException aWTException) {
                Debug.error("Can't initialize Java Robot " + n, new Object[0]);
                Screen.robots[n] = null;
                Screen.screens[n] = null;
            }
            robots[n].setAutoDelay(10);
        }
        primaryScreen = 0;
        for (n = 0; n < Screen.getNumberScreens(); ++n) {
            if (Screen.getBounds((int)n).x != 0 || Screen.getBounds((int)n).y != 0) continue;
            primaryScreen = n;
            break;
        }
        try {
            actionRobot = new RobotDesktop(screens[primaryScreen]);
            actionRobot.setAutoDelay(10);
        }
        catch (AWTException aWTException) {
            Debug.error("Can't initialize Java Robot " + primaryScreen, new Object[0]);
            actionRobot = null;
            Screen.screens[Screen.primaryScreen] = null;
        }
        Debug.log(2, "Screen static initScreens", new Object[0]);
    }

    private Screen(int n, boolean bl) {
        this.curID = n;
        this.setScreen(this.curID);
    }

    public Screen(int n) {
        Screen.initScreens();
        this.curID = n;
        if (n < 0 || n >= gdevs.length) {
            this.curID = Screen.getPrimaryId();
        }
        this.initScreen();
    }

    public Screen() {
        Screen.initScreens();
        this.curID = Screen.getPrimaryId();
        this.initScreen();
    }

    private void initScreen() {
        this.curGD = gdevs[this.curID];
        if (screens[this.curID] == null) {
            this.x = 0;
            this.y = 0;
            this.vWidth = -1;
            this.w = -1;
            this.vHeight = -1;
            this.h = -1;
            this.curROI = new Rectangle(this.x, this.y, this.w, this.h);
            Debug.error("Screen cannot be used. No Robot: " + this.toStringShort(), new Object[0]);
        } else {
            Rectangle rectangle = this.getBounds();
            this.x = (int)rectangle.getX();
            this.y = (int)rectangle.getY();
            this.w = this.vWidth = (int)rectangle.getWidth();
            this.h = this.vHeight = (int)rectangle.getHeight();
            this.curROI = new Rectangle(this.x, this.y, this.w, this.h);
        }
        this.setScreen(this.curID);
    }

    protected Rectangle getCurROI() {
        return this.curROI;
    }

    protected void setCurROI(Rectangle rectangle) {
        this.curROI = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public Screen getScreen() {
        return this;
    }

    @Override
    protected void setScreen(Screen screen) {
    }

    public static void showMonitors() {
        Screen.initScreens();
        Debug.info("*** monitor configuration [ %s Screen(s)] ***", Screen.getNumberScreens());
        Debug.info("*** Primary is Screen %d", Screen.getPrimaryId());
        for (int i = 0; i < gdevs.length; ++i) {
            Debug.info("Screen %d: %s", i, Screen.getScreen(i).toStringShort());
        }
        Debug.info("*** end monitor configuration ***", new Object[0]);
    }

    public static void resetMonitors() {
        Debug.error("Re-evaluation of the monitor setup has been requested", new Object[0]);
        Debug.error("... Current Region objects might not be valid any longer", new Object[0]);
        Debug.error("... Use existing Region objects only if you know what you are doing", new Object[0]);
        Screen.initScreens(true);
        Debug.info("*** new monitor configuration [ %s Screen(s)] ***", Screen.getNumberScreens());
        Debug.info("*** Primary is Screen %d", Screen.getPrimaryId());
        for (int i = 0; i < gdevs.length; ++i) {
            Debug.error("Screen %d: %s", i, Screen.getScreen(i).toStringShort());
        }
        Debug.error("*** end monitor configuration ***", new Object[0]);
    }

    protected boolean useFullscreen() {
        return false;
    }

    private static int getValidID(int n) {
        Screen.initScreens();
        if (n < 0 || n >= gdevs.length) {
            return primaryScreen;
        }
        return n;
    }

    public static int getNumberScreens() {
        Screen.initScreens();
        return gdevs.length;
    }

    public static int getPrimaryId() {
        Screen.initScreens();
        return primaryScreen;
    }

    public static Screen getPrimaryScreen() {
        return screens[Screen.getPrimaryId()];
    }

    public static Screen getScreen(int n) {
        return screens[Screen.getValidID(n)];
    }

    public static Rectangle getBounds(int n) {
        return gdevs[Screen.getValidID(n)].getDefaultConfiguration().getBounds();
    }

    public static RobotDesktop getRobot(int n) {
        return robots[Screen.getValidID(n)];
    }

    public RobotDesktop getActionRobot() {
        return actionRobot;
    }

    public int getID() {
        return this.curID;
    }

    public GraphicsDevice getGraphicsDevice() {
        return this.curGD;
    }

    @Override
    public RobotDesktop getRobot() {
        return robots[this.curID];
    }

    @Override
    public Rectangle getBounds() {
        return this.curGD.getDefaultConfiguration().getBounds();
    }

    public Region newRegion(Location location, int n, int n2) {
        return Region.create(location.copyTo(this), n, n2);
    }

    public Location newLocation(Location location) {
        return new Location(location).copyTo(this);
    }

    @Override
    public ScreenImage capture() {
        return this.capture(this.getCurROI());
    }

    @Override
    public ScreenImage capture(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.newRegion(new Location(n, n2), n3, n4).getRect();
        return this.capture(rectangle);
    }

    @Override
    public ScreenImage capture(Rectangle rectangle) {
        rectangle = this.newRegion(new Location(rectangle.x, rectangle.y), rectangle.width, rectangle.height).getRect();
        Rectangle rectangle2 = this.getBounds();
        rectangle.x -= rectangle2.x;
        rectangle.y -= rectangle2.y;
        ScreenImage screenImage = robots[this.curID].captureScreen(rectangle);
        screenImage.x += rectangle2.x;
        screenImage.y += rectangle2.y;
        this.lastScreenImage = screenImage;
        Debug.log(2, "Screen.capture: " + rectangle, new Object[0]);
        return screenImage;
    }

    @Override
    public ScreenImage capture(Region region) {
        return this.capture(this.newRegion(region.getTopLeft(), region.getVW(), region.getVH()).getRect());
    }

    public ScreenImage userCapture() {
        return this.userCapture("Select a region on the screen");
    }

    public ScreenImage userCapture(final String string) {
        ScreenImage screenImage;
        this.waitPrompt = true;
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                Screen.this.prompt = new OverlayCapturePrompt(Screen.this, (EventObserver)Screen.this);
                Screen.this.prompt.prompt(string);
            }
        };
        thread2.start();
        try {
            int n = 0;
            while (this.waitPrompt) {
                Thread.sleep(100L);
                if (n++ <= 1000) continue;
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.lastScreenImage = screenImage = this.prompt.getSelection();
        this.prompt.close();
        return screenImage;
    }

    public Region selectRegion() {
        return this.selectRegion("Select a region on the screen");
    }

    public Region selectRegion(String string) {
        ScreenImage screenImage = this.userCapture(string);
        if (screenImage == null) {
            return null;
        }
        Rectangle rectangle = screenImage.getROI();
        return Region.create((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    @Override
    public void update(EventSubject eventSubject) {
        this.waitPrompt = false;
    }

    protected void showTarget(Location location) {
        this.showTarget(location, Settings.SlowMotionDelay);
    }

    protected void showTarget(Location location, double d) {
        if (Settings.ShowActions) {
            ScreenHighlighter screenHighlighter = new ScreenHighlighter(this);
            screenHighlighter.showTarget(location, (float)d);
        }
    }

    @Override
    public String toString() {
        Rectangle rectangle = this.getBounds();
        if (this.curROI.equals(rectangle)) {
            return String.format("S(%d)[%d,%d %dx%d] E:%s, T:%.1f", this.curID, (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight(), this.throwException ? "Y" : "N", this.autoWaitTimeout);
        }
        int n = (int)rectangle.getX();
        int n2 = (int)rectangle.getY();
        return String.format("S(%d)[%d,%d %dx%d] ROI[%d,%d, %dx%d] E:%s, T:%.1f", this.curID, n, n2, (int)rectangle.getWidth(), (int)rectangle.getHeight(), this.curROI.x - n, this.curROI.y - n2, this.curROI.width, this.curROI.height, this.throwException ? "Y" : "N", this.autoWaitTimeout);
    }

    public String toStringShort() {
        Rectangle rectangle = this.getBounds();
        return String.format("S(%d)[%d,%d %dx%d]", this.curID, (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    static {
        primaryScreen = -1;
    }
}

