/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.HashSet;
import java.util.Set;
import org.sikuli.script.Debug;
import org.sikuli.script.Location;
import org.sikuli.script.OverlayAnimator;
import org.sikuli.script.OverlayTransparentWindow;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;

public class ScreenHighlighter
extends OverlayTransparentWindow
implements MouseListener {
    static Color _overlayColor = new Color(0.0f, 0.0f, 0.0f, 0.6f);
    static Color _transparentColor = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    static Color _targetColor = new Color(1.0f, 0.0f, 0.0f, 0.7f);
    static final int TARGET_SIZE = 50;
    static final int DRAGGING_TIME = 200;
    static int MARGIN = 20;
    static Set<ScreenHighlighter> _opened = new HashSet<ScreenHighlighter>();
    Screen _scr;
    BufferedImage _screen = null;
    BufferedImage _darker_screen = null;
    BufferedImage bi = null;
    int srcx;
    int srcy;
    int destx;
    int desty;
    Location _lastTarget;
    boolean _borderOnly = false;
    boolean _native_transparent = false;
    boolean _double_buffered = false;
    OverlayAnimator _anim;
    BasicStroke _StrokeCross = new BasicStroke(1.0f);
    BasicStroke _StrokeCircle = new BasicStroke(2.0f);
    BasicStroke _StrokeBorder = new BasicStroke(3.0f);
    OverlayAnimator _aniX;
    OverlayAnimator _aniY;

    public ScreenHighlighter(Screen screen) {
        this._scr = screen;
        this.init();
        this.setVisible(false);
        this.setAlwaysOnTop(true);
    }

    private void init() {
        _opened.add(this);
        if (Settings.isLinux()) {
            this._double_buffered = true;
        } else if (Settings.isMac()) {
            this._native_transparent = true;
        }
        this.addMouseListener(this);
    }

    @Override
    public void close() {
        this.setVisible(false);
        _opened.remove(this);
        this.clean();
        try {
            Thread.sleep((int)(Settings.WaitAfterHighlight > 0.3f ? Settings.WaitAfterHighlight * 1000.0f - 300.0f : 300.0f));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void closeAfter(float f) {
        try {
            Thread.sleep((int)f * 1000 - 300);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.close();
    }

    public static void closeAll() {
        Debug.log(3, "close all ScreenHighlighter", new Object[0]);
        for (ScreenHighlighter screenHighlighter : _opened) {
            if (!screenHighlighter.isVisible()) continue;
            screenHighlighter.setVisible(false);
            screenHighlighter.clean();
        }
        _opened.clear();
    }

    private void clean() {
        this.dispose();
        this._screen = null;
        this._darker_screen = null;
        this.bi = null;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.setVisible(false);
    }

    public void highlight(Region region) {
        Region region2;
        if (Settings.isLinux()) {
            Debug.error("highlight does not work on Linux.", new Object[0]);
            return;
        }
        this._borderOnly = true;
        if (this._native_transparent) {
            region2 = region;
        } else {
            region2 = region.grow(3);
            this.captureScreen(region2.x, region2.y, region2.w, region2.h);
        }
        this.setLocation(region2.x, region2.y);
        this.setSize(region2.w, region2.h);
        this.setBackground(_transparentColor);
        this.setVisible(true);
        this.requestFocus();
    }

    public void highlight(Region region, float f) {
        this.highlight(region);
        this.closeAfter(f);
    }

    public void showTarget(Location location, float f) {
        int n = location.x - 25;
        int n2 = location.y - 25;
        this._lastTarget = location;
        Debug.log(2, "showTarget " + n + " " + n2 + " " + 50 + " " + 50, new Object[0]);
        this.showWindow(n, n2, 50, 50, f);
    }

    private void captureScreen(int n, int n2, int n3, int n4) {
        ScreenImage screenImage = this._scr.capture(n, n2, n3, n4);
        this._screen = screenImage.getImage();
        float f = 0.6f;
        RescaleOp rescaleOp = new RescaleOp(f, 0.0f, null);
        this._darker_screen = rescaleOp.filter(this._screen, null);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._native_transparent || this._screen != null) {
            Graphics2D graphics2D;
            if (this._double_buffered) {
                Graphics2D graphics2D2;
                if (this.bi == null || this.bi.getWidth(this) != this.getWidth() || this.bi.getHeight(this) != this.getHeight()) {
                    this.bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                }
                graphics2D = graphics2D2 = this.bi.createGraphics();
            } else {
                graphics2D = (Graphics2D)graphics;
            }
            graphics2D.setComposite(AlphaComposite.getInstance(1));
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this._borderOnly) {
                if (!this._native_transparent) {
                    graphics2D.drawImage((Image)this._screen, 0, 0, this);
                }
                this.drawBorder(graphics2D);
            } else {
                if (!this._native_transparent) {
                    graphics2D.drawImage((Image)this._screen, 0, 0, this);
                }
                this.drawTarget(graphics2D);
            }
            if (this._double_buffered) {
                ((Graphics2D)graphics).drawImage((Image)this.bi, 0, 0, this);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (this.isVisible()) {
            this.setVisible(false);
        }
    }

    private void drawBorder(Graphics2D graphics2D) {
        graphics2D.setColor(_targetColor);
        graphics2D.setStroke(this._StrokeBorder);
        int n = (int)this._StrokeBorder.getLineWidth();
        graphics2D.drawRect(n / 2, n / 2, this.getWidth() - n, this.getHeight() - n);
    }

    private void drawTarget(Graphics2D graphics2D) {
        int n = 25;
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(this._StrokeCross);
        graphics2D.drawLine(0, n, n * 2, n);
        graphics2D.drawLine(n, 0, n, n * 2);
        graphics2D.setColor(_targetColor);
        graphics2D.setStroke(this._StrokeCircle);
        this.drawCircle(n, n, n - 4, graphics2D);
        this.drawCircle(n, n, n - 10, graphics2D);
    }

    private void drawCircle(int n, int n2, int n3, Graphics graphics) {
        graphics.drawOval(n - n3, n2 - n3, n3 * 2, n3 * 2);
    }

    private void showWindow(int n, int n2, int n3, int n4, float f) {
        if (!this._native_transparent) {
            this.captureScreen(n, n2, n3, n4);
        }
        this.setLocation(n, n2);
        this.setSize(n3, n4);
        this.setBackground(_targetColor);
        this.repaint();
        this.setVisible(true);
        this.requestFocus();
        this.closeAfter(f);
    }
}

