/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.sikuli.script.Debug;
import org.sikuli.script.FileManager;
import org.sikuli.script.Settings;

public class ScreenImage {
    public int x;
    public int y;
    public int w;
    public int h;
    protected Rectangle _roi;
    protected BufferedImage _img;
    protected String _filename = null;

    public ScreenImage(Rectangle rectangle, BufferedImage bufferedImage) {
        this._img = bufferedImage;
        this._roi = rectangle;
        this.x = (int)rectangle.getX();
        this.y = (int)rectangle.getY();
        this.w = (int)rectangle.getWidth();
        this.h = (int)rectangle.getHeight();
    }

    @Deprecated
    public String getFilename() throws IOException {
        return this.getFile();
    }

    public String getFile() {
        if (this._filename == null) {
            this._filename = FileManager.saveTmpImage(this._img);
        }
        return this._filename;
    }

    public String getFile(String string) {
        try {
            File file = File.createTempFile("sikuli-image-", ".png", new File(string));
            this.createFile(file);
        }
        catch (IOException iOException) {
            Debug.error("ScreenImage.getFile: IOException", iOException);
            return null;
        }
        return this._filename;
    }

    public String getFile(String string, String string2) {
        if (string2 == null) {
            string2 = Settings.getTimestamp() + ".png";
        } else if (!string2.endsWith(".png")) {
            string2 = string2 + ".png";
        }
        try {
            File file = new File(string, string2);
            this.createFile(file);
        }
        catch (IOException iOException) {
            Debug.error("ScreenImage.getFile: IOException", iOException);
            return null;
        }
        return this._filename;
    }

    private void createFile(File file) throws IOException {
        String string = file.getAbsolutePath();
        if (this._filename == null || !string.equals(this._filename)) {
            ImageIO.write((RenderedImage)this._img, "png", file);
            this._filename = string;
        }
    }

    public BufferedImage getImage() {
        return this._img;
    }

    public Rectangle getROI() {
        return this._roi;
    }
}

