/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.CodeSource;
import java.util.Date;
import java.util.Properties;
import org.sikuli.script.Debug;
import org.sikuli.script.FileManager;
import org.sikuli.script.FindFailedResponse;
import org.sikuli.system.OSUtil;

public class Settings {
    public static String UserName;
    public static boolean makeJythonRegion;
    public static int breakPoint;
    public static String libPath;
    private static final String sikhomeEnv;
    private static final String sikhomeProp;
    public static final String libSub;
    private static String checkFileName;
    public static String libPathMac;
    public static final String libPathWin;
    public static final String libPathWin32;
    public static String OcrDataPath;
    public static String SikuliRepo;
    private static String[] args;
    public static String[] ServerList;
    public static final String SikuliVersionDefaultIDE = "SikuliX-IDE-1.0";
    public static final String SikuliVersionDefault = "SikuliX-1.0";
    public static final int SikuliVersionBetaN = 999;
    public static String SikuliVersionBeta;
    public static String SikuliVersionBetaIDE;
    public static String SikuliVersion;
    public static String SikuliVersionIDE;
    public static String BaseTempPath;
    private static boolean doDebug;
    public static final int ISWINDOWS = 0;
    public static final int ISMAC = 1;
    public static final int ISLINUX = 2;
    public static final int ISNOTSUPPORTED = 3;
    public static final float FOREVER = Float.POSITIVE_INFINITY;
    public static final int JavaVersion;
    public static final String JREVersion;
    public static FindFailedResponse defaultFindFailedResponse;
    public static final FindFailedResponse PROMPT;
    public static final FindFailedResponse RETRY;
    public static final FindFailedResponse SKIP;
    public static final FindFailedResponse ABORT;
    public static boolean ThrowException;
    public static float AutoWaitTimeout;
    public static float WaitScanRate;
    public static float ObserveScanRate;
    public static int ObserveMinChangedPixels;
    public static double MinSimilarity;
    public static float MoveMouseDelay;
    public static double DelayBeforeDrop;
    public static double DelayAfterDrag;
    public static String BundlePath;
    public static String jarResources;
    public static String libSource;
    public static boolean OcrTextSearch;
    public static boolean OcrTextRead;
    public static boolean ShowActions;
    public static float SlowMotionDelay;
    public static boolean Highlight;
    public static float DefaultHighlightTime;
    public static float WaitAfterHighlight;
    public static boolean ActionLogs;
    public static boolean InfoLogs;
    public static boolean DebugLogs;
    public static boolean ProfileLogs;
    public static boolean LogTime;
    public static boolean UserLogs;
    public static String UserLogPrefix;
    public static boolean UserLogTime;
    public static final int DefaultPadding = 50;
    static OSUtil osUtil;

    private static void db(String string) {
        if (doDebug) {
            System.out.println("[Settings] " + string);
        }
    }

    public static boolean isJava7() {
        return JavaVersion > 6;
    }

    public static void showJavaInfo() {
        Debug.log(1, "Running on Java " + JavaVersion + " (" + JREVersion + ")", new Object[0]);
    }

    public static String getFilePathSeperator() {
        return File.separator;
    }

    public static String getPathSeparator() {
        if (Settings.isWindows()) {
            return ";";
        }
        return ":";
    }

    public static String getSikuliDataPath() {
        String string;
        String string2;
        if (Settings.isWindows()) {
            string2 = System.getenv("APPDATA");
            string = "Sikuli";
        } else if (Settings.isMac()) {
            string2 = System.getProperty("user.home") + "/Library/Application Support";
            string = "Sikuli";
        } else {
            string2 = System.getProperty("user.home");
            string = ".sikuli";
        }
        File file = new File(string2, string);
        return file.getAbsolutePath();
    }

    public static String getUserExtPath() {
        String string = Settings.getSikuliDataPath() + File.separator + "extensions";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return string;
    }

    public static int getOS() {
        int n = 3;
        checkFileName = null;
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("mac")) {
            n = 1;
            checkFileName = "MadeForMac";
        } else if (string.startsWith("windows")) {
            n = 0;
            checkFileName = "MadeForWindows";
        } else if (string.startsWith("linux")) {
            n = 2;
            checkFileName = "MadeForLinux";
        }
        return n;
    }

    public static boolean isWindows() {
        return Settings.getOS() == 0;
    }

    public static boolean isLinux() {
        return Settings.getOS() == 2;
    }

    public static boolean isMac() {
        return Settings.getOS() == 1;
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static String getVersion() {
        return SikuliVersion;
    }

    static String getOSUtilClass() {
        String string = "org.sikuli.system.";
        switch (Settings.getOS()) {
            case 1: {
                return string + "MacUtil";
            }
            case 0: {
                return string + "WinUtil";
            }
            case 2: {
                return string + "LinuxUtil";
            }
        }
        Debug.error("Warning: Sikuli doesn't fully support your OS.", new Object[0]);
        return string + "DummyUtil";
    }

    public static OSUtil getOSUtil() {
        if (osUtil == null) {
            try {
                Class<?> clazz = Class.forName(Settings.getOSUtilClass());
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                osUtil = (OSUtil)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                Debug.error("Can't create OS Util: " + exception.getMessage(), new Object[0]);
            }
        }
        return osUtil;
    }

    public static void setArgs(String[] stringArray) {
        args = stringArray;
    }

    public static String[] getArgs() {
        return args;
    }

    public static String getTimestamp() {
        return new Date().getTime() + "";
    }

    static {
        Object object;
        Serializable serializable;
        String string;
        UserName = "UnKnown";
        makeJythonRegion = false;
        breakPoint = 0;
        libPath = null;
        sikhomeEnv = System.getenv("SIKULIX_HOME");
        sikhomeProp = System.getProperty("sikuli.Home");
        libSub = FileManager.slashify("SikuliX-IDE/libs", false);
        libPathMac = "/Applications/SikuliX-IDE.app/Contents/libs";
        libPathWin = FileManager.slashify(System.getenv("ProgramFiles"), true) + libSub;
        libPathWin32 = FileManager.slashify(System.getenv("ProgramFiles(x86)"), true) + libSub;
        args = new String[0];
        ServerList = new String[]{"https://dl.dropbox.com/u/42895525/SikuliX"};
        SikuliVersionBeta = "SikuliX-1.0-Beta999";
        SikuliVersionBetaIDE = "SikuliX-IDE-1.0-Beta999";
        SikuliVersion = "#sikuliversion#";
        doDebug = false;
        Properties properties = System.getProperties();
        if (System.getProperty("user.name") != null && !"".equals(System.getProperty("user.name"))) {
            UserName = System.getProperty("user.name");
        }
        BaseTempPath = System.getProperty("java.io.tmpdir") + File.separator + UserName;
        if (sikhomeProp != null && new File(string = new File(FileManager.slashify(sikhomeProp, true) + "libs").getAbsolutePath()).exists()) {
            libPath = string;
        }
        if (libPath == null && sikhomeEnv != null && new File(string = FileManager.slashify(sikhomeEnv, true) + "libs").exists()) {
            Settings.getOS();
            if (checkFileName != null && (new File(FileManager.slashify(string, true) + checkFileName + ".txt").exists() || new File(FileManager.slashify(string, true) + checkFileName + "32Bit.txt").exists() || new File(FileManager.slashify(string, true) + checkFileName + "64Bit.txt").exists())) {
                libPath = string;
            }
        }
        if (libPath == null && (serializable = Settings.class.getProtectionDomain().getCodeSource()) != null) {
            object = new File(((CodeSource)serializable).getLocation().getPath()).getParent();
            Settings.db("jar Location: " + (String)object);
            File file = new File((String)object, "libs");
            if (file.exists()) {
                Settings.db("folder libs found in jar parent folder");
                libPath = file.getAbsolutePath();
            } else {
                Settings.db("no folder libs in jar parent folder");
            }
        }
        if (libPath == null) {
            serializable = new File(System.getProperty("user.dir"));
            object = new File(System.getProperty("user.dir")).getParentFile();
            serializable = new File(FileManager.slashify(((File)serializable).getAbsolutePath(), true) + libSub);
            object = new File(FileManager.slashify(((File)object).getAbsolutePath(), true) + libSub);
            if (((File)serializable).exists()) {
                libPath = ((File)serializable).getAbsolutePath();
            } else if (((File)object).exists()) {
                libPath = ((File)object).getAbsolutePath();
            }
            if (libPath == null && ((File)(serializable = new File(FileManager.slashify(System.getProperty("user.home"), true) + libSub))).exists()) {
                libPath = ((File)serializable).getAbsolutePath();
            }
        }
        if (Settings.isMac() && libPath == null) {
            libPath = !new File(libPathMac).exists() ? FileManager.slashify("/Applications/" + libSub, true) : libPathMac;
        }
        if (Settings.isWindows() && libPath == null) {
            if (new File(libPathWin).exists()) {
                libPath = libPathWin;
            } else if (new File(libPathWin32).exists()) {
                libPath = libPathWin32;
            }
        }
        SikuliRepo = null;
        OcrDataPath = Settings.isWindows() || Settings.isMac() ? libPath : "/usr/local/share";
        SikuliVersion = SikuliVersionBeta;
        SikuliVersionIDE = SikuliVersionBetaIDE;
        JavaVersion = Integer.parseInt(System.getProperty("java.version").substring(2, 3));
        JREVersion = System.getProperty("java.runtime.version");
        defaultFindFailedResponse = FindFailedResponse.ABORT;
        PROMPT = FindFailedResponse.PROMPT;
        RETRY = FindFailedResponse.RETRY;
        SKIP = FindFailedResponse.SKIP;
        ABORT = FindFailedResponse.ABORT;
        ThrowException = true;
        AutoWaitTimeout = 3.0f;
        WaitScanRate = 3.0f;
        ObserveScanRate = 3.0f;
        ObserveMinChangedPixels = 50;
        MinSimilarity = 0.7;
        MoveMouseDelay = 0.5f;
        DelayBeforeDrop = 0.3;
        DelayAfterDrag = 0.3;
        BundlePath = null;
        jarResources = "META-INF/res/";
        libSource = "META-INF/libs/";
        OcrTextSearch = false;
        OcrTextRead = false;
        ShowActions = false;
        SlowMotionDelay = 2.0f;
        Highlight = false;
        DefaultHighlightTime = 2.0f;
        WaitAfterHighlight = 0.3f;
        ActionLogs = true;
        InfoLogs = true;
        DebugLogs = false;
        ProfileLogs = false;
        LogTime = false;
        UserLogs = true;
        UserLogPrefix = "user";
        UserLogTime = true;
        osUtil = null;
    }
}

