/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.AWTException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.script.Debug;
import org.sikuli.script.Finder;
import org.sikuli.script.Match;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;
import org.sikuli.script.SikuliEventAppear;
import org.sikuli.script.SikuliEventChange;
import org.sikuli.script.SikuliEventObserver;
import org.sikuli.script.SikuliEventVanish;
import org.sikuli.script.natives.FindInput;
import org.sikuli.script.natives.FindResult;
import org.sikuli.script.natives.FindResults;
import org.sikuli.script.natives.Mat;
import org.sikuli.script.natives.OpenCV;
import org.sikuli.script.natives.Vision;

public class SikuliEventManager {
    private Region _region;
    private Mat _lastImgMat = null;
    private Map<Object, State> _state;
    private Map<Object, Match> _lastMatch;
    private Map<Object, SikuliEventObserver> _appearOb;
    private Map<Object, SikuliEventObserver> _vanishOb;
    private Map<Integer, SikuliEventObserver> _changeOb;
    private int _minChanges;
    private boolean sthgLeft = true;

    public SikuliEventManager(Region region) {
        this._region = region;
        this._state = new HashMap<Object, State>();
        this._lastMatch = new HashMap<Object, Match>();
        this._appearOb = new HashMap<Object, SikuliEventObserver>();
        this._vanishOb = new HashMap<Object, SikuliEventObserver>();
        this._changeOb = new HashMap<Integer, SikuliEventObserver>();
    }

    public void initialize() {
    }

    private <PSC> float getSimiliarity(PSC PSC) {
        float f = -1.0f;
        if (PSC instanceof Pattern) {
            f = ((Pattern)PSC).getSimilar();
        }
        if (f < 0.0f) {
            f = (float)Settings.MinSimilarity;
        }
        return f;
    }

    public <PSC> void addAppearObserver(PSC PSC, SikuliEventObserver sikuliEventObserver) {
        this._appearOb.put(PSC, sikuliEventObserver);
        this._state.put(PSC, State.UNKNOWN);
    }

    public <PSC> void addVanishObserver(PSC PSC, SikuliEventObserver sikuliEventObserver) {
        this._vanishOb.put(PSC, sikuliEventObserver);
        this._state.put(PSC, State.UNKNOWN);
    }

    protected void callAppearObserver(Object object, Match match) {
        SikuliEventAppear sikuliEventAppear = new SikuliEventAppear(object, match, this._region);
        SikuliEventObserver sikuliEventObserver = this._appearOb.get(object);
        sikuliEventObserver.targetAppeared(sikuliEventAppear);
    }

    protected void callVanishObserver(Object object, Match match) {
        SikuliEventVanish sikuliEventVanish = new SikuliEventVanish(object, match, this._region);
        SikuliEventObserver sikuliEventObserver = this._vanishOb.get(object);
        sikuliEventObserver.targetVanished(sikuliEventVanish);
    }

    protected void checkPatterns(ScreenImage screenImage) {
        Finder finder = new Finder(screenImage, this._region);
        for (Object object : this._state.keySet()) {
            if (this._state.get(object) != State.UNKNOWN) continue;
            String string = object.getClass().isInstance("") ? finder.find((String)object) : finder.find((Pattern)object);
            if (null == string) {
                Debug.error("Observe: ImageFile not found", object);
                this._state.put(object, State.MISSING);
                continue;
            }
            Match match = null;
            boolean bl = false;
            if (finder.hasNext() && (match = finder.next()).getScore() >= (double)this.getSimiliarity(object)) {
                bl = true;
                this._lastMatch.put(object, match);
            }
            Debug.log(9, "check pattern: " + (Object)((Object)this._state.get(object)) + " match:" + bl, new Object[0]);
            this.sthgLeft = true;
            if (this._appearOb.containsKey(object)) {
                if (this._state.get(object) == State.APPEARED || !bl) continue;
                this._state.put(object, State.APPEARED);
                this.sthgLeft = false;
                this.callAppearObserver(object, match);
                continue;
            }
            if (!this._vanishOb.containsKey(object) || this._state.get(object) == State.VANISHED || bl) continue;
            this.sthgLeft = false;
            this._state.put(object, State.VANISHED);
            this.callVanishObserver(object, this._lastMatch.get(object));
        }
    }

    public void addChangeObserver(int n, SikuliEventObserver sikuliEventObserver) {
        this._changeOb.put(new Integer(n), sikuliEventObserver);
        this._minChanges = this.getMinChanges();
    }

    private int getMinChanges() {
        int n = Integer.MAX_VALUE;
        for (Integer n2 : this._changeOb.keySet()) {
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    protected void callChangeObserver(FindResults findResults) throws AWTException {
        for (Integer n : this._changeOb.keySet()) {
            Object object;
            ArrayList<Match> arrayList = new ArrayList<Match>();
            int n2 = 0;
            while ((long)n2 < findResults.size()) {
                object = findResults.get(n2);
                if (((FindResult)object).getW() * ((FindResult)object).getH() >= n) {
                    arrayList.add(this._region.toGlobalCoord(new Match((FindResult)object, this._region.getScreen())));
                }
                ++n2;
            }
            if (arrayList.size() <= 0) continue;
            SikuliEventChange sikuliEventChange = new SikuliEventChange(arrayList, this._region);
            object = this._changeOb.get(n);
            object.targetChanged(sikuliEventChange);
        }
    }

    protected void checkChanges(ScreenImage screenImage) {
        if (this._lastImgMat == null) {
            this._lastImgMat = OpenCV.convertBufferedImageToMat(screenImage.getImage());
            return;
        }
        FindInput findInput = new FindInput();
        findInput.setSource(this._lastImgMat);
        Mat mat = OpenCV.convertBufferedImageToMat(screenImage.getImage());
        findInput.setTarget(mat);
        findInput.setSimilarity(this._minChanges);
        FindResults findResults = Vision.findChanges(findInput);
        try {
            this.callChangeObserver(findResults);
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
        this._lastImgMat = mat;
    }

    public boolean update(ScreenImage screenImage) {
        boolean bl = this.sthgLeft;
        if (this.sthgLeft) {
            this.checkPatterns(screenImage);
        }
        bl = this.sthgLeft;
        if (this._changeOb.size() > 0) {
            this.checkChanges(screenImage);
            bl = true;
        }
        return bl;
    }

    protected void finalize() throws Throwable {
    }

    protected static enum State {
        UNKNOWN,
        MISSING,
        APPEARED,
        VANISHED;

    }
}

