/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.AWTException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;
import org.apache.commons.cli.CommandLine;
import org.python.util.jython;
import org.sikuli.script.App;
import org.sikuli.script.CommandArgs;
import org.sikuli.script.Debug;
import org.sikuli.script.Settings;
import org.sikuli.script.SikuliScriptRunner;

public class SikuliScript {
    private static CommandLine cmdLine;
    public static boolean runningInteractive;

    public static void main(String[] stringArray) {
        String[] stringArray2;
        Object object;
        int n = 0;
        Settings.showJavaInfo();
        CommandArgs commandArgs = new CommandArgs("SCRIPT");
        cmdLine = commandArgs.getCommandLine(stringArray);
        if (stringArray.length > 0 && !stringArray[0].startsWith("-")) {
            object = CommandArgs.getPyArgs(cmdLine);
            if (!object[0].endsWith(".sikuli") && !object[0].endsWith(".skl")) {
                Debug.error("No runnable script found: " + (String)object[0], new Object[0]);
                n = -2;
            } else {
                stringArray2 = new SikuliScriptRunner((String[])object);
                n = stringArray2.runPython(null);
            }
            Debug.info("You are using deprecated command line argument syntax!", new Object[0]);
            if (Settings.InfoLogs) {
                commandArgs.printHelp();
            }
            System.exit(n);
        }
        if (cmdLine != null) {
            if (cmdLine.hasOption("h")) {
                commandArgs.printHelp();
                return;
            }
            if (cmdLine.hasOption("i")) {
                object = CommandArgs.getPyArgs(cmdLine);
                stringArray2 = null;
                String[] stringArray3 = new String[]{"-i", "-c", "from sikuli import *; SikuliScript.runningInteractive = True; print \"Hello, this is your interactive Sikuli (rules for interactive Python apply)\\nuse the UP/DOWN arrow keys to walk through the input history\\nhelp()<enter> will output some basic Python information\\nshelp()<enter> will output some basic Sikuli information\\n... use ctrl-d to end the session\""};
                if (((Object)object).length > 0) {
                    stringArray2 = new String[((Object)object).length + stringArray3.length];
                    System.arraycopy(stringArray3, 0, stringArray2, 0, stringArray3.length);
                    System.arraycopy(object, 0, stringArray2, stringArray3.length, ((Object)object).length);
                } else {
                    stringArray2 = stringArray3;
                }
                jython.main(stringArray2);
                return;
            }
            if (cmdLine.hasOption("run")) {
                object = new SikuliScriptRunner(CommandArgs.getPyArgs(cmdLine), "SCRIPT");
                System.exit(((SikuliScriptRunner)object).runPython(null));
            } else if (cmdLine.hasOption("test")) {
                Debug.error("Sorry, support for option -t (test) not yet available - use X-1.0rc3", new Object[0]);
                System.exit(-2);
            }
        }
        Debug.error("Nothing to do! No valid arguments on commandline!", new Object[0]);
        commandArgs.printHelp();
    }

    public static void shelp() {
        if (runningInteractive) {
            System.out.println("**** this might be helpful ****");
            System.out.println("-- execute a line of code by pressing <enter>\n-- separate more than one statement on a line using ;\n-- Unlike the iDE, this command window will not vanish, when using a Sikuli feature\n   so take care, that all you need is visible on the screen\n-- to create an image interactively:\nimg = capture()\n-- use a captured image later:\nclick(img)");
        }
    }

    public static void setShowActions(boolean bl) {
        Settings.ShowActions = bl;
        if (bl && Settings.MoveMouseDelay < 1.0f) {
            Settings.MoveMouseDelay = 1.0f;
        }
    }

    public static String input(String string) {
        return JOptionPane.showInputDialog(string);
    }

    public static String input(String string, String string2) {
        return JOptionPane.showInputDialog(string, (Object)string2);
    }

    public static int switchApp(String string) {
        if (App.focus(string) != null) {
            return 0;
        }
        return -1;
    }

    public static int openApp(String string) {
        if (App.open(string) != null) {
            return 0;
        }
        return -1;
    }

    public static int closeApp(String string) {
        return App.close(string);
    }

    public static void popup(String string, String string2) {
        JOptionPane.showMessageDialog(null, string, string2, -1);
    }

    public static void popup(String string) {
        SikuliScript.popup(string, "Sikuli");
    }

    public static String run(String string) {
        String string2 = "";
        try {
            String string3;
            Process process = Runtime.getRuntime().exec(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string2 + '\n' + string3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    static {
        runningInteractive = false;
    }
}

