/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.python.util.PythonInterpreter;
import org.sikuli.script.CommandArgs;
import org.sikuli.script.Debug;
import org.sikuli.script.FileManager;
import org.sikuli.script.ImageLocator;
import org.sikuli.script.ScreenHighlighter;

public class SikuliScriptRunner {
    private static SikuliScriptRunner instance = null;
    private static PythonInterpreter interpreter = null;
    private String _runType;
    private static ArrayList<String> sysargv = null;
    private static ArrayList<String> syspath = null;
    private ArrayList<String> headers;
    private PythonInterpreter py;
    private Iterator<String> it;

    public static PythonInterpreter getPythonInterpreter() {
        if (interpreter == null) {
            PythonInterpreter.initialize(System.getProperties(), null, null);
            interpreter = new PythonInterpreter();
        }
        return interpreter;
    }

    public static SikuliScriptRunner getInstance(String[] stringArray) {
        if (instance == null) {
            instance = new SikuliScriptRunner(stringArray);
        }
        return instance;
    }

    public SikuliScriptRunner(String[] stringArray) {
        this.init(stringArray, "OTHER");
    }

    public SikuliScriptRunner(String[] stringArray, String string) {
        this.init(stringArray, string);
    }

    private void init(String[] stringArray, String string) {
        this._runType = string;
        if (interpreter == null) {
            PythonInterpreter.initialize(System.getProperties(), null, null);
            interpreter = new PythonInterpreter();
        }
        this.py = new PythonInterpreter();
        if (sysargv == null) {
            sysargv = new ArrayList<String>(Arrays.asList(stringArray));
            if (CommandArgs.isIDE(this._runType)) {
                sysargv.add(0, "");
            }
        }
        String[] stringArray2 = new String[]{"# coding=utf-8", "import sys", "#for e in sys.path: print e", "from __future__ import with_statement", "from sikuli import *", "resetROI()", "setThrowException(True)", "setShowActions(False)"};
        this.headers = new ArrayList<String>(Arrays.asList(stringArray2));
        for (String string2 : this.headers) {
            Debug.log(5, "PyInit: %s", string2);
            this.py.exec(string2);
        }
        this.headers.clear();
    }

    public int runPython(String object) {
        Object object2;
        if (object == null) {
            object = FileManager.slashify(sysargv.get(0), false);
            if (((String)object).endsWith(".skl")) {
                object2 = FileManager.unzipSKL((String)object);
                object = object2 != null ? object2 : null;
            } else if (!((String)object).endsWith(".sikuli")) {
                object = null;
            }
            if (object == null) {
                Debug.error("No runnable script found: " + sysargv.get(0), new Object[0]);
                return -2;
            }
        }
        if (!((File)(object2 = new File((String)object))).isAbsolute()) {
            object2 = new File(System.getProperty("user.dir"), (String)object);
        }
        object = ((File)object2).getPath();
        String string = ((File)object2).getName().substring(0, ((File)object2).getName().lastIndexOf(46));
        if (((File)(object2 = new File(((File)object2).getPath(), string + ".py"))).exists()) {
            try {
                return this.runPython((String)object, (File)object2);
            }
            catch (Exception exception) {
                return -1;
            }
        }
        Debug.error("No runnable script found: " + ((File)object2).getPath(), new Object[0]);
        return -2;
    }

    public int runPython(String string, File file) throws Exception {
        if (CommandArgs.isIDE(this._runType)) {
            if (sysargv.isEmpty()) {
                sysargv.add(string);
            } else {
                sysargv.set(0, string);
            }
        }
        this.addTempHeader("addModPath(\"" + FileManager.slashify(System.getProperty("user.dir"), true) + "\")");
        this.addTempHeader("addModPath(\"" + FileManager.slashify(string, true) + "\")");
        String string2 = new File(string).getParent();
        if (string2 != null) {
            this.addTempHeader("addModPath(\"" + FileManager.slashify(string2, true) + "\")");
        }
        this.addTempHeader("sys.argv = ['' for i in range(" + sysargv.size() + ")]");
        for (int i = 0; i < sysargv.size(); ++i) {
            this.addTempHeader("sys.argv[" + i + "]=r'" + sysargv.get(i) + "'");
        }
        for (String string3 : this.headers) {
            Debug.log(5, "PyInit: %s", string3);
            this.py.exec(string3);
        }
        this.headers.clear();
        String string4 = new File(string).getAbsolutePath();
        ImageLocator.setBundlePath(string4);
        int n = 0;
        boolean bl = false;
        try {
            this.py.execfile(file.getAbsolutePath());
        }
        catch (Exception exception) {
            if (CommandArgs.isIDE(this._runType)) {
                throw exception;
            }
            Pattern pattern = Pattern.compile("SystemExit: ([0-9]+)");
            Matcher matcher = pattern.matcher(exception.toString());
            if (matcher.find()) {
                n = Integer.parseInt(matcher.group(1));
                Debug.info("Exit code: " + n, new Object[0]);
            } else {
                Debug.error("Script aborted with some error:", exception);
                exception.printStackTrace();
                n = -1;
            }
            bl = true;
        }
        if (!bl) {
            try {
                this.py.exec("exit(0)");
            }
            catch (Exception exception) {
                Debug.info("Exit code: 0", new Object[0]);
            }
        }
        this.py.cleanup();
        return n;
    }

    public void close() {
        ScreenHighlighter.closeAll();
    }

    public void runSlowMotion() {
        this.addTempHeader("setShowActions(True)");
    }

    private void addTempHeader(String string) {
        this.headers.add(string);
    }

    private void addTempHeader(int n, String string) {
        this.headers.add(n, string);
    }

    private void addTempHeader(String[] stringArray) {
        this.headers.addAll(new ArrayList<String>(Arrays.asList(stringArray)));
    }

    private void addTempHeader(int n, String[] stringArray) {
        this.headers.addAll(n, new ArrayList<String>(Arrays.asList(stringArray)));
    }

    private void runPythonAsync(final String string) throws IOException {
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                SikuliScriptRunner.this.runPython(string);
            }
        };
        SwingUtilities.invokeLater(thread2);
    }
}

