/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.sikuli.script.Debug;
import org.sikuli.script.FileManager;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;
import org.sikuli.script.natives.Mat;
import org.sikuli.script.natives.OCRWord;
import org.sikuli.script.natives.OCRWords;
import org.sikuli.script.natives.OpenCV;
import org.sikuli.script.natives.Vision;

public class TextRecognizer {
    protected static TextRecognizer _instance = null;
    boolean _init_succeeded = false;

    protected TextRecognizer() {
        this.init();
    }

    public void init() {
        String string = FileManager.slashify(Settings.OcrDataPath, true);
        File file = new File(string, "tessdata");
        if (!file.exists()) {
            Settings.OcrDataPath = null;
            Debug.error("TextRecognizer: init: tessdata folder not found at %s", string);
            Settings.OcrTextRead = false;
            Settings.OcrTextSearch = false;
        } else {
            Debug.log(2, "OCR data path: " + string, new Object[0]);
            Vision.initOCR(FileManager.slashify(Settings.OcrDataPath, true));
            this._init_succeeded = true;
            Debug.log(2, "TextRecognizer: inited.", new Object[0]);
        }
    }

    public static TextRecognizer getInstance() {
        if (_instance == null) {
            _instance = new TextRecognizer();
            if (!TextRecognizer._instance._init_succeeded) {
                _instance = null;
            }
        }
        return _instance;
    }

    public List<Match> listText(ScreenImage screenImage, Region region) {
        return this.listText(screenImage, region, ListTextMode.WORD);
    }

    public List<Match> listText(ScreenImage screenImage, Region region, ListTextMode listTextMode) {
        Mat mat = OpenCV.convertBufferedImageToMat(screenImage.getImage());
        OCRWords oCRWords = Vision.recognize_as_ocrtext(mat).getWords();
        LinkedList<Match> linkedList = new LinkedList<Match>();
        int n = 0;
        while ((long)n < oCRWords.size()) {
            OCRWord oCRWord = oCRWords.get(n);
            Match match = new Match(region.x + oCRWord.getX(), region.y + oCRWord.getY(), oCRWord.getWidth(), oCRWord.getHeight(), oCRWord.getScore(), region.getScreen(), oCRWord.getString());
            linkedList.add(match);
            ++n;
        }
        return linkedList;
    }

    public String recognize(ScreenImage screenImage) {
        BufferedImage bufferedImage = screenImage.getImage();
        return this.recognize(bufferedImage);
    }

    public String recognize(BufferedImage bufferedImage) {
        if (this._init_succeeded) {
            Mat mat = OpenCV.convertBufferedImageToMat(bufferedImage);
            return Vision.recognize(mat).trim();
        }
        return "";
    }

    public String recognizeWord(ScreenImage screenImage) {
        BufferedImage bufferedImage = screenImage.getImage();
        return this.recognizeWord(bufferedImage);
    }

    public String recognizeWord(BufferedImage bufferedImage) {
        if (this._init_succeeded) {
            Mat mat = OpenCV.convertBufferedImageToMat(bufferedImage);
            return Vision.recognizeWord(mat).trim();
        }
        return "";
    }

    static {
        FileManager.loadLibrary("VisionProxy");
    }

    public static enum ListTextMode {
        WORD,
        LINE,
        PARAGRAPH;

    }
}

