/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.utility;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.sikuli.script.Debug;
import org.sikuli.script.Settings;
import org.sikuli.utility.UpdateFrame;

public class AutoUpdater {
    private String version;
    private String details;
    private int beta = 0;
    private String server = "";
    public boolean newMajor = false;
    public boolean newBeta = false;
    public boolean notAvailable = false;

    public String getServer() {
        return this.server;
    }

    public String getVersion() {
        if (this.newMajor) {
            return this.version;
        }
        if (this.newBeta) {
            return this.version + "-Beta" + this.beta;
        }
        return "";
    }

    public String getDetails() {
        return this.details;
    }

    public boolean checkUpdate() {
        for (String string : Settings.ServerList) {
            try {
                if (this.checkUpdate(string)) {
                    if (this.isNewer(this.version, Settings.SikuliVersion) && this.beta == 0 || !this.isNewer(this.version, Settings.SikuliVersion) && this.beta == 0) {
                        Debug.log(3, "A new major version is available: " + this.version, new Object[0]);
                        this.newMajor = true;
                    }
                    if (this.isNewer(this.version, Settings.SikuliVersion) && this.beta > 0 || !this.isNewer(this.version, Settings.SikuliVersion) && this.beta > 999) {
                        Debug.log(3, "A new beta version is available: " + this.version + "-Beta" + this.beta, new Object[0]);
                        this.newBeta = true;
                    }
                }
            }
            catch (Exception exception) {
                Debug.log(3, "No version info available at " + string, new Object[0]);
                this.notAvailable = true;
            }
            if (!this.newMajor && !this.newBeta) continue;
            return true;
        }
        return false;
    }

    private boolean checkUpdate(String string) throws IOException, MalformedURLException {
        URL uRL = new URL(string + "/latestversion");
        uRL.openConnection();
        URLConnection uRLConnection = uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string2 = bufferedReader.readLine();
        if (string2 != null) {
            String[] stringArray = string2.trim().split(" ");
            this.version = stringArray[0];
            if (stringArray.length > 1) {
                this.beta = Integer.parseInt(stringArray[1]);
            }
            this.details = "";
            string2 = bufferedReader.readLine();
            if (string2 != null) {
                if (string2.startsWith("DOWNLOAD")) {
                    this.server = string2.split(" ")[1];
                    this.details = this.details + "Pls. download at: " + this.server + "<br />";
                    this.details = this.details + "-------------------------------------------------------------------------";
                    this.details = this.details + "<br /><br />";
                } else {
                    this.details = this.details + string2;
                }
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                this.details = this.details + string2;
            }
            return true;
        }
        return false;
    }

    private boolean isNewer(String string, String string2) {
        return string.compareTo(string2) > 0;
    }

    public void showUpdateFrame(String string, String string2) {
        UpdateFrame updateFrame = new UpdateFrame(string, string2, this.server);
    }
}

