/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;

class AutoCompleteCombo
extends JComboBox {
    static final int TXT_FILENAME_LENGTH = 20;
    public int caretPos = 0;
    public JTextField editor = null;

    public AutoCompleteCombo(Object[] objectArray) {
        super(objectArray);
        this.setEditable(true);
        this.setHook();
    }

    private void hideDropDownButton() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof AbstractButton) || !component.isVisible()) continue;
            component.setVisible(false);
            this.revalidate();
        }
    }

    @Override
    public void setSelectedIndex(int n) {
        super.setSelectedIndex(n);
        this.editor.setText(this.getItemAt(n).toString());
        this.editor.setSelectionEnd(this.caretPos + this.editor.getText().length());
        this.editor.moveCaretPosition(this.caretPos);
    }

    public void setHook() {
        ComboBoxEditor comboBoxEditor = this.getEditor();
        if (comboBoxEditor.getEditorComponent() instanceof JTextField) {
            this.editor = (JTextField)comboBoxEditor.getEditorComponent();
            this.editor.setColumns(20);
            this.editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    char c = keyEvent.getKeyChar();
                    if (!Character.isLetterOrDigit(c) && !Character.isSpaceChar(c)) {
                        return;
                    }
                    AutoCompleteCombo.this.caretPos = AutoCompleteCombo.this.editor.getCaretPosition();
                    String string = "";
                    try {
                        string = AutoCompleteCombo.this.editor.getText(0, AutoCompleteCombo.this.caretPos);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    int n = AutoCompleteCombo.this.getItemCount();
                    for (int i = 0; i < n; ++i) {
                        int n2 = ((String)AutoCompleteCombo.this.getItemAt(i)).indexOf(string);
                        if (n2 != 0) continue;
                        AutoCompleteCombo.this.setSelectedIndex(i);
                        return;
                    }
                }
            });
        }
    }
}

