/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.sikuli.ide.ButtonOnToolbar;
import org.sikuli.ide.EditorPane;
import org.sikuli.ide.EditorPatternButton;
import org.sikuli.ide.EditorPatternLabel;
import org.sikuli.ide.PreferencesUser;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.ide.SikuliIDEI18N;
import org.sikuli.ide.util.Utils;
import org.sikuli.script.Debug;
import org.sikuli.script.EventObserver;
import org.sikuli.script.EventSubject;
import org.sikuli.script.OverlayCapturePrompt;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Settings;

class ButtonCapture
extends ButtonOnToolbar
implements ActionListener,
Cloneable,
EventObserver {
    protected Element _line;
    protected EditorPane _codePane;
    protected boolean _isCapturing;
    private EditorPatternLabel _lbl = null;

    public ButtonCapture() {
        URL uRL = SikuliIDE.class.getResource("/icons/camera-icon.png");
        this.setIcon(new ImageIcon(uRL));
        PreferencesUser preferencesUser = PreferencesUser.getInstance();
        String string = Utils.convertKeyToText(preferencesUser.getCaptureHotkey(), preferencesUser.getCaptureHotkeyModifiers());
        this.setToolTipText(SikuliIDE._I("btnCaptureHint", string));
        this.setText(SikuliIDE._I("btnCaptureLabel", new Object[0]));
        this.addActionListener(this);
        this._line = null;
    }

    public ButtonCapture(EditorPane editorPane, Element element) {
        this();
        this._line = element;
        this._codePane = editorPane;
        this.setUI(UIManager.getUI(this));
        this.setBorderPainted(true);
        this.setCursor(new Cursor(12));
        this.setText(null);
        URL uRL = SikuliIDE.class.getResource("/icons/capture-small.png");
        this.setIcon(new ImageIcon(uRL));
    }

    public ButtonCapture(EditorPatternLabel editorPatternLabel) {
        this._line = null;
        this._codePane = null;
        this._lbl = editorPatternLabel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Debug.log((int)2, (String)"capture!", (Object[])new Object[0]);
        this.captureWithAutoDelay();
    }

    public void captureWithAutoDelay() {
        if (this._isCapturing) {
            return;
        }
        PreferencesUser preferencesUser = PreferencesUser.getInstance();
        int n = (int)(preferencesUser.getCaptureDelay() * 1000.0) + 1;
        this.capture(n);
    }

    public void capture(final int n) {
        if (this._isCapturing) {
            return;
        }
        this._isCapturing = true;
        Thread thread = new Thread("capture"){

            @Override
            public void run() {
                SikuliIDE sikuliIDE = SikuliIDE.getInstance();
                if (n != 0) {
                    sikuliIDE.setVisible(false);
                }
                try {
                    Thread.sleep(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                OverlayCapturePrompt overlayCapturePrompt = new OverlayCapturePrompt(null, (EventObserver)ButtonCapture.this);
                overlayCapturePrompt.prompt("Select an image");
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n != 0) {
                    sikuliIDE.setVisible(true);
                }
                sikuliIDE.requestFocus();
            }
        };
        thread.start();
    }

    public void update(EventSubject eventSubject) {
        if (eventSubject instanceof OverlayCapturePrompt) {
            OverlayCapturePrompt overlayCapturePrompt = (OverlayCapturePrompt)eventSubject;
            ScreenImage screenImage = overlayCapturePrompt.getSelection();
            String string = null;
            EditorPane editorPane = SikuliIDE.getInstance().getCurrentCodePane();
            if (screenImage != null) {
                String string2;
                int n = PreferencesUser.getInstance().getAutoNamingMethod();
                if (n == 0) {
                    string = Settings.getTimestamp();
                } else if (n == 1) {
                    if (string == null || string.length() == 0) {
                        string = Settings.getTimestamp();
                    }
                } else {
                    string = this.getFilenameFromUser("");
                }
                if (string != null && (string2 = Utils.saveImage(screenImage.getImage(), string, editorPane.getSrcBundle())) != null) {
                    this.captureCompleted(Utils.slashify(string2, false), overlayCapturePrompt);
                    return;
                }
            }
            this.captureCompleted(null, overlayCapturePrompt);
        }
    }

    private String getFilenameFromUser(String string) {
        return (String)JOptionPane.showInputDialog(this._codePane, SikuliIDEI18N._I("msgEnterScreenshotFilename", new Object[0]), SikuliIDEI18N._I("dlgEnterScreenshotFilename", new Object[0]), -1, null, null, string);
    }

    public void captureCompleted(String string, OverlayCapturePrompt overlayCapturePrompt) {
        overlayCapturePrompt.close();
        Element element = this.getSrcElement();
        if (string != null) {
            Debug.log((int)2, (String)("captureCompleted: " + string), (Object[])new Object[0]);
            if (element == null) {
                if (this._codePane == null) {
                    if (this._lbl == null) {
                        this.insertAtCursor(SikuliIDE.getInstance().getCurrentCodePane(), string);
                    } else {
                        this._lbl.setFile(string);
                    }
                } else {
                    this.insertAtCursor(this._codePane, string);
                }
            } else {
                this.replaceButton(element, string);
            }
        } else {
            Debug.log((int)2, (String)"ButtonCapture: Capture cancelled", (Object[])new Object[0]);
            if (element != null) {
                this.replaceButton(element, "");
            }
        }
        this._isCapturing = false;
    }

    private Element getSrcElement() {
        return this._line;
    }

    private boolean replaceButton(Element element, String string) {
        if ("".equals(string) && this._codePane.showThumbs) {
            return true;
        }
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        int n3 = this._codePane.getSelectionStart();
        int n4 = this._codePane.getSelectionEnd();
        try {
            StyledDocument styledDocument = (StyledDocument)element.getDocument();
            String string2 = styledDocument.getText(n, n2 - n);
            Debug.log((int)3, (String)string2, (Object[])new Object[0]);
            for (int i = n; i < n2; ++i) {
                AttributeSet attributeSet;
                Component component;
                Element element2 = styledDocument.getCharacterElement(i);
                if (!element2.getName().equals("component") || !((component = StyleConstants.getComponent(attributeSet = element2.getAttributes())) instanceof ButtonCapture) && (!(component instanceof EditorPatternLabel) || !((EditorPatternLabel)component).isCaptureButton())) continue;
                Debug.log((int)5, (String)("button is at " + i), (Object[])new Object[0]);
                int n5 = this._codePane.getCaretPosition();
                this._codePane.select(i, i + 1);
                if (!this._codePane.showThumbs) {
                    this._codePane.insertString(new EditorPatternLabel(this._codePane, string).toString());
                } else {
                    component = PreferencesUser.getInstance().getPrefMoreImageThumbs() ? new EditorPatternButton(this._codePane, string) : new EditorPatternLabel(this._codePane, string, ((EditorPatternLabel)component).toString());
                    this._codePane.insertComponent(component);
                }
                this._codePane.setCaretPosition(n5);
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this._codePane.select(n3, n4);
        this._codePane.requestFocus();
        return true;
    }

    protected void insertAtCursor(EditorPane editorPane, String string) {
        String string2 = "\"" + new File(string).getName() + "\"";
        if (!editorPane.showThumbs) {
            editorPane.insertString(string2);
        } else if (PreferencesUser.getInstance().getPrefMoreImageThumbs()) {
            editorPane.insertComponent(new EditorPatternButton(editorPane, string));
        } else {
            editorPane.insertComponent(new EditorPatternLabel(editorPane, string));
        }
        editorPane.requestFocus();
    }

    @Override
    public String toString() {
        return "\"__CLICK-TO-CAPTURE__\"";
    }
}

