/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.text.Element;
import org.sikuli.ide.ButtonCapture;
import org.sikuli.ide.EditorKit;
import org.sikuli.ide.EditorPane;
import org.sikuli.ide.EditorPatternLabel;
import org.sikuli.ide.PreferencesUser;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.script.Debug;

public class ButtonGenCommand
extends JButton
implements ActionListener,
MouseListener {
    String _cmd;
    String[] _params;
    String _desc;
    EditorPane pane;
    PreferencesUser pref;
    static final String DefaultStyle = "color:black;font-family:monospace;font-size:10px; font-weight:normal";
    static final String HoverStyle = "color:#3333ff;font-family:monospace;font-size:10px; font-weight:bold;";
    static final String PressedStyle = "color:#3333ff;font-family:monospace;font-size:10px; font-weight:bold;text-decoration:underline;";

    public ButtonGenCommand(String string, String string2, String ... stringArray) {
        super(ButtonGenCommand.getRichRepresentation(DefaultStyle, string, string2, stringArray, false));
        this._cmd = string;
        this._params = stringArray;
        this._desc = string2;
        this.setToolTipText(ButtonGenCommand.getRichRepresentation(DefaultStyle, string, string2, stringArray, true));
        this.setHorizontalAlignment(2);
        this.addActionListener(this);
        this.addMouseListener(this);
        this.setBorderPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder(1, 2, 2, 1));
        this.setContentAreaFilled(false);
    }

    static String getParamHTML(String string, boolean bl, boolean bl2) {
        URL uRL = SikuliIDE.class.getResource("/icons/capture-small.png");
        String string2 = "";
        if (!bl) {
            string2 = string2 + ", ";
        }
        if (string.equals("PATTERN")) {
            string2 = string2 + "<img src=\"" + uRL + "\">";
        } else if (string.startsWith("[") && string.endsWith("]")) {
            if (bl2) {
                string2 = string2 + "<i>" + string + "</i>";
            }
        } else {
            string2 = string.startsWith("_") ? string2 + "<u>" + string.substring(1, 2) + "</u>" + string.substring(2) : string2 + string;
        }
        return !string2.equals(", ") ? string2 : "";
    }

    static String getRichRepresentation(String string, String string2, String string3, String[] stringArray, boolean bl) {
        String string4 = "<html><table><tr><td valign=\"middle\"><span style=\"" + string + "\">" + string2 + "(";
        int n = 0;
        for (String string5 : stringArray) {
            String string6 = ButtonGenCommand.getParamHTML(string5, n == 0, bl);
            if (!string6.equals("")) {
                string4 = string4 + "<td valign=\"middle\" style=\"" + string + "\">" + string6;
            }
            ++n;
        }
        string4 = string4 + "<td>)</table>";
        if (bl) {
            string4 = string4 + "<p> " + string3;
        }
        return string4;
    }

    static String getTextRepresentation(String string, String[] stringArray) {
        String string2 = "" + string + "(";
        int n = 0;
        for (String string3 : stringArray) {
            string2 = string2 + string3;
            if (++n >= stringArray.length) continue;
            string2 = string2 + ", ";
        }
        string2 = string2 + ")";
        return string2;
    }

    @Override
    public String toString() {
        return ButtonGenCommand.getTextRepresentation(this._cmd, this._params);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SikuliIDE sikuliIDE = SikuliIDE.getInstance();
        this.pane = sikuliIDE.getCurrentCodePane();
        this.pref = PreferencesUser.getInstance();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ButtonGenCommand.this.insertCommand();
            }
        });
    }

    public void insertCommand() {
        this.pref = PreferencesUser.getInstance();
        int n = -1;
        int n2 = 0;
        boolean bl = true;
        this.pane.insertString(this._cmd + "(");
        for (String string : this._params) {
            if (string.equals("PATTERN")) {
                Element element = this.pane.getLineAtCaret(-1);
                if (!bl) {
                    this.pane.insertString(", ");
                } else {
                    bl = false;
                }
                if (this.pref.getAutoCaptureForCmdButtons()) {
                    ButtonCapture buttonCapture = new ButtonCapture(this.pane, element);
                    this.pane.insertComponent(buttonCapture);
                    buttonCapture.captureWithAutoDelay();
                    continue;
                }
                if (this.pane.showThumbs) {
                    if (this.pref.getPrefMoreImageThumbs()) {
                        this.pane.insertComponent(new ButtonCapture());
                        continue;
                    }
                    this.pane.insertComponent(new EditorPatternLabel(this.pane, ""));
                    continue;
                }
                this.pane.insertString("\"" + EditorPatternLabel.CAPTURE + "\"");
                continue;
            }
            if (string.startsWith("[")) continue;
            if (!bl) {
                this.pane.insertString(", ");
            }
            if (string.startsWith("_")) {
                n = this.pane.getCaretPosition();
                string = string.substring(1);
            }
            n2 = string.length();
            this.pane.insertString(string);
            bl = false;
        }
        this.pane.insertString(")");
        new EditorKit.InsertBreakAction().insertBreak(this.pane);
        if (n >= 0) {
            this.pane.requestFocus();
            this.pane.setCaretPosition(n);
            this.pane.setSelectionStart(n);
            this.pane.setSelectionEnd(n + n2);
            Debug.log((int)5, (String)("sel: " + this.pane.getSelectedText()), (Object[])new Object[0]);
        }
        this.pane.requestFocus();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setText(ButtonGenCommand.getRichRepresentation(HoverStyle, this._cmd, this._desc, this._params, false));
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setText(ButtonGenCommand.getRichRepresentation(DefaultStyle, this._cmd, this._desc, this._params, false));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.setText(ButtonGenCommand.getRichRepresentation(PressedStyle, this._cmd, this._desc, this._params, false));
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.setText(ButtonGenCommand.getRichRepresentation(HoverStyle, this._cmd, this._desc, this._params, false));
    }
}

