/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class CloseableModernTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final String TABBED_PANE_UI_LOGGER = "TabbedPaneUI";
    private static final Logger LOGGER = Logger.getLogger("TabbedPaneUI");
    private int TAB_WIDTH = 0;
    private static int TAB_HEIGHT = 24;
    private static BufferedImage tabSelectedPressedEnd;
    private static BufferedImage tabSelectedPressed;
    private static BufferedImage tabSelectedEnd;
    private static BufferedImage tabSelected;
    private static BufferedImage tabClosePressed;
    private static BufferedImage tabCloseRollover;
    private static BufferedImage tabClose;
    private static BufferedImage tabRolloverEnd;
    private static BufferedImage tabRollover;
    private static BufferedImage tabEnd;
    private static BufferedImage tab;
    private int tabPressed = -1;
    private int width;

    public CloseableModernTabbedPaneUI(int n) {
        this.TAB_WIDTH = n;
    }

    @Override
    public void installUI(JComponent jComponent) {
        Serializable serializable;
        JTabbedPane jTabbedPane = (JTabbedPane)jComponent;
        jTabbedPane.setTabLayoutPolicy(1);
        Constructor<?> constructor = null;
        try {
            serializable = Class.forName("javax.swing.plaf.basic.BasicTabbedPaneUI$Actions");
            constructor = ((Class)serializable).getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            CloseableModernTabbedPaneUI.getLogger().warning("Cannot access tabbed pane UI actions");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            CloseableModernTabbedPaneUI.getLogger().warning("Constructor does not exist");
        }
        if (constructor != null) {
            serializable = jTabbedPane.getActionMap();
            try {
                ((ActionMap)serializable).put("scrollTabsBackwardAction", (Action)constructor.newInstance("scrollTabsBackwardAction"));
                ((ActionMap)serializable).put("scrollTabsForwardAction", (Action)constructor.newInstance("scrollTabsForwardAction"));
            }
            catch (InstantiationException instantiationException) {
                CloseableModernTabbedPaneUI.getLogger().warning("Cannot instantiate action");
            }
            catch (IllegalAccessException illegalAccessException) {
                CloseableModernTabbedPaneUI.getLogger().warning("Action cannot be accessed");
            }
            catch (InvocationTargetException invocationTargetException) {
                CloseableModernTabbedPaneUI.getLogger().warning("Cannot instantiate action");
            }
        }
        super.installUI(jComponent);
    }

    @Override
    protected void installDefaults() {
        UIManager.put("TabbedPane.tabAreaInsets", new Insets(0, 0, 0, 0));
        UIManager.put("TabbedPane.font", ((Font)UIManager.get("TabbedPane.font")).deriveFont(1));
        UIManager.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
        UIManager.put("TabbedPane.selectedTabPadInsets", new Insets(0, 0, 0, 0));
        super.installDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tabPane.addMouseListener(new TabPressedTracker());
    }

    @Override
    protected int calculateTabHeight(int n, int n2, int n3) {
        return TAB_HEIGHT;
    }

    @Override
    protected int calculateMaxTabHeight(int n) {
        return TAB_HEIGHT;
    }

    @Override
    protected int getTabRunIndent(int n, int n2) {
        return 0;
    }

    @Override
    protected void setRolloverTab(int n) {
        int n2 = this.getRolloverTab();
        super.setRolloverTab(n);
        if (n2 != n) {
            if (n2 != -1 && n2 < this.tabPane.getTabCount()) {
                this.tabPane.repaint(this.getTabBounds(this.tabPane, n2));
            }
            if (n != -1 && n < this.tabPane.getTabCount()) {
                this.tabPane.repaint(this.getTabBounds(this.tabPane, n));
            }
        }
    }

    @Override
    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        return this.rects[n2].width % 2;
    }

    @Override
    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        return 0;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getTabPlacement();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Insets insets = jComponent.getInsets();
        Dimension dimension = jComponent.getSize();
        if (this.tabPane.getTabPlacement() == 1) {
            graphics2D.drawImage(tab, insets.left, insets.top, dimension.width - insets.right - insets.left - 1, this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight), null);
            graphics2D.setColor(Color.gray);
            graphics2D.drawLine(dimension.width - 1, insets.top + 2, dimension.width - 1, insets.top + this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight));
        }
        super.paint(graphics2D, jComponent);
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        BufferedImage bufferedImage;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (bl) {
            if (this.tabPressed == n2) {
                bufferedImage = tabSelectedPressed;
                BufferedImage bufferedImage2 = tabSelectedPressedEnd;
            } else {
                bufferedImage = tabSelected;
                BufferedImage bufferedImage3 = tabSelectedEnd;
            }
        } else if (this.getRolloverTab() == n2) {
            bufferedImage = tabRollover;
            BufferedImage bufferedImage4 = tabRolloverEnd;
        } else {
            bufferedImage = tab;
            BufferedImage bufferedImage5 = tabEnd;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        graphics2D.drawImage(bufferedImage, n3 + 1, n4 + 1, n5 - 1, TAB_HEIGHT, null);
    }

    @Override
    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int n, int n2) {
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    static {
        try {
            tabSelectedPressedEnd = ImageIO.read(CloseableModernTabbedPaneUI.class.getResource("/icons/tab/tab-aqua-highlight-sep.png"));
            tabSelectedPressed = ImageIO.read(CloseableModernTabbedPaneUI.class.getResource("/icons/tab/tab-aqua-highlight.png"));
            tabSelectedEnd = ImageIO.read(CloseableModernTabbedPaneUI.class.getResource("/icons/tab/tab-aqua-sep.png"));
            tabSelected = ImageIO.read(CloseableModernTabbedPaneUI.class.getResource("/icons/tab/tab-aqua.png"));
            tabRolloverEnd = ImageIO.read(CloseableModernTabbedPaneUI.class.getResource("/icons/tab/tab-normal-highlight-sep.png"));
            tabRollover = ImageIO.read(CloseableModernTabbedPaneUI.class.getResource("/icons/tab/tab-normal-highlight.png"));
            tabEnd = ImageIO.read(CloseableModernTabbedPaneUI.class.getResource("/icons/tab/tab-normal-sep.png"));
            tab = ImageIO.read(CloseableModernTabbedPaneUI.class.getResource("/icons/tab/tab-normal.png"));
        }
        catch (IOException iOException) {
            LOGGER.warning("Could not load SliderUI images");
        }
    }

    private class TabPressedTracker
    extends MouseAdapter {
        private TabPressedTracker() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!CloseableModernTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            CloseableModernTabbedPaneUI.this.tabPressed = CloseableModernTabbedPaneUI.this.tabForCoordinate(CloseableModernTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
            if (CloseableModernTabbedPaneUI.this.tabPressed != -1) {
                CloseableModernTabbedPaneUI.this.tabPane.repaint(CloseableModernTabbedPaneUI.this.getTabBounds(CloseableModernTabbedPaneUI.this.tabPane, CloseableModernTabbedPaneUI.this.tabPressed));
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = CloseableModernTabbedPaneUI.this.tabPressed;
            CloseableModernTabbedPaneUI.this.tabPressed = -1;
            if (n != -1) {
                CloseableModernTabbedPaneUI.this.tabPane.repaint(CloseableModernTabbedPaneUI.this.getTabBounds(CloseableModernTabbedPaneUI.this.tabPane, n));
            }
        }
    }
}

