/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import javax.swing.text.View;
import org.sikuli.ide.CloseableTabbedPaneListener;
import org.sikuli.ide.SikuliIDE;

public class CloseableTabbedPane
extends JTabbedPane
implements MouseListener,
MouseMotionListener {
    private EventListenerList listenerList = null;
    private JViewport headerViewport = null;
    private Icon normalCloseIcon = SikuliIDE.getIconResource("/icons/close-normal.gif");
    private Icon hooverCloseIcon = SikuliIDE.getIconResource("/icons/close-hover.gif");
    private Icon pressedCloseIcon = SikuliIDE.getIconResource("/icons/close-pressed.gif");

    public CloseableTabbedPane() {
        this.init(2);
    }

    public CloseableTabbedPane(int n) {
        this.init(n);
    }

    private void init(int n) {
        this.listenerList = new EventListenerList();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (this.getUI() instanceof MetalTabbedPaneUI) {
            this.setUI(new CloseableMetalTabbedPaneUI(n));
        }
    }

    public void setCloseIcons(Icon icon, Icon icon2, Icon icon3) {
        this.normalCloseIcon = icon;
        this.hooverCloseIcon = icon2;
        this.pressedCloseIcon = icon3;
    }

    @Override
    public void addTab(String string, Component component) {
        this.addTab(string, component, null);
    }

    public void addTab(String string, Component component, Icon icon) {
        boolean bl = true;
        try {
            Component[] componentArray = null;
            componentArray = ((JComponent)component).getClientProperty("isClosable");
            if (componentArray != null) {
                bl = (Boolean)componentArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.addTab(string, bl ? new CloseTabIcon(icon) : null, component);
        if (this.headerViewport == null) {
            for (Component component2 : this.getComponents()) {
                if (!"TabbedPane.scrollableViewport".equals(component2.getName())) continue;
                this.headerViewport = (JViewport)component2;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.processMouseEvents(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            CloseTabIcon closeTabIcon = (CloseTabIcon)this.getIconAt(i);
            if (closeTabIcon == null) continue;
            closeTabIcon.mouseover = false;
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.processMouseEvents(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.processMouseEvents(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.processMouseEvents(mouseEvent);
    }

    private void processMouseEvents(MouseEvent mouseEvent) {
        block11: {
            Rectangle rectangle;
            Point point;
            Rectangle rectangle2;
            CloseTabIcon closeTabIcon;
            block13: {
                block12: {
                    int n = this.getUI().tabForCoordinate(this, mouseEvent.getX(), mouseEvent.getY());
                    if (n < 0) {
                        return;
                    }
                    closeTabIcon = (CloseTabIcon)this.getIconAt(n);
                    if (closeTabIcon == null) break block11;
                    rectangle2 = closeTabIcon.getBounds();
                    point = this.headerViewport == null ? new Point() : this.headerViewport.getViewPosition();
                    rectangle = new Rectangle(rectangle2.x - point.x, rectangle2.y - point.y, rectangle2.width, rectangle2.height);
                    if (mouseEvent.getID() != 501) break block12;
                    closeTabIcon.mousepressed = mouseEvent.getModifiers() == 16;
                    this.repaint(rectangle);
                    break block11;
                }
                if (mouseEvent.getID() == 503) break block13;
                if (mouseEvent.getID() == 506) break block13;
                if (mouseEvent.getID() != 500) break block11;
            }
            point.x += mouseEvent.getX();
            point.y += mouseEvent.getY();
            if (rectangle2.contains(point)) {
                if (mouseEvent.getID() == 500) {
                    int n = this.getSelectedIndex();
                    if (this.fireCloseTab(n)) {
                        if (n > 0) {
                            Rectangle rectangle3 = this.getUI().getTabBounds(this, n - 1);
                            MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID() + 1, System.currentTimeMillis(), mouseEvent.getModifiers(), rectangle3.x, rectangle3.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                            this.dispatchEvent(mouseEvent2);
                        }
                        this.remove(n);
                    } else {
                        closeTabIcon.mouseover = false;
                        closeTabIcon.mousepressed = false;
                        this.repaint(rectangle);
                    }
                } else {
                    closeTabIcon.mouseover = true;
                    closeTabIcon.mousepressed = mouseEvent.getModifiers() == 16;
                }
            } else {
                closeTabIcon.mouseover = false;
            }
            this.repaint(rectangle);
        }
    }

    public void addCloseableTabbedPaneListener(CloseableTabbedPaneListener closeableTabbedPaneListener) {
        this.listenerList.add(CloseableTabbedPaneListener.class, closeableTabbedPaneListener);
    }

    public void removeCloseableTabbedPaneListener(CloseableTabbedPaneListener closeableTabbedPaneListener) {
        this.listenerList.remove(CloseableTabbedPaneListener.class, closeableTabbedPaneListener);
    }

    public CloseableTabbedPaneListener[] getCloseableTabbedPaneListener() {
        return (CloseableTabbedPaneListener[])this.listenerList.getListeners(CloseableTabbedPaneListener.class);
    }

    protected boolean fireCloseTab(int n) {
        Object[] objectArray;
        boolean bl = true;
        for (Object object : objectArray = this.listenerList.getListenerList()) {
            if (!(object instanceof CloseableTabbedPaneListener) || ((CloseableTabbedPaneListener)object).closeTab(n)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    class CloseableMetalTabbedPaneUI
    extends MetalTabbedPaneUI {
        private int horizontalTextPosition = 2;

        public CloseableMetalTabbedPaneUI() {
        }

        public CloseableMetalTabbedPaneUI(int n) {
            this.horizontalTextPosition = n;
        }

        @Override
        protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
            rectangle2.y = 0;
            rectangle2.x = 0;
            rectangle3.y = 0;
            rectangle3.x = 0;
            View view = this.getTextViewForTab(n2);
            if (view != null) {
                this.tabPane.putClientProperty("html", view);
            }
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, this.horizontalTextPosition, rectangle, rectangle2, rectangle3, this.textIconGap + 2);
            this.tabPane.putClientProperty("html", null);
            int n3 = this.getTabLabelShiftX(n, n2, bl);
            int n4 = this.getTabLabelShiftY(n, n2, bl);
            rectangle2.x += n3;
            rectangle2.y += n4;
            rectangle3.x += n3;
            rectangle3.y += n4;
        }
    }

    class CloseableTabbedPaneUI
    extends BasicTabbedPaneUI {
        private int horizontalTextPosition = 2;
        Color darkTabColor = new Color(200, 200, 200);

        public CloseableTabbedPaneUI() {
        }

        public CloseableTabbedPaneUI(int n) {
            this.horizontalTextPosition = n;
        }

        @Override
        protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
            super.paintTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
            if (!bl) {
                graphics.setColor(this.darkTabColor);
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 1, n6 - 1);
            }
        }

        @Override
        protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
            rectangle2.y = 0;
            rectangle2.x = 0;
            rectangle3.y = 0;
            rectangle3.x = 0;
            View view = this.getTextViewForTab(n2);
            if (view != null) {
                this.tabPane.putClientProperty("html", view);
            }
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, this.horizontalTextPosition, rectangle, rectangle2, rectangle3, this.textIconGap + 2);
            this.tabPane.putClientProperty("html", null);
            int n3 = this.getTabLabelShiftX(n, n2, bl);
            int n4 = this.getTabLabelShiftY(n, n2, bl);
            rectangle2.x += n3;
            rectangle2.y += n4;
            rectangle3.x += n3;
            rectangle3.y += n4;
        }
    }

    class CloseTabIcon
    implements Icon {
        private int x_pos;
        private int y_pos;
        private int width;
        private int height;
        private Icon fileIcon;
        private boolean mouseover = false;
        private boolean mousepressed = false;

        public CloseTabIcon(Icon icon) {
            this.fileIcon = icon;
            this.width = 16;
            this.height = 16;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            boolean bl = true;
            try {
                JTabbedPane jTabbedPane = (JTabbedPane)component;
                int n3 = jTabbedPane.getUI().tabForCoordinate(jTabbedPane, n, n2);
                JComponent jComponent = (JComponent)jTabbedPane.getComponentAt(n3);
                Object object = null;
                object = jComponent.getClientProperty("isClosable");
                if (object != null) {
                    bl = (Boolean)object;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                this.x_pos = n;
                this.y_pos = n2;
                int n4 = n2 + 1;
                if (CloseableTabbedPane.this.normalCloseIcon != null && !this.mouseover) {
                    CloseableTabbedPane.this.normalCloseIcon.paintIcon(component, graphics, n, n4);
                } else if (CloseableTabbedPane.this.hooverCloseIcon != null && this.mouseover && !this.mousepressed) {
                    CloseableTabbedPane.this.hooverCloseIcon.paintIcon(component, graphics, n, n4);
                } else if (CloseableTabbedPane.this.pressedCloseIcon != null && this.mousepressed) {
                    CloseableTabbedPane.this.pressedCloseIcon.paintIcon(component, graphics, n, n4);
                } else {
                    ++n4;
                    Color color = graphics.getColor();
                    if (this.mousepressed && this.mouseover) {
                        graphics.setColor(Color.WHITE);
                        graphics.fillRect(n + 1, n4, 12, 13);
                    }
                    graphics.setColor(Color.GRAY);
                    if (this.mouseover) {
                        graphics.setColor(Color.RED);
                    }
                    graphics.drawLine(n + 3, n4 + 4, n + 9, n4 + 10);
                    graphics.drawLine(n + 4, n4 + 3, n + 10, n4 + 9);
                    graphics.drawLine(n + 10, n4 + 3, n + 3, n4 + 10);
                    graphics.drawLine(n + 10, n4 + 4, n + 4, n4 + 10);
                    graphics.drawLine(n + 9, n4 + 3, n + 3, n4 + 9);
                    graphics.setColor(color);
                    if (this.fileIcon != null) {
                        this.fileIcon.paintIcon(component, graphics, n + this.width, n4);
                    }
                }
            }
        }

        @Override
        public int getIconWidth() {
            return this.width + (this.fileIcon != null ? this.fileIcon.getIconWidth() : 0);
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x_pos, this.y_pos, this.width, this.height);
        }
    }
}

