/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.python.util.PythonInterpreter;
import org.sikuli.ide.JTextPaneHTMLTransferHandler;
import org.sikuli.ide.PreferencesUser;
import org.sikuli.script.Debug;
import org.sikuli.script.SikuliScriptRunner;

public class EditorConsolePane
extends JPanel
implements Runnable {
    static boolean ENABLE_IO_REDIRECT = true;
    static final int NUM_PIPES = 2;
    private JTextPane textArea;
    private Thread[] reader = new Thread[2];
    private boolean quit;
    private final PipedInputStream[] pin = new PipedInputStream[2];
    Thread errorThrower;
    static final String lineSep;

    public EditorConsolePane() {
        this.textArea = new JTextPane();
        this.textArea.setEditorKit(new HTMLEditorKit());
        this.textArea.setTransferHandler(new JTextPaneHTMLTransferHandler());
        String string = PreferencesUser.getInstance().getConsoleCSS();
        ((HTMLEditorKit)this.textArea.getEditorKit()).getStyleSheet().addRule(string);
        this.textArea.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.textArea), "Center");
        if (ENABLE_IO_REDIRECT) {
            PrintStream printStream;
            PipedOutputStream pipedOutputStream;
            for (int i = 0; i < 2; ++i) {
                this.pin[i] = new PipedInputStream();
            }
            Debug.log((int)2, (String)"Redirect stdout/stderr to console.", (Object[])new Object[0]);
            PythonInterpreter pythonInterpreter = SikuliScriptRunner.getPythonInterpreter();
            try {
                pipedOutputStream = new PipedOutputStream(this.pin[0]);
                printStream = new PrintStream(pipedOutputStream, true);
                System.setOut(printStream);
                pythonInterpreter.setOut((OutputStream)printStream);
            }
            catch (IOException iOException) {
                this.appendMsg("Couldn't redirect STDOUT to this console\n" + iOException.getMessage());
            }
            catch (SecurityException securityException) {
                this.appendMsg("Couldn't redirect STDOUT to this console\n" + securityException.getMessage());
            }
            try {
                pipedOutputStream = new PipedOutputStream(this.pin[1]);
                printStream = new PrintStream(pipedOutputStream, true);
                System.setErr(printStream);
                pythonInterpreter.setErr((OutputStream)printStream);
            }
            catch (IOException iOException) {
                this.appendMsg("Couldn't redirect STDERR to this console\n" + iOException.getMessage());
            }
            catch (SecurityException securityException) {
                this.appendMsg("Couldn't redirect STDERR to this console\n" + securityException.getMessage());
            }
            this.quit = false;
            for (int i = 0; i < 2; ++i) {
                this.reader[i] = new Thread(this);
                this.reader[i].setDaemon(true);
                this.reader[i].start();
            }
        }
    }

    private void appendMsg(String string) {
        HTMLDocument hTMLDocument = (HTMLDocument)this.textArea.getDocument();
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.textArea.getEditorKit();
        try {
            hTMLEditorKit.insertHTML(hTMLDocument, hTMLDocument.getLength(), string, 0, 0, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String htmlize(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Pattern pattern = Pattern.compile("\\[(.+?)\\].*");
        for (String string2 : string.split(lineSep)) {
            Matcher matcher = pattern.matcher(string2);
            String string3 = "normal";
            if (matcher.matches()) {
                string3 = matcher.group(1);
            }
            string2 = "<span class='" + string3 + "'>" + string2 + "</span>";
            stringBuilder.append(string2).append("<br>");
        }
        return stringBuilder.toString();
    }

    @Override
    public synchronized void run() {
        try {
            for (int i = 0; i < 2; ++i) {
                while (Thread.currentThread() == this.reader[i]) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.pin[i].available() != 0) {
                        String string = this.readLine(this.pin[i]);
                        this.appendMsg(this.htmlize(string));
                        this.textArea.setCaretPosition(this.textArea.getDocument().getLength() - 1);
                    }
                    if (!this.quit) continue;
                    return;
                }
            }
        }
        catch (Exception exception) {
            this.appendMsg("\nConsole reports an Internal error.");
            this.appendMsg("The error is: " + exception);
        }
    }

    public synchronized String readLine(PipedInputStream pipedInputStream) throws IOException {
        int n;
        String string = "";
        while ((n = pipedInputStream.available()) != 0) {
            byte[] byArray = new byte[n];
            pipedInputStream.read(byArray);
            if (!(string = string + new String(byArray, 0, byArray.length)).endsWith("\n") && !string.endsWith("\r\n") && !this.quit) continue;
        }
        return string;
    }

    public void clear() {
        this.textArea.setText("");
    }

    static {
        String string = System.getProperty("sikuli.console");
        if (string != null && string.equals("false")) {
            ENABLE_IO_REDIRECT = false;
        }
        lineSep = System.getProperty("line.separator");
    }
}

