/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.sikuli.ide.MyHighlighter;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.script.Debug;

public class EditorCurrentLineHighlighter
implements CaretListener {
    static final Color DEFAULT_COLOR = new Color(230, 230, 210);
    static final Color ERROR_COLOR = new Color(255, 105, 105);
    private Highlighter.HighlightPainter painter;
    private Object highlight = null;

    public EditorCurrentLineHighlighter(JTextPane jTextPane) {
        this(jTextPane, null);
    }

    public EditorCurrentLineHighlighter(JTextPane jTextPane, Color color) {
        Color color2 = color != null ? color : DEFAULT_COLOR;
        MyHighlighter myHighlighter = new MyHighlighter();
        jTextPane.setHighlighter(myHighlighter);
        this.painter = new DefaultHighlighter.DefaultHighlightPainter(color2);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        JTextComponent jTextComponent = (JTextComponent)caretEvent.getSource();
        if (jTextComponent != null) {
            if (jTextComponent.getSelectionStart() != jTextComponent.getSelectionEnd()) {
                this.removeLineHighlight(jTextComponent);
                jTextComponent.repaint();
                return;
            }
            int n = jTextComponent.getCaretPosition();
            Element element = Utilities.getParagraphElement(jTextComponent, n);
            int n2 = element.getStartOffset();
            int n3 = element.getEndOffset();
            Document document = jTextComponent.getDocument();
            Element element2 = document.getDefaultRootElement();
            int n4 = element2.getElementIndex(n);
            Debug.log((int)6, (String)("LineHighlight: Caret at " + n + " line " + n4 + " for " + n2 + "-" + n3), (Object[])new Object[0]);
            if (SikuliIDE.getStatusbar() != null) {
                SikuliIDE.getStatusbar().setCaretPosition(n4 + 1, n - n2 + 1);
            }
            this.removeLineHighlight(jTextComponent);
            try {
                this.highlight = jTextComponent.getHighlighter().addHighlight(n2, n3, this.painter);
                jTextComponent.repaint();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    private void removeLineHighlight(JTextComponent jTextComponent) {
        if (this.highlight != null) {
            jTextComponent.getHighlighter().removeHighlight(this.highlight);
            this.highlight = null;
        }
    }
}

