/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Color;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.sikuli.ide.PreferencesUser;
import org.sikuli.script.Debug;

public class EditorDocument
extends DefaultStyledDocument {
    private String word = "";
    private SimpleAttributeSet keyword = new SimpleAttributeSet();
    private SimpleAttributeSet string = new SimpleAttributeSet();
    private SimpleAttributeSet normal = new SimpleAttributeSet();
    private SimpleAttributeSet number = new SimpleAttributeSet();
    private SimpleAttributeSet comments = new SimpleAttributeSet();
    private int currentPos = 0;
    private Vector keywords = new Vector();
    public static int STRING_MODE = 10;
    public static int TEXT_MODE = 11;
    public static int NUMBER_MODE = 12;
    public static int COMMENT_MODE = 13;
    private int mode = TEXT_MODE;
    private static String[] arrKeywords = new String[]{"and", "del", "for", "is", "raise", "assert", "elif", "from", "lambda", "return", "break", "else", "global", "not", "try", "class", "except", "if", "or", "while", "continue", "exec", "import", "pass", "yield", "def", "finally", "in", "print"};

    private void initKeywords() {
        for (int i = 0; i < arrKeywords.length; ++i) {
            this.keywords.add(arrKeywords[i]);
        }
    }

    public EditorDocument() {
        this.initKeywords();
        StyleConstants.setBold(this.keyword, true);
        StyleConstants.setForeground(this.string, Color.magenta);
        StyleConstants.setForeground(this.number, Color.orange);
        StyleConstants.setForeground(this.comments, Color.blue);
        StyleConstants.setForeground(this.keyword, Color.red);
        StyleConstants.setItalic(this.comments, true);
    }

    private void insertKeyword(String string, int n) {
        try {
            this.remove(n - string.length(), string.length());
            super.insertString(n - string.length(), string, this.keyword);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void insertTextString(String string, int n) {
        try {
            this.remove(n, string.length());
            super.insertString(n, string, this.string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void insertNumberString(String string, int n) {
        try {
            this.remove(n, string.length());
            super.insertString(n, string, this.number);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void insertCommentString(String string, int n) {
        try {
            this.remove(n, string.length());
            super.insertString(n, string, this.comments);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void checkForString() {
        int n = this.currentPos;
        Element element = this.getParagraphElement(n);
        String string = "";
        try {
            string = this.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        }
        catch (Exception exception) {
            Debug.error((String)"no text", (Object[])new Object[0]);
            exception.printStackTrace();
        }
        int n2 = string.length();
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        if (element.getStartOffset() > 0) {
            n -= element.getStartOffset();
        }
        int n4 = 0;
        if (n >= 0 && n <= n2 - 1) {
            int n5;
            for (n3 = n; n3 > 0; --n3) {
                n5 = string.charAt(n3);
                if (n5 != 34) continue;
                ++n4;
            }
            n5 = n4 % 2;
            this.mode = n5 == 0 ? TEXT_MODE : STRING_MODE;
        }
    }

    private void checkForKeyword() {
        if (this.mode != TEXT_MODE) {
            return;
        }
        int n = this.currentPos;
        Element element = this.getParagraphElement(n);
        String string = "";
        try {
            string = this.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        }
        catch (Exception exception) {
            Debug.error((String)"no text", (Object[])new Object[0]);
            exception.printStackTrace();
        }
        int n2 = string.length();
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        if (element.getStartOffset() > 0) {
            n -= element.getStartOffset();
        }
        if (n >= 0 && n <= n2 - 1) {
            n3 = n;
            while (n3 > 0) {
                char c;
                if (!((c = string.charAt(--n3)) == ' ' | n3 == 0 | c == '(' | c == ')' | c == '{' | c == '}')) continue;
                if (n3 != 0) {
                    ++n3;
                }
                this.word = string.substring(n3, n);
                String string2 = this.word.trim().toLowerCase();
                if (!this.keywords.contains(string2)) break;
                this.insertKeyword(this.word, this.currentPos);
                break;
            }
        }
    }

    private void checkForNumber() {
        int n = this.currentPos;
        Element element = this.getParagraphElement(n);
        String string = "";
        try {
            string = this.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        }
        catch (Exception exception) {
            Debug.error((String)"no text", (Object[])new Object[0]);
            exception.printStackTrace();
        }
        int n2 = string.length();
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        if (element.getStartOffset() > 0) {
            n -= element.getStartOffset();
        }
        this.mode = TEXT_MODE;
        if (n >= 0 && n <= n2 - 1) {
            for (n3 = n; n3 > 0; --n3) {
                char c = string.charAt(n3);
                if (c == ' ' | n3 == 0 | c == '(' | c == ')' | c == '{' | c == '}') {
                    if (n3 != 0) {
                        ++n3;
                    }
                    this.mode = NUMBER_MODE;
                    break;
                }
                if (c >= '0' & c <= '9' | c == '.' | c == '+' | c == '-' | c == '/' | c == '*' | c == '%' | c == '=') continue;
                this.mode = TEXT_MODE;
                break;
            }
        }
    }

    private void checkForComment() {
        int n = this.currentPos;
        Element element = this.getParagraphElement(n);
        String string = "";
        try {
            string = this.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        }
        catch (Exception exception) {
            Debug.error((String)"no text", (Object[])new Object[0]);
            exception.printStackTrace();
        }
        int n2 = string.length();
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        if (element.getStartOffset() > 0) {
            n -= element.getStartOffset();
        }
        if (n >= 1 && n <= n2 - 1) {
            n3 = n;
            char c = string.charAt(n3 - 1);
            char c2 = string.charAt(n3);
            if (c == '/' && c2 == '*') {
                this.mode = COMMENT_MODE;
                this.insertCommentString("/*", this.currentPos - 1);
            } else if (c == '*' && c2 == '/') {
                this.mode = TEXT_MODE;
                this.insertCommentString("*/", this.currentPos - 1);
            }
        }
    }

    private void processChar(String string) {
        char c = string.charAt(0);
        if (this.mode != COMMENT_MODE) {
            this.mode = TEXT_MODE;
        }
        switch (c) {
            case '\n': 
            case ' ': 
            case '(': 
            case ')': 
            case '.': 
            case ';': 
            case '{': 
            case '}': {
                this.checkForKeyword();
                if (this.mode != STRING_MODE || c != '\n') break;
                this.mode = TEXT_MODE;
                break;
            }
            case '\"': {
                this.insertTextString(string, this.currentPos);
                this.checkForString();
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.checkForNumber();
                break;
            }
            case '*': 
            case '/': {
                this.checkForComment();
            }
        }
        if (this.mode == TEXT_MODE) {
            this.checkForString();
        }
        if (this.mode == STRING_MODE) {
            this.insertTextString(string, this.currentPos);
        } else if (this.mode == NUMBER_MODE) {
            this.insertNumberString(string, this.currentPos);
        } else if (this.mode == COMMENT_MODE) {
            this.insertCommentString(string, this.currentPos);
        }
    }

    private void processChar(char c) {
        char[] cArray = new char[]{c};
        String string = new String(cArray);
        this.processChar(string);
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        super.insertString(n, string, this.normal);
        System.out.println("insertString");
        int n2 = string.length();
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.currentPos = i;
            int n4 = i - n;
            this.processChar(string.charAt(n4));
        }
        this.currentPos = n;
    }

    public int getLineStartOffset(int n) throws BadLocationException {
        Element element = this.getDefaultRootElement();
        if (n < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (n >= element.getElementCount()) {
            throw new BadLocationException("No such line", this.getLength() + 1);
        }
        Element element2 = element.getElement(n);
        return element2.getStartOffset();
    }

    public int getLineLength(int n) throws BadLocationException {
        Element element = this.getDefaultRootElement();
        if (n < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (n >= element.getElementCount()) {
            throw new BadLocationException("No such line", this.getLength() + 1);
        }
        Element element2 = element.getElement(n);
        return element2.getEndOffset() - element2.getStartOffset();
    }

    public void changeIndentation(int n, int n2) throws BadLocationException {
        int n3;
        int n4;
        if (n2 == 0) {
            return;
        }
        int n5 = this.getLineStartOffset(n);
        int n6 = this.getLineLength(n);
        String string = this.getText(n5, n6);
        int n7 = 0;
        int n8 = PreferencesUser.getInstance().getTabWidth();
        for (n4 = 0; n4 < string.length(); ++n4) {
            n3 = string.charAt(n4);
            if (n3 == 32) {
                ++n7;
                continue;
            }
            if (n3 != 9) break;
            n7 += n8;
        }
        if ((n3 = n7 + n2) <= 0) {
            this.remove(n5, n4);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(n3 / n8 + n8 - 1);
        int n9 = 0;
        while (n9 + n8 <= n3) {
            stringBuilder.append('\t');
            n9 += n8;
        }
        while (n9 < n3) {
            stringBuilder.append(' ');
            ++n9;
        }
        this.replace(n5, n4, stringBuilder.toString(), null);
    }

    public Vector getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Vector vector) {
        if (vector != null) {
            this.keywords = vector;
        }
    }
}

