/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.ViewFactory;
import org.sikuli.ide.EditorPane;
import org.sikuli.ide.EditorPatternButton;
import org.sikuli.ide.EditorViewFactory;
import org.sikuli.ide.PreferencesUser;
import org.sikuli.ide.indentation.PythonIndentation;
import org.sikuli.script.Debug;

public class EditorKit
extends StyledEditorKit {
    private ViewFactory _viewFactory = new EditorViewFactory();
    public static final String deIndentAction = "SKL.DeindentAction";
    private static final TextAction[] defaultActions = new TextAction[]{new InsertTabAction(), new DeindentAction(), new InsertBreakAction(), new NextVisualPositionAction("caret-forward", false, 3), new NextVisualPositionAction("caret-backward", false, 7), new NextVisualPositionAction("selection-forward", true, 3), new NextVisualPositionAction("selection-backward", true, 7), new NextVisualPositionAction("caret-up", false, 1), new NextVisualPositionAction("caret-down", false, 5), new NextVisualPositionAction("selection-up", true, 1), new NextVisualPositionAction("selection-down", true, 5)};

    @Override
    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this._viewFactory;
    }

    @Override
    public String getContentType() {
        return "text/python";
    }

    @Override
    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        Debug.log((int)3, (String)"SikuliEditorKit.read", (Object[])new Object[0]);
        super.read(reader, document, n);
    }

    @Override
    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
        this.write(writer, document, n, n2, null);
    }

    public void write(Writer writer, Document document, int n, int n2, Map<String, String> map) throws IOException, BadLocationException {
        Debug.log((int)9, (String)"SikuliEditorKit.write %d %d", (Object[])new Object[]{n, n2});
        DefaultStyledDocument defaultStyledDocument = (DefaultStyledDocument)document;
        int n3 = n;
        while (n3 < n + n2) {
            Element element = defaultStyledDocument.getCharacterElement(n3);
            int n4 = element.getStartOffset();
            int n5 = element.getEndOffset();
            if (element.getName().equals("component")) {
                AttributeSet attributeSet = element.getAttributes();
                Component component = StyleConstants.getComponent(attributeSet);
                writer.write(component.toString());
                if (map != null && component instanceof EditorPatternButton) {
                    EditorPatternButton editorPatternButton = (EditorPatternButton)component;
                    String string = editorPatternButton.getFilename();
                    String string2 = new File(string).getName();
                    map.put(string2, string);
                    Debug.log((int)3, (String)("save image for copy&paste: " + string2 + " -> " + string), (Object[])new Object[0]);
                }
            } else {
                if (n4 < n) {
                    n4 = n;
                }
                if (n5 > n + n2) {
                    n5 = n + n2;
                }
                writer.write(document.getText(n4, n5 - n4));
            }
            n3 = n5;
        }
        writer.close();
    }

    private static class NextVisualPositionAction
    extends TextAction {
        private boolean select;
        private int direction;

        NextVisualPositionAction(String string, boolean bl, int n) {
            super(string);
            this.select = bl;
            this.direction = n;
        }

        private static int getNSVisualPosition(EditorPane editorPane, int n, int n2) {
            Element element = editorPane.getDocument().getDefaultRootElement();
            int n3 = element.getElementIndex(editorPane.getDocument().getLength() - 1) + 1;
            int n4 = element.getElementIndex(n) + 1;
            int n5 = n2 == 1 ? n4 - 1 : n4 + 1;
            try {
                if (n5 <= 0) {
                    return 0;
                }
                if (n5 > n3) {
                    return editorPane.getDocument().getLength();
                }
                Rectangle rectangle = editorPane.modelToView(n);
                Rectangle rectangle2 = n5 < n3 ? editorPane.modelToView(editorPane.getLineStartOffset(n5) - 1) : editorPane.modelToView(editorPane.getDocument().getLength() - 1);
                Debug.log((int)9, (String)("curRect: " + rectangle + ", tarEnd: " + rectangle2), (Object[])new Object[0]);
                n = rectangle.x > rectangle2.x ? editorPane.viewToModel(new Point(rectangle2.x, rectangle2.y)) : editorPane.viewToModel(new Point(rectangle.x, rectangle2.y));
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            return n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = (JTextComponent)actionEvent.getSource();
            Caret caret = jTextComponent.getCaret();
            int n = caret.getDot();
            if (!this.select) {
                switch (this.direction) {
                    case 3: {
                        int n2 = caret.getMark();
                        if (n == n2) break;
                        caret.setDot(Math.max(n, n2));
                        return;
                    }
                    case 7: {
                        int n2 = caret.getMark();
                        if (n == n2) break;
                        caret.setDot(Math.min(n, n2));
                        return;
                    }
                }
            }
            Position.Bias[] biasArray = new Position.Bias[1];
            Point point = caret.getMagicCaretPosition();
            try {
                Object object;
                if (point == null && (this.direction == 1 || this.direction == 5)) {
                    object = jTextComponent.modelToView(n);
                    point = new Point(((Rectangle)object).x, ((Rectangle)object).y);
                }
                n = (object = jTextComponent.getNavigationFilter()) != null ? ((NavigationFilter)object).getNextVisualPositionFrom(jTextComponent, n, Position.Bias.Forward, this.direction, biasArray) : (this.direction == 1 || this.direction == 5 ? NextVisualPositionAction.getNSVisualPosition((EditorPane)jTextComponent, n, this.direction) : jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n, Position.Bias.Forward, this.direction, biasArray));
                if (this.select) {
                    caret.moveDot(n);
                } else {
                    caret.setDot(n);
                }
                if (point != null && (this.direction == 1 || this.direction == 5)) {
                    caret.setMagicCaretPosition(point);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public static class InsertBreakAction
    extends TextAction {
        private PythonIndentation indentationLogic;

        public InsertBreakAction() {
            super("insert-break");
        }

        public InsertBreakAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Debug.log((int)5, (String)("InsertBreakAction " + actionEvent), (Object[])new Object[0]);
            JTextComponent jTextComponent = (JTextComponent)actionEvent.getSource();
            this.insertBreak(jTextComponent);
        }

        public void insertBreak(JTextComponent jTextComponent) {
            boolean bl;
            this.indentationLogic = ((EditorPane)jTextComponent).getIndentationLogic();
            boolean bl2 = bl = jTextComponent.getSelectionStart() == jTextComponent.getSelectionEnd();
            if (bl) {
                this.insertNewlineWithAutoIndent(jTextComponent);
            } else {
                jTextComponent.replaceSelection("\n");
            }
        }

        private void insertNewlineWithAutoIndent(JTextComponent jTextComponent) {
            try {
                int n = jTextComponent.getCaretPosition();
                StyledDocument styledDocument = (StyledDocument)jTextComponent.getDocument();
                Element element = styledDocument.getDefaultRootElement();
                int n2 = element.getElementIndex(n);
                Element element2 = element.getElement(n2);
                int n3 = element2.getStartOffset();
                int n4 = element2.getEndOffset() - 1;
                int n5 = n4 - n3;
                String string = styledDocument.getText(n3, n5);
                String string2 = PythonIndentation.getLeadingWhitespace(styledDocument, n3, n - n3);
                StringBuffer stringBuffer = new StringBuffer("\n");
                stringBuffer.append(string2);
                this.indentationLogic.checkIndent(string2, n2 + 1);
                int n6 = PythonIndentation.atEndOfLine(styledDocument, n, n3, string, n5);
                if (n6 == -1) {
                    if (string2.length() == n5) {
                        jTextComponent.setSelectionStart(n3);
                    } else {
                        jTextComponent.setSelectionStart(n);
                    }
                    jTextComponent.setSelectionEnd(n4);
                    jTextComponent.replaceSelection(stringBuffer.toString());
                    this.analyseDocument(styledDocument, n2, this.indentationLogic);
                    if (this.indentationLogic.shouldAddColon()) {
                        styledDocument.insertString(n, ":", null);
                        this.indentationLogic.setLastLineEndsWithColon();
                    }
                    int n7 = this.indentationLogic.shouldChangeLastLineIndentation();
                    int n8 = this.indentationLogic.shouldChangeNextLineIndentation();
                    if (n7 != 0) {
                        Debug.log((int)5, (String)"change line %d indentation by %d columns", (Object[])new Object[]{n2 + 1, n7});
                        this.changeIndentation((DefaultStyledDocument)styledDocument, n2, n7);
                        n8 += n7;
                    }
                    if (n8 != 0) {
                        Debug.log((int)5, (String)"change line %d indentation by %d columns", (Object[])new Object[]{n2 + 2, n8});
                        this.changeIndentation((DefaultStyledDocument)styledDocument, n2 + 1, n8);
                    }
                } else {
                    jTextComponent.setCaretPosition(n6);
                    styledDocument.insertString(n6, stringBuffer.toString(), null);
                    this.analyseDocument(styledDocument, n2, this.indentationLogic);
                    int n9 = this.indentationLogic.shouldChangeNextLineIndentation();
                    if (n9 != 0) {
                        Debug.log((int)5, (String)"change line %d indentation by %d columns", (Object[])new Object[]{n2 + 2, n9});
                        this.changeIndentation((DefaultStyledDocument)styledDocument, n2 + 1, n9);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                jTextComponent.replaceSelection("\n");
                badLocationException.printStackTrace();
            }
        }

        private void analyseDocument(Document document, int n, PythonIndentation pythonIndentation) throws BadLocationException {
            Element element = document.getDefaultRootElement();
            int n2 = element.getElement(n).getEndOffset();
            pythonIndentation.reset();
            pythonIndentation.addText(document.getText(0, n2));
        }

        private void changeIndentation(DefaultStyledDocument defaultStyledDocument, int n, int n2) throws BadLocationException {
            int n3;
            int n4;
            PreferencesUser preferencesUser = PreferencesUser.getInstance();
            boolean bl = preferencesUser.getExpandTab();
            int n5 = preferencesUser.getTabWidth();
            if (n < 0) {
                throw new BadLocationException("Negative line", -1);
            }
            Element element = defaultStyledDocument.getDefaultRootElement();
            if (n >= element.getElementCount()) {
                throw new BadLocationException("No such line", defaultStyledDocument.getLength() + 1);
            }
            if (n2 == 0) {
                return;
            }
            Element element2 = element.getElement(n);
            int n6 = element2.getStartOffset();
            int n7 = element2.getEndOffset() - n6;
            String string = defaultStyledDocument.getText(n6, n7);
            int n8 = 0;
            for (n4 = 0; n4 < string.length(); ++n4) {
                n3 = string.charAt(n4);
                if (n3 == 32) {
                    ++n8;
                    continue;
                }
                if (n3 != 9) break;
                n8 += n5;
            }
            if ((n3 = n8 + n2) <= 0) {
                defaultStyledDocument.remove(n6, n4);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder(n3 / n5 + n5 - 1);
            int n9 = 0;
            if (!bl) {
                while (n9 + n5 <= n3) {
                    stringBuilder.append('\t');
                    n9 += n5;
                }
            }
            while (n9 < n3) {
                stringBuilder.append(' ');
                ++n9;
            }
            defaultStyledDocument.replace(n6, n4, stringBuilder.toString(), null);
        }
    }

    public static class DeindentAction
    extends TextAction {
        private Segment segLine = new Segment();
        private PythonIndentation indentationLogic;

        public DeindentAction() {
            this(EditorKit.deIndentAction);
        }

        public DeindentAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Debug.log((int)5, (String)("DedentAction " + actionEvent), (Object[])new Object[0]);
            JTextComponent jTextComponent = (JTextComponent)actionEvent.getSource();
            this.actionPerformed(jTextComponent);
        }

        public void actionPerformed(JTextComponent jTextComponent) {
            this.indentationLogic = ((EditorPane)jTextComponent).getIndentationLogic();
            StyledDocument styledDocument = (StyledDocument)jTextComponent.getDocument();
            Element element = styledDocument.getDefaultRootElement();
            Caret caret = jTextComponent.getCaret();
            int n = caret.getDot();
            int n2 = caret.getMark();
            int n3 = element.getElementIndex(n);
            if (n != n2) {
                int n4 = element.getElementIndex(n2);
                int n5 = Math.min(n3, n4);
                int n6 = Math.max(n3, n4);
                try {
                    Element element2;
                    for (n3 = n5; n3 < n6; ++n3) {
                        element2 = element.getElement(n3);
                        this.handleDecreaseIndent(n3, element2, styledDocument);
                    }
                    element2 = element.getElement(n6);
                    int n7 = element2.getStartOffset();
                    if (Math.max(caret.getDot(), caret.getMark()) != n7) {
                        this.handleDecreaseIndent(n6, element2, styledDocument);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            } else {
                Element element3 = element.getElement(n3);
                try {
                    this.handleDecreaseIndent(n3, element3, styledDocument);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }

        private void handleDecreaseIndent(int n, Element element, StyledDocument styledDocument) throws BadLocationException {
            int n2 = element.getStartOffset();
            int n3 = element.getEndOffset() - 1;
            styledDocument.getText(n2, n3 - n2, this.segLine);
            int n4 = this.segLine.offset;
            n3 = n4 + this.segLine.count;
            if (n3 > n4) {
                String string = PythonIndentation.getLeadingWhitespace(styledDocument, n2, n3 - n2);
                int n5 = this.indentationLogic.checkDedent(string, n + 1);
                styledDocument.remove(n2, n5);
            }
        }
    }

    public static class InsertTabAction
    extends TextAction {
        private PythonIndentation indentationLogic;

        public InsertTabAction() {
            super("insert-tab");
        }

        public InsertTabAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Debug.log((int)5, (String)("InsertTabAction " + actionEvent), (Object[])new Object[0]);
            JTextComponent jTextComponent = (JTextComponent)actionEvent.getSource();
            this.actionPerformed(jTextComponent);
        }

        public void actionPerformed(JTextComponent jTextComponent) {
            int n;
            this.indentationLogic = ((EditorPane)jTextComponent).getIndentationLogic();
            boolean bl = false;
            Document document = jTextComponent.getDocument();
            Element element = document.getDefaultRootElement();
            String string = PreferencesUser.getInstance().getTabWhitespace();
            Caret caret = jTextComponent.getCaret();
            int n2 = caret.getDot();
            int n3 = caret.getMark();
            int n4 = element.getElementIndex(n2);
            if (n4 != (n = element.getElementIndex(n3))) {
                int n5 = Math.min(n4, n);
                int n6 = Math.max(n4, n);
                try {
                    int n7;
                    Element element2;
                    for (int i = n5; i < n6; ++i) {
                        element2 = element.getElement(i);
                        n7 = element2.getStartOffset();
                        document.insertString(n7, string, null);
                    }
                    element2 = element.getElement(n6);
                    n7 = element2.getStartOffset();
                    if (Math.max(caret.getDot(), caret.getMark()) != n7) {
                        document.insertString(n7, string, null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            } else {
                jTextComponent.replaceSelection(string);
            }
        }
    }
}

