/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SizeSequence;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.sikuli.ide.EditorPane;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.script.Debug;

public class EditorLineNumberView
extends JComponent
implements MouseListener {
    private static ImageIcon ERROR_ICON = SikuliIDE.getIconResource("/icons/error_icon.gif");
    private static final Color BORDER_COLOR = new Color(155, 155, 155);
    private static Color FG_COLOR = Color.GRAY;
    private static Color BG_COLOR = new Color(241, 241, 241);
    private static Color selBG_COLOR = new Color(220, 220, 220);
    private static final int WIDTH_TEMPLATE = 999;
    private static final int MARGIN = 5;
    private FontMetrics viewFontMetrics;
    private int maxNumberWidth;
    private int componentWidth;
    private int textTopInset;
    private int textFontAscent;
    private int textFontHeight;
    private EditorPane text;
    private SizeSequence sizes;
    private int startLine = 0;
    private boolean structureChanged = true;
    private Set<Integer> errLines = new HashSet<Integer>();
    private int line;

    public EditorLineNumberView(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            throw new IllegalArgumentException("Text component required! Cannot be null!");
        }
        this.text = (EditorPane)jTextComponent;
        this.updateCachedMetrics();
        UpdateHandler updateHandler = new UpdateHandler();
        jTextComponent.getDocument().addDocumentListener(updateHandler);
        jTextComponent.addPropertyChangeListener(updateHandler);
        jTextComponent.addComponentListener(updateHandler);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, BORDER_COLOR));
        this.setForeground(FG_COLOR);
        this.setBackground(BG_COLOR);
        this.init();
    }

    private void init() {
        this.addMouseListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.componentWidth, this.text.getHeight());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateCachedMetrics();
    }

    private void updateCachedMetrics() {
        Font font = this.text.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.textFontHeight = fontMetrics.getHeight();
        this.textFontAscent = fontMetrics.getAscent();
        this.textTopInset = this.text.getInsets().top;
        Font font2 = this.getFont();
        boolean bl = false;
        if (font2 == null) {
            font2 = UIManager.getFont("Label.font");
            font2 = font2.deriveFont(0);
            bl = true;
        }
        if (font2.getSize() > font.getSize()) {
            font2 = font2.deriveFont(font.getSize2D());
            bl = true;
        }
        this.viewFontMetrics = this.getFontMetrics(font2);
        this.maxNumberWidth = this.viewFontMetrics.stringWidth(String.valueOf(999));
        this.componentWidth = 10 + this.maxNumberWidth;
        if (bl) {
            super.setFont(font2);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.updateSizes();
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.sizes == null) {
            return;
        }
        graphics.setColor(this.getForeground());
        int n = rectangle.y - this.textTopInset;
        int n2 = this.sizes.getIndex(n);
        int n3 = this.sizes.getIndex(n + rectangle.height);
        String string = "";
        for (int i = n2; i < n3; ++i) {
            string = String.valueOf(i + 1);
            int n4 = 5 + this.maxNumberWidth - this.viewFontMetrics.stringWidth(string);
            int n5 = (this.sizes.getPosition(i) + this.sizes.getPosition(i + 1)) / 2 + this.textFontAscent / 2 + this.textTopInset / 2;
            if (this.errLines.contains(i + 1)) {
                graphics.drawImage(ERROR_ICON.getImage(), 0, n5 - 12 + 1, 12, 12, null);
                graphics.setColor(Color.RED);
            } else {
                graphics.setColor(this.getForeground());
            }
            graphics.drawString(string, n4, n5);
        }
    }

    private void updateSizes() {
        if (this.startLine < 0) {
            return;
        }
        if (this.structureChanged) {
            int n = this.getAdjustedLineCount();
            this.sizes = new SizeSequence(n);
            for (int i = 0; i < n; ++i) {
                this.sizes.setSize(i, this.getLineHeight(i));
            }
            this.structureChanged = false;
        } else if (this.sizes != null) {
            this.sizes.setSize(this.startLine, this.getLineHeight(this.startLine));
        }
        this.startLine = -1;
    }

    private int getAdjustedLineCount() {
        int n;
        Element element = this.text.getDocument().getDefaultRootElement();
        Element element2 = element.getElement((n = element.getElementCount()) - 1);
        if (element2.getEndOffset() - element2.getStartOffset() >= 1) {
            return n;
        }
        return n - 1;
    }

    private int getLineHeight(int n) {
        int n2 = this.sizes.getPosition(n) + this.textTopInset;
        Element element = this.text.getDocument().getDefaultRootElement().getElement(n);
        Rectangle rectangle = null;
        int n3 = this.textFontHeight;
        int n4 = 0;
        try {
            if (element.getElementCount() < 2) {
                rectangle = this.text.modelToView(element.getEndOffset() - 1);
            } else {
                for (int i = 0; i < element.getElementCount(); ++i) {
                    Element element2 = element.getElement(i);
                    if (!"component".equals(element2.getName())) continue;
                    Rectangle rectangle2 = this.text.modelToView(element2.getStartOffset());
                    if (n4 >= rectangle2.height) continue;
                    n4 = rectangle2.height;
                    rectangle = rectangle2;
                }
            }
            if (rectangle == null) {
                rectangle = this.text.modelToView(element.getEndOffset() - 1);
            }
            n3 = rectangle.y - n2 + rectangle.height;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n3;
    }

    public void addErrorMark(int n) {
        this.errLines.add(n);
    }

    public void resetErrorMark() {
        this.errLines.clear();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setBackground(selBG_COLOR);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setBackground(BG_COLOR);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 1) {
            this.text.jumpTo(this.sizes.getIndex(mouseEvent.getY()) + 1);
        } else if (mouseEvent.getClickCount() == 2) {
            this.text.getDocument();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void viewChanged(int n, boolean bl) {
        this.startLine = n;
        this.structureChanged |= bl;
        this.revalidate();
        this.repaint();
    }

    class UpdateHandler
    extends ComponentAdapter
    implements PropertyChangeListener,
    DocumentListener {
        UpdateHandler() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            EditorLineNumberView.this.viewChanged(0, true);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            String string = propertyChangeEvent.getPropertyName();
            if ("document".equals(string)) {
                if (object != null && object instanceof Document) {
                    ((Document)object).removeDocumentListener(this);
                }
                if (object2 != null && object2 instanceof Document) {
                    ((Document)object2).addDocumentListener(this);
                }
            }
            EditorLineNumberView.this.updateCachedMetrics();
            EditorLineNumberView.this.viewChanged(0, true);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent, "insert");
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent, "remove");
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void update(DocumentEvent documentEvent, String string) {
            Element element = EditorLineNumberView.this.text.getDocument().getDefaultRootElement();
            int n = element.getElementIndex(documentEvent.getOffset());
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            Debug.log((int)6, (String)("LineNumbers: " + string + " update - struct changed: " + (elementChange != null)), (Object[])new Object[0]);
            EditorLineNumberView.this.viewChanged(n, elementChange != null);
        }
    }
}

