/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import org.python.util.PythonInterpreter;
import org.sikuli.ide.ButtonCapture;
import org.sikuli.ide.EditorCurrentLineHighlighter;
import org.sikuli.ide.EditorKit;
import org.sikuli.ide.EditorPatternButton;
import org.sikuli.ide.EditorPatternLabel;
import org.sikuli.ide.EditorRegionButton;
import org.sikuli.ide.EditorRegionLabel;
import org.sikuli.ide.EditorUndoManager;
import org.sikuli.ide.GeneralFileFilter;
import org.sikuli.ide.PreferencesUser;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.ide.SikuliIDEFileChooser;
import org.sikuli.ide.SikuliIDEI18N;
import org.sikuli.ide.indentation.PythonIndentation;
import org.sikuli.ide.util.Utils;
import org.sikuli.script.Debug;
import org.sikuli.script.FileManager;
import org.sikuli.script.ImageLocator;
import org.sikuli.script.Location;
import org.sikuli.script.Settings;
import org.sikuli.script.SikuliScriptRunner;

public class EditorPane
extends JTextPane
implements KeyListener,
CaretListener {
    private PreferencesUser pref = PreferencesUser.getInstance();
    private File _editingFile;
    private String _srcBundlePath = null;
    private boolean _srcBundleTemp = false;
    private boolean _dirty = false;
    private EditorCurrentLineHighlighter _highlighter;
    private EditorUndoManager _undo = null;
    private boolean hasErrorHighlight = false;
    public boolean showThumbs = !this.pref.getPrefMorePlainText();
    private PythonIndentation _indentationLogic;
    static Pattern patPngStr = Pattern.compile("(\"[^\"]+?\\.(?i)(png|jpg)\")");
    static Pattern patCaptureBtn = Pattern.compile("(\"__CLICK-TO-CAPTURE__\")");
    static Pattern patPatternStr = Pattern.compile("\\b(Pattern\\s*\\(\".*?\"\\)(\\.\\w+\\([^)]*\\))+)");
    static Pattern patRegionStr = Pattern.compile("\\b(Region\\s*\\([\\d\\s,]+\\))");
    static final InputStream SikuliToHtmlConverter = SikuliIDE.class.getResourceAsStream("/scripts/sikuli2html.py");
    static String pyConverter = FileManager.convertStreamToString((InputStream)SikuliToHtmlConverter);
    static final InputStream SikuliBundleCleaner = SikuliIDE.class.getResourceAsStream("/scripts/clean-dot-sikuli.py");
    static String pyBundleCleaner = FileManager.convertStreamToString((InputStream)SikuliBundleCleaner);
    private int _caret_last_x = -1;
    private boolean _can_update_caret_last_x = true;
    private String _tabString = "   ";
    private Class _historyBtnClass;

    public EditorPane() {
        this.setEditorKitForContentType("text/python", new EditorKit());
        this.setContentType("text/python");
        this.initKeyMap();
        this.setTransferHandler(new MyTransferHandler());
        this._highlighter = new EditorCurrentLineHighlighter(this);
        this.addCaretListener(this._highlighter);
        this.setFont(new Font(this.pref.getFontName(), 0, this.pref.getFontSize()));
        this.setMargin(new Insets(3, 3, 3, 3));
        this.setBackground(Color.WHITE);
        if (!Settings.isMac()) {
            this.setSelectionColor(new Color(170, 200, 255));
        }
        this.updateDocumentListeners();
        this._indentationLogic = new PythonIndentation();
        this._indentationLogic.setTabWidth(this.pref.getTabWidth());
        this.pref.addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if (preferenceChangeEvent.getKey().equals("TAB_WIDTH")) {
                    EditorPane.this._indentationLogic.setTabWidth(Integer.parseInt(preferenceChangeEvent.getNewValue()));
                }
            }
        });
        this.initEditorPane();
    }

    private void initEditorPane() {
        this.addKeyListener(this);
        this.addCaretListener(this);
    }

    private void updateDocumentListeners() {
        this.getDocument().addDocumentListener(new DirtyHandler());
        this.getDocument().addUndoableEditListener(this.getUndoManager());
    }

    public EditorUndoManager getUndoManager() {
        if (this._undo == null) {
            this._undo = new EditorUndoManager();
        }
        return this._undo;
    }

    public PythonIndentation getIndentationLogic() {
        return this._indentationLogic;
    }

    private void initKeyMap() {
        InputMap inputMap = this.getInputMap();
        int n = 1;
        int n2 = 2;
        inputMap.put(KeyStroke.getKeyStroke(9, n), "SKL.DeindentAction");
        inputMap.put(KeyStroke.getKeyStroke(32, n2), "SKL.DeindentAction");
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public String loadFile() throws IOException {
        File file = new SikuliIDEFileChooser(SikuliIDE.getInstance()).load();
        if (file == null) {
            return null;
        }
        String string = Utils.slashify(file.getAbsolutePath(), false);
        SikuliIDE sikuliIDE = SikuliIDE.getInstance();
        int n = sikuliIDE.isAlreadyOpen(string);
        if (n > -1) {
            Debug.log((int)2, (String)("Already open in IDE: " + string), (Object[])new Object[0]);
            return null;
        }
        this.loadFile(string);
        return string;
    }

    public void loadFile(String string) throws IOException {
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        this.setSrcBundle(string + "/");
        this._editingFile = this.findSourceFile(string);
        this.read(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._editingFile), "UTF8")), null);
        this.updateDocumentListeners();
        this.setDirty(false);
    }

    private File findSourceFile(String string) {
        if (string.endsWith(".sikuli") || string.endsWith(".sikuli/")) {
            File file = new File(string);
            File[] fileArray = file.listFiles(new GeneralFileFilter("py", "Python Source"));
            if (fileArray.length > 1) {
                String string2 = file.getName();
                string2 = string2.substring(0, string2.lastIndexOf(46));
                for (File file2 : fileArray) {
                    String string3 = file2.getName();
                    if (!(string3 = string3.substring(0, string3.lastIndexOf(46))).equals(string2)) continue;
                    return file2;
                }
            }
            if (fileArray.length >= 1) {
                return fileArray[0];
            }
        }
        return new File(string);
    }

    public String saveFile() throws IOException {
        if (this._editingFile == null) {
            return this.saveAsFile();
        }
        this.writeSrcFile();
        return this.getCurrentShortFilename();
    }

    public String saveAsFile() throws IOException {
        int n;
        File file = new SikuliIDEFileChooser(SikuliIDE.getInstance()).save();
        if (file == null) {
            return null;
        }
        String string = file.getAbsolutePath();
        if (!file.getAbsolutePath().endsWith(".sikuli")) {
            string = string + ".sikuli";
        }
        if (FileManager.exists((String)string) && (n = JOptionPane.showConfirmDialog(null, SikuliIDEI18N._I("msgFileExists", string), SikuliIDEI18N._I("dlgFileExists", new Object[0]), 0)) != 0) {
            return null;
        }
        this.saveAsBundle(string, SikuliIDE.getInstance().getCurrentFileTabTitle());
        return this.getCurrentShortFilename();
    }

    private void saveAsBundle(String string, String string2) throws IOException {
        string = Utils.slashify(string, true);
        if (this._srcBundlePath != null && !this._srcBundleTemp) {
            FileManager.xcopy((String)this._srcBundlePath, (String)string, (String)string2);
        } else {
            FileManager.mkdir((String)string);
            if (this._srcBundleTemp) {
                FileManager.deleteTempDir((String)this._srcBundlePath);
                this._srcBundleTemp = false;
            }
        }
        this.setSrcBundle(string);
        this._editingFile = this.createSourceFile(string, ".py");
        Debug.log((int)2, (String)("save to bundle: " + this.getSrcBundle()), (Object[])new Object[0]);
        this.writeSrcFile();
    }

    private File createSourceFile(String string, String string2) {
        if (string.endsWith(".sikuli") || string.endsWith(".sikuli/")) {
            File file = new File(string);
            String string3 = file.getName();
            string3 = string3.substring(0, string3.lastIndexOf("."));
            return new File(string, string3 + string2);
        }
        return new File(string);
    }

    private void writeSrcFile() throws IOException {
        this.writeFile(this._editingFile.getAbsolutePath());
        if (PreferencesUser.getInstance().getAtSaveMakeHTML()) {
            this.convertSrcToHtml(this.getSrcBundle());
        } else {
            new File(this._editingFile.getAbsolutePath().replaceFirst("py", "html")).delete();
        }
        if (PreferencesUser.getInstance().getAtSaveCleanBundle()) {
            this.cleanBundle(this.getSrcBundle());
        }
        this.setDirty(false);
    }

    public String exportAsZip() throws IOException, FileNotFoundException {
        File file = new SikuliIDEFileChooser(SikuliIDE.getInstance()).export();
        if (file == null) {
            return null;
        }
        String string = file.getAbsolutePath();
        String string2 = file.getName();
        if (!file.getAbsolutePath().endsWith(".skl")) {
            string = string + ".skl";
        } else {
            string2 = string2.substring(0, string2.lastIndexOf(46));
        }
        this.writeFile(this.getSrcBundle() + string2 + ".py");
        Utils.zip(this.getSrcBundle(), string);
        Debug.log((int)2, (String)("export to executable file: " + string), (Object[])new Object[0]);
        return string;
    }

    private void writeFile(String string) throws IOException {
        this.write(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF8")));
    }

    public boolean close() throws IOException {
        if (this.isDirty()) {
            Object[] objectArray = new Object[]{SikuliIDEI18N._I("yes", new Object[0]), SikuliIDEI18N._I("no", new Object[0]), SikuliIDEI18N._I("cancel", new Object[0])};
            int n = JOptionPane.showOptionDialog(this, SikuliIDEI18N._I("msgAskSaveChanges", this.getCurrentShortFilename()), SikuliIDEI18N._I("dlgAskCloseTab", new Object[0]), 1, 2, null, objectArray, objectArray[0]);
            if (n == 2 || n == -1) {
                return false;
            }
            if (n == 0 && this.saveFile() == null) {
                return false;
            }
            if (this._srcBundleTemp) {
                FileManager.deleteTempDir((String)this._srcBundlePath);
            }
            this.setDirty(false);
        }
        return true;
    }

    private void setSrcBundle(String string) {
        this._srcBundlePath = string;
        ImageLocator.setBundlePath((String)this._srcBundlePath);
    }

    public String getSrcBundle() {
        if (this._srcBundlePath == null) {
            File file = FileManager.createTempDir();
            this.setSrcBundle(Utils.slashify(file.getAbsolutePath(), true));
            this._srcBundleTemp = true;
        }
        return this._srcBundlePath;
    }

    public boolean isSourceBundleTemp() {
        return this._srcBundleTemp;
    }

    private String getCurrentShortFilename() {
        if (this._srcBundlePath != null) {
            File file = new File(this._srcBundlePath);
            return file.getName();
        }
        return "Untitled";
    }

    public File getCurrentFile() {
        if (this._editingFile == null && this.isDirty()) {
            try {
                this.saveAsFile();
                return this._editingFile;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this._editingFile;
    }

    public String getCurrentFilename() {
        if (this._editingFile == null) {
            return null;
        }
        return this._editingFile.getAbsolutePath();
    }

    private void convertSrcToHtml(String string) {
        PythonInterpreter pythonInterpreter = SikuliScriptRunner.getPythonInterpreter();
        Debug.log((int)2, (String)("Convert Sikuli source code " + string + " to HTML"), (Object[])new Object[0]);
        pythonInterpreter.set("local_convert", (Object)true);
        pythonInterpreter.set("sikuli_src", (Object)string);
        pythonInterpreter.exec(pyConverter);
    }

    private void cleanBundle(String string) {
        if (!PreferencesUser.getInstance().getAtSaveCleanBundle()) {
            return;
        }
        PythonInterpreter pythonInterpreter = SikuliScriptRunner.getPythonInterpreter();
        Debug.log((int)2, (String)("Clear source bundle " + string), (Object[])new Object[0]);
        pythonInterpreter.set("bundle_path", (Object)string);
        pythonInterpreter.exec(pyBundleCleaner);
    }

    public File copyFileToBundle(String string) {
        File file = new File(string);
        String string2 = this.getSrcBundle();
        if (file.exists()) {
            try {
                File file2 = FileManager.smartCopy((String)string, (String)string2);
                return file2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return file;
            }
        }
        return null;
    }

    public File getFileInBundle(String string) {
        try {
            String string2 = ImageLocator.locate((String)string);
            return new File(string2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void read(Reader reader, Object object) throws IOException {
        super.read(reader, object);
        Document document = this.getDocument();
        Element element = document.getDefaultRootElement();
        this.parse(element);
        this.setCaretPosition(0);
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        if (this._dirty == bl) {
            return;
        }
        this._dirty = bl;
        if (bl) {
            // empty if block
        }
        SikuliIDE.getInstance().setCurrentFileTabTitleDirty(this._dirty);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
    }

    public int getLineNumberAtCaret(int n) {
        Element element = this.getDocument().getDefaultRootElement();
        return element.getElementIndex(n) + 1;
    }

    public Element getLineAtCaret(int n) {
        Element element = this.getDocument().getDefaultRootElement();
        if (n == -1) {
            return element.getElement(element.getElementIndex(this.getCaretPosition()));
        }
        return element.getElement(element.getElementIndex(element.getElementIndex(n)));
    }

    public Element getLineAtPoint(MouseEvent mouseEvent) {
        Point point = mouseEvent.getLocationOnScreen();
        Point point2 = this.getLocationOnScreen();
        point.translate(-point2.x, -point2.y);
        int n = this.viewToModel(point);
        Element element = this.getDocument().getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        if (n2 == -1) {
            return null;
        }
        return element.getElement(n2);
    }

    public boolean jumpTo(int n, int n2) {
        Debug.log((int)6, (String)("jumpTo: " + n + "," + n2), (Object[])new Object[0]);
        try {
            int n3;
            int n4 = this.getLineStartOffset(n - 1) + n2 - 1;
            int n5 = this.getDocument().getDefaultRootElement().getElementCount();
            if (n < n5 && n4 >= (n3 = this.getLineStartOffset(n))) {
                n4 = n3 - 1;
            }
            if (n4 >= 0) {
                this.setCaretPosition(n4);
            }
        }
        catch (BadLocationException badLocationException) {
            this.jumpTo(n);
            return false;
        }
        return true;
    }

    public boolean jumpTo(int n) {
        Debug.log((int)6, (String)("jumpTo: " + n), (Object[])new Object[0]);
        try {
            this.setCaretPosition(this.getLineStartOffset(n - 1));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        return true;
    }

    public int getLineStartOffset(int n) throws BadLocationException {
        Element element = this.getDocument().getDefaultRootElement();
        if (n < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (n >= element.getElementCount()) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element element2 = element.getElement(n);
        return element2.getStartOffset();
    }

    public void jumpTo(String string) throws BadLocationException {
        Debug.log((int)6, (String)("jumpTo: " + string), (Object[])new Object[0]);
        Element element = this.getDocument().getDefaultRootElement();
        int n = this.getFunctionStartOffset(string, element);
        if (n < 0) {
            throw new BadLocationException("Can't find function " + string, -1);
        }
        this.setCaretPosition(n);
    }

    private int getFunctionStartOffset(String string, Element element) throws BadLocationException {
        Document document = this.getDocument();
        int n = element.getElementCount();
        Pattern pattern = Pattern.compile("def\\s+" + string + "\\s*\\(");
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            String string2;
            Matcher matcher;
            Element element2 = element.getElement(i);
            if (!(element2.isLeaf() ? (matcher = pattern.matcher(string2 = document.getText(n3 = element2.getStartOffset(), (n2 = element2.getEndOffset()) - n3))).find() : (n3 = this.getFunctionStartOffset(string, element2)) >= 0)) continue;
            return n3;
        }
        return -1;
    }

    public boolean reparse() {
        File file = FileManager.createTempFile((String)"py");
        Element element = this.getDocument().getDefaultRootElement();
        if (element.getEndOffset() - element.getStartOffset() == 1) {
            return true;
        }
        try {
            this.writeFile(file.getAbsolutePath());
            this.read(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8")), null);
            this.updateDocumentListeners();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void parse(Element element) {
        if (!this.showThumbs) {
            return;
        }
        int n = element.getElementCount();
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getElement(i);
            Debug.log((int)8, (String)element2.toString(), (Object[])new Object[0]);
            if (element2.isLeaf()) {
                int n2 = element2.getStartOffset();
                int n3 = element2.getEndOffset();
                this.parseRange(n2, n3);
                continue;
            }
            this.parse(element2);
        }
    }

    private int parseRange(int n, int n2) {
        if (!this.showThumbs) {
            return n2;
        }
        try {
            n2 = this.parseLine(n, n2, patCaptureBtn);
            n2 = this.parseLine(n, n2, patPatternStr);
            n2 = this.parseLine(n, n2, patRegionStr);
            n2 = this.parseLine(n, n2, patPngStr);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return n2;
    }

    private int parseLine(int n, int n2, Pattern pattern) throws BadLocationException {
        String string;
        Matcher matcher;
        if (n2 <= n) {
            return n2;
        }
        Document document = this.getDocument();
        while ((matcher = pattern.matcher(string = document.getText(n, n2 - n))).find()) {
            int n3 = matcher.end() - matcher.start();
            if (this.replaceWithImage(n + matcher.start(), n + matcher.end(), pattern)) {
                n += matcher.start() + 1;
                n2 -= n3 - 1;
                continue;
            }
            n += matcher.end() + 1;
        }
        return n2;
    }

    private boolean replaceWithImage(int n, int n2, Pattern pattern) throws BadLocationException {
        Document document = this.getDocument();
        String string = document.getText(n, n2 - n);
        JComponent jComponent = null;
        if (pattern == patPatternStr || pattern == patPngStr) {
            jComponent = this.pref.getPrefMoreImageThumbs() ? EditorPatternButton.createFromString(this, string, null) : EditorPatternLabel.labelFromString(this, string);
        } else if (pattern == patRegionStr) {
            jComponent = this.pref.getPrefMoreImageThumbs() ? EditorRegionButton.createFromString(this, string) : EditorRegionLabel.labelFromString(this, string);
        } else if (pattern == patCaptureBtn) {
            jComponent = EditorPatternLabel.labelFromString(this, "");
        }
        if (jComponent != null) {
            this.select(n, n2);
            this.insertComponent(jComponent);
            return true;
        }
        return false;
    }

    public String getRegionString(int n, int n2, int n3, int n4) {
        return String.format("Region(%d,%d,%d,%d)", n, n2, n3, n4);
    }

    public String getPatternString(String string, float f, Location location) {
        if (string == null) {
            return "\"" + EditorPatternLabel.CAPTURE + "\"";
        }
        String string2 = new File(string).getName();
        String string3 = "Pattern(\"" + string2 + "\")";
        String string4 = "";
        if (f > 0.0f) {
            if (f >= 0.99f) {
                string4 = string4 + ".exact()";
            } else if (f != 0.7f) {
                string4 = string4 + String.format(Locale.ENGLISH, ".similar(%.2f)", Float.valueOf(f));
            }
        }
        if (location != null && (location.x != 0 || location.y != 0)) {
            string4 = string4 + ".targetOffset(" + location.x + "," + location.y + ")";
        }
        string4 = !string4.equals("") ? string3 + string4 : "\"" + string2 + "\"";
        return string4;
    }

    public void insertString(String string) {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        if (n2 != n) {
            try {
                this.getDocument().remove(n, n2 - n);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        int n3 = this.getCaretPosition();
        this.insertString(n3, string);
        int n4 = this.getCaretPosition();
        int n5 = this.parseRange(n3, n4);
        this.setCaretPosition(n5);
    }

    private void insertString(int n, String string) {
        Document document = this.getDocument();
        try {
            document.insertString(n, string, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void appendString(String string) {
        Document document = this.getDocument();
        try {
            int n = document.getLength();
            document.insertString(document.getLength(), string, null);
            int n2 = document.getLength();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int search(String string, int n, boolean bl) {
        int n2 = -1;
        Document document = this.getDocument();
        Debug.log((int)9, (String)("search caret: " + n + ", " + document.getLength()), (Object[])new Object[0]);
        try {
            int n3;
            String string2;
            if (bl) {
                int n4 = document.getLength() - n;
                string2 = document.getText(n, n4 > 0 ? n4 : 0);
                n3 = n;
            } else {
                string2 = document.getText(0, n);
                n3 = 0;
            }
            Pattern pattern = Pattern.compile(Pattern.quote(string));
            Matcher matcher = pattern.matcher(string2);
            n2 = this.continueSearch(matcher, n3, bl);
            if (n2 < 0) {
                if (bl && n != 0) {
                    return this.search(string, 0, bl);
                }
                if (!bl && n != document.getLength()) {
                    return this.search(string, document.getLength(), bl);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Debug.log((int)7, (String)("search caret: " + n + ", " + document.getLength() + badLocationException.getStackTrace()), (Object[])new Object[0]);
        }
        return n2;
    }

    protected int continueSearch(Matcher matcher, int n, boolean bl) {
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        if (!bl) {
            while (matcher.find()) {
                bl2 = true;
                n2 = matcher.start();
                n3 = matcher.end();
            }
        } else {
            bl2 = matcher.find();
            if (!bl2) {
                return -1;
            }
            n2 = matcher.start();
            n3 = matcher.end();
        }
        if (bl2) {
            Document document = this.getDocument();
            this.getCaret().setDot(n + n3);
            this.getCaret().moveDot(n + n2);
            this.getCaret().setSelectionVisible(true);
            return n + n2;
        }
        return -1;
    }

    private void setTabSize(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n2 = fontMetrics.charWidth('w');
        int n3 = n2 * n;
        TabStop[] tabStopArray = new TabStop[10];
        for (int i = 0; i < tabStopArray.length; ++i) {
            int n4 = i + 1;
            tabStopArray[i] = new TabStop(n4 * n3);
        }
        TabSet tabSet = new TabSet(tabStopArray);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontSize(simpleAttributeSet, 18);
        StyleConstants.setFontFamily(simpleAttributeSet, "Osaka-Mono");
        StyleConstants.setTabSet(simpleAttributeSet, tabSet);
        int n5 = this.getDocument().getLength();
        this.getStyledDocument().setParagraphAttributes(0, n5, simpleAttributeSet, true);
    }

    private void setTabs(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + " ";
        }
        this._tabString = string;
    }

    private void expandTab() throws BadLocationException {
        int n = this.getCaretPosition();
        Document document = this.getDocument();
        document.remove(n - 1, 1);
        document.insertString(n - 1, this._tabString, null);
    }

    private void setHistoryCaptureButton(ButtonCapture buttonCapture) {
        this._historyBtnClass = buttonCapture.getClass();
    }

    private void indent(int n, int n2, int n3) {
        int n4;
        Document document = this.getDocument();
        String string = "";
        if (n3 > 0) {
            for (n4 = 0; n4 < n3; ++n4) {
                string = string + "  ";
            }
        } else {
            Debug.error((String)"negative indentation not supported yet!!", (Object[])new Object[0]);
        }
        for (n4 = n; n4 < n2; ++n4) {
            try {
                int n5 = this.getLineStartOffset(n4);
                if (n3 <= 0) continue;
                document.insertString(n5, string, null);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void checkCompletion(KeyEvent keyEvent) throws BadLocationException {
        Document document = this.getDocument();
        Element element = document.getDefaultRootElement();
        int n = this.getCaretPosition();
        int n2 = element.getElementIndex(n);
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        int n4 = element2.getEndOffset() - n3;
        String string = document.getText(n3, n4 - 1);
        Debug.log((int)9, (String)("[" + string + "]"), (Object[])new Object[0]);
        if (string.endsWith("find") && keyEvent.getKeyChar() == '(') {
            keyEvent.consume();
            document.insertString(n, "(", null);
            ButtonCapture buttonCapture = new ButtonCapture(this, element2);
            this.insertComponent(buttonCapture);
            document.insertString(n + 2, ")", null);
        }
    }

    private class MyTransferHandler
    extends TransferHandler {
        Map<String, String> _copiedImgs = new HashMap<String, String>();

        private MyTransferHandler() {
        }

        @Override
        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
            super.exportToClipboard(jComponent, clipboard, n);
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2) {
                JTextPane jTextPane = (JTextPane)jComponent;
                int n2 = jTextPane.getSelectionStart();
                int n3 = jTextPane.getSelectionEnd();
                Document document = jTextPane.getDocument();
                try {
                    document.remove(n2, n3 - n2);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            JTextPane jTextPane = (JTextPane)jComponent;
            EditorKit editorKit = (EditorKit)jTextPane.getEditorKit();
            Document document = jTextPane.getDocument();
            int n = jTextPane.getSelectionStart();
            int n2 = jTextPane.getSelectionEnd();
            StringWriter stringWriter = new StringWriter();
            try {
                this._copiedImgs.clear();
                editorKit.write(stringWriter, document, n, n2 - n, this._copiedImgs);
                return new StringSelection(stringWriter.toString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            DataFlavor dataFlavor = DataFlavor.stringFlavor;
            if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                try {
                    String string = (String)transferable.getTransferData(dataFlavor);
                    EditorPane editorPane = (EditorPane)jComponent;
                    for (Map.Entry<String, String> entry : this._copiedImgs.entrySet()) {
                        String string2 = entry.getKey();
                        String string3 = entry.getValue();
                        File file = editorPane.copyFileToBundle(string3);
                        String string4 = file.getName();
                        if (string4.equals(string2)) continue;
                        String string5 = "\"" + string2 + "\"";
                        string4 = "\"" + string4 + "\"";
                        string = string.replaceAll(string5, string4);
                        Debug.info((String)(string5 + " exists. Rename it to " + string4), (Object[])new Object[0]);
                    }
                    editorPane.insertString(string);
                }
                catch (Exception exception) {
                    Debug.error((String)("Can't transfer: " + transferable.toString()), (Object[])new Object[0]);
                }
                return true;
            }
            return false;
        }
    }

    private class DirtyHandler
    implements DocumentListener {
        private DirtyHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            Debug.log((int)9, (String)"change update", (Object[])new Object[0]);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            Debug.log((int)9, (String)"insert update", (Object[])new Object[0]);
            EditorPane.this.setDirty(true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            Debug.log((int)9, (String)"remove update", (Object[])new Object[0]);
            EditorPane.this.setDirty(true);
        }
    }
}

