/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.sikuli.ide.EditorPane;
import org.sikuli.ide.EditorPatternLabel;
import org.sikuli.ide.PatternWindow;
import org.sikuli.ide.PreferencesUser;
import org.sikuli.script.Debug;
import org.sikuli.script.FileManager;
import org.sikuli.script.Location;

class EditorPatternButton
extends JButton
implements ActionListener,
Serializable,
MouseListener {
    static final int DEFAULT_NUM_MATCHES = 10;
    static final float DEFAULT_SIMILARITY = 0.7f;
    private String _imgFilename;
    private String _thumbFname;
    private String _imgFilenameSaved;
    private JLabel patternImageIcon = null;
    private EditorPane _pane;
    private float _similarity;
    private float _similaritySaved;
    private int _numMatches = 10;
    private boolean _exact;
    private boolean _exactSaved;
    private Location _offset = new Location(0, 0);
    private Location _offsetSaved;
    private int _imgW;
    private int _imgH;
    private float _scale = 1.0f;
    private static PatternWindow pwin = null;
    private static Font textFont = new Font("arial", 1, 12);
    private Color oldC;
    private String buttonFname = "";
    private String buttonSimilar = "";
    private String buttonOffset = "";
    private EditorPatternLabel _lbl;

    protected EditorPatternButton(EditorPane editorPane) {
        this.init(editorPane, null);
    }

    public EditorPatternButton(EditorPane editorPane, String string) {
        this.init(editorPane, string);
    }

    protected EditorPatternButton(EditorPatternLabel editorPatternLabel) {
        this._lbl = editorPatternLabel;
        this._imgFilename = this._lbl.getFile();
        this._exact = false;
        this._similarity = this._lbl.getSimilarity();
        this._offset = this._lbl.getTargetOffset();
        this._numMatches = 10;
        this._pane = this._lbl.getPane();
    }

    private void init(EditorPane editorPane, String string) {
        this._pane = editorPane;
        this._exact = false;
        this._similarity = 0.7f;
        this._numMatches = 10;
        if (string != null) {
            this.setFilename(string);
        }
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(true);
        this.setCursor(new Cursor(12));
        this.addActionListener(this);
        this.setButtonText();
    }

    public BufferedImage createThumbnailImage(int n) {
        return this.createThumbnailImage(this._imgFilename, n);
    }

    public static EditorPatternButton createFromString(EditorPane editorPane, String string, EditorPatternLabel editorPatternLabel) {
        String[] stringArray;
        if (!string.startsWith("Pattern")) {
            String string2;
            File file;
            if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' && (file = editorPane.getFileInBundle(string2 = string.substring(1, string.length() - 1))) != null) {
                return new EditorPatternButton(editorPane, file.getAbsolutePath());
            }
            return null;
        }
        EditorPatternButton editorPatternButton = new EditorPatternButton(editorPane);
        for (String string3 : stringArray = string.split("\\)\\s*\\.?")) {
            String[] stringArray2;
            String string4;
            if (string3.startsWith("exact")) {
                editorPatternButton.setExact(true);
                editorPatternButton.setSimilarity(0.99f);
                continue;
            }
            if (string3.startsWith("Pattern")) {
                string4 = string3.substring(string3.indexOf("\"") + 1, string3.lastIndexOf("\""));
                stringArray2 = editorPane.getFileInBundle(string4);
                if (stringArray2 != null && stringArray2.exists()) {
                    editorPatternButton.setFilename(stringArray2.getAbsolutePath());
                    continue;
                }
                return null;
            }
            if (string3.startsWith("similar")) {
                string4 = string3.substring(string3.lastIndexOf("(") + 1);
                try {
                    editorPatternButton.setSimilarity(Float.valueOf(string4).floatValue());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            if (string3.startsWith("firstN")) {
                string4 = string3.substring(string3.lastIndexOf("(") + 1);
                editorPatternButton._numMatches = Integer.valueOf(string4);
                continue;
            }
            if (!string3.startsWith("targetOffset")) continue;
            string4 = string3.substring(string3.lastIndexOf("(") + 1);
            stringArray2 = string4.split(",");
            try {
                Location location = new Location(0, 0);
                location.x = Integer.valueOf(stringArray2[0]);
                location.y = Integer.valueOf(stringArray2[1]);
                editorPatternButton.setTargetOffset(location);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        editorPatternButton.setButtonText();
        return editorPatternButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Debug.log((int)2, (String)"open Pattern Settings", (Object[])new Object[0]);
        if (pwin == null) {
            this._offsetSaved = new Location(this._offset);
            this._similaritySaved = this._similarity;
            this._exactSaved = this._similarity >= 0.99f;
            this._imgFilenameSaved = this._imgFilename.substring(0);
            pwin = new PatternWindow(this, this._exactSaved, this._similarity, this._numMatches);
            pwin.setTargetOffset(this._offset);
        } else {
            pwin.requestFocus();
        }
        Rectangle rectangle = pwin.getGraphicsConfiguration().getDevice().getDefaultConfiguration().getBounds();
        rectangle.height -= 100;
        Rectangle rectangle2 = pwin.getBounds();
        if (!rectangle.contains(rectangle2)) {
            if (rectangle2.height > rectangle.height - 100) {
                rectangle2.setSize(rectangle2.width, rectangle.height - 200);
            }
            if (!rectangle.contains(rectangle2.getLocation())) {
                rectangle2.setLocation(rectangle.x + 100, rectangle2.y);
            }
            Point point = rectangle2.getLocation();
            point.translate(rectangle2.width, 0);
            if (!rectangle.contains(point)) {
                int n = point.x - rectangle.x - rectangle.width;
                rectangle2.setLocation(rectangle2.x - n, rectangle2.y);
            }
            Point point2 = rectangle2.getLocation();
            point2.translate(0, rectangle2.height);
            if (!rectangle.contains(point2)) {
                int n = point2.y - rectangle.y - rectangle.height;
                rectangle2.setLocation(rectangle2.x, rectangle2.y - n);
            }
            pwin.setBounds(rectangle2);
        }
    }

    @Override
    public Point getLocationOnScreen() {
        if (this._lbl == null) {
            return super.getLocationOnScreen();
        }
        return this._lbl.getLocationOnScreen();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public PatternWindow getWindow() {
        return pwin;
    }

    public void resetWindow() {
        pwin = null;
    }

    public String getFilename() {
        File file = new File(this._imgFilename);
        String string = file.getParent();
        String string2 = this._pane.getSrcBundle();
        Debug.log((int)2, (String)("ImageButton.getFilename: " + string + " " + string2), (Object[])new Object[0]);
        if (string == string2) {
            return this._imgFilename;
        }
        this.setFilename(string2 + File.separatorChar + file.getName());
        return this._imgFilename;
    }

    public void setFilename(String string) {
        this._imgFilename = string;
        this._thumbFname = this.createThumbnail(this._imgFilename);
        this.setIcon(new ImageIcon(this._thumbFname));
        this.setButtonText();
    }

    private String createThumbnail(String string) {
        return this.createThumbnail(string, PreferencesUser.getInstance().getDefaultThumbHeight());
    }

    private String createThumbnail(String string, int n) {
        BufferedImage bufferedImage = this.createThumbnailImage(string, n);
        return FileManager.saveTmpImage((BufferedImage)bufferedImage);
    }

    private BufferedImage createThumbnailImage(String string, int n) {
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(string));
            int n2 = bufferedImage.getWidth(null);
            int n3 = bufferedImage.getHeight(null);
            this._imgW = n2;
            this._imgH = n3;
            if (n == 0 || n >= n3) {
                return bufferedImage;
            }
            this._scale = (float)n / (float)n3;
            n2 = (int)((float)n2 * this._scale);
            n3 = (int)((float)n3 * this._scale);
            BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 1);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(bufferedImage, 0, 0, n2, n3, null);
            graphics2D.dispose();
            return bufferedImage2;
        }
        catch (IOException iOException) {
            Debug.error((String)("Can't read file: " + iOException.getMessage()), (Object[])new Object[0]);
            return null;
        }
    }

    public boolean setParameters(boolean bl, float f, int n) {
        boolean bl2 = false;
        Debug.log((int)2, (String)("setParameters: " + bl + "," + f + "," + n), (Object[])new Object[0]);
        bl2 |= this.setExact(bl);
        this.setButtonText();
        return bl2 |= this.setSimilarity(f);
    }

    public void resetParameters() {
        this.setFilename(this._imgFilenameSaved);
        this.setParameters(this._exactSaved, this._similaritySaved, 10);
        this.setTargetOffset(this._offsetSaved);
    }

    public boolean setExact(boolean bl) {
        if (this._exact != bl) {
            this._exact = bl;
            return true;
        }
        return false;
    }

    public boolean setSimilarity(float f) {
        float f2 = f < 0.0f ? 0.0f : (f >= 1.0f ? 0.99f : f);
        if (f2 != this._similarity) {
            this._similarity = f2;
            return true;
        }
        return false;
    }

    public float getSimilarity() {
        return this._similarity;
    }

    public boolean setTargetOffset(Location location) {
        Debug.log((int)2, (String)("setTargetOffset: " + location), (Object[])new Object[0]);
        if (!this._offset.equals((Object)location)) {
            this._offset = location;
            this.setButtonText();
            return true;
        }
        return false;
    }

    public Location getTargetOffset() {
        return this._offset;
    }

    public String getFileName() {
        return this._imgFilename;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawText(graphics2D);
        if (this.useThumbnail()) {
            graphics2D.setColor(new Color(0, 128, 128, 128));
            graphics2D.drawRoundRect(3, 3, this.getWidth() - 7, this.getHeight() - 7, 5, 5);
        }
    }

    private void drawText(Graphics2D graphics2D) {
        String string = null;
        String string2 = null;
        if (this._similarity != 0.7f) {
            string = this._exact ? "99" : String.format("%d", (int)(this._similarity * 100.0f));
        }
        if (this._offset != null && (this._offset.x != 0 || this._offset.y != 0)) {
            string2 = this._offset.toString();
        }
        if (string2 == null && string == null) {
            return;
        }
        int n = graphics2D.getFontMetrics().getMaxAscent();
        int n2 = this.getWidth();
        this.drawText(graphics2D, string, n2, 0);
        if (this._offset != null) {
            this.drawCross(graphics2D);
        }
    }

    private void drawText(Graphics2D graphics2D, String string, int n, int n2) {
        if (string == null) {
            return;
        }
        int n3 = graphics2D.getFontMetrics().stringWidth(string);
        int n4 = graphics2D.getFontMetrics().getMaxAscent();
        graphics2D.setFont(textFont);
        graphics2D.setColor(new Color(0, 128, 0, 128));
        graphics2D.fillRoundRect(n - 6 - n3 - 1, n2, n3 + 6 + 1, n4 + 6 + 1, 3, 3);
        graphics2D.setColor(Color.white);
        graphics2D.drawString(string, n - n3 - 3, n2 + n4 + 3);
    }

    private void drawCross(Graphics2D graphics2D) {
        int n = graphics2D.getFontMetrics().stringWidth("+");
        int n2 = graphics2D.getFontMetrics().getMaxAscent();
        int n3 = this._offset.x > this._imgW / 2 ? this.getWidth() - n : (this._offset.x < -this._imgW / 2 ? 0 : (int)((float)(this.getWidth() / 2) + (float)this._offset.x * this._scale - (float)(n / 2)));
        int n4 = this._offset.y > this._imgH / 2 ? this.getHeight() + n2 / 2 - 3 : (this._offset.y < -this._imgH / 2 ? n2 / 2 + 2 : (int)((float)(this.getHeight() / 2) + (float)this._offset.y * this._scale + (float)(n2 / 2)));
        graphics2D.setFont(textFont);
        graphics2D.setColor(new Color(0, 0, 0, 180));
        graphics2D.drawString("+", n3 + 1, n4 + 1);
        graphics2D.setColor(new Color(255, 0, 0, 180));
        graphics2D.drawString("+", n3, n4);
    }

    private boolean useThumbnail() {
        return !this._imgFilename.equals(this._thumbFname);
    }

    @Override
    public String toString() {
        return this._pane.getPatternString(this._imgFilename, this._similarity, this._offset);
    }

    private void setButtonText() {
        if (this._lbl == null) {
            this.setToolTipText(this.toString());
        } else {
            this._lbl.resetLabel(this._imgFilename, this._similarity, this._offset);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

