/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.text.Element;
import org.sikuli.ide.ButtonCapture;
import org.sikuli.ide.EditorPane;
import org.sikuli.ide.EditorPatternButton;
import org.sikuli.ide.EditorRegionLabel;
import org.sikuli.script.Debug;
import org.sikuli.script.Location;

public class EditorPatternLabel
extends EditorRegionLabel {
    public static String CAPTURE = "__CLICK-TO-CAPTURE__";
    public static String NOTFOUND = "!? ";
    private String lblText;
    private EditorPane pane;
    private float sim;
    private Location off;
    private String img = null;
    private String imgFileName = null;
    private String imgFile;
    private JFrame imgpop = null;
    private Border pbrd = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    private Border ibrd = BorderFactory.createLineBorder(Color.BLACK);
    private Border brd = BorderFactory.createCompoundBorder(this.pbrd, this.ibrd);
    private boolean clickToShow = false;

    public EditorPatternLabel(EditorPane editorPane, String string) {
        super(editorPane, string);
        this.initLabel(editorPane);
    }

    public EditorPatternLabel(EditorPane editorPane, String string, String string2) {
        super(editorPane, string, string2);
        this.initLabel(editorPane);
    }

    public EditorPatternLabel(EditorPane editorPane, EditorPatternButton editorPatternButton) {
        super(editorPane, editorPatternButton.toString());
        this.initLabel(editorPane);
    }

    private void initLabel(EditorPane editorPane) {
        this.pane = editorPane;
        this.sim = 0.7f;
        this.off = new Location(0, 0);
        if ("".equals(this.pyText)) {
            this.lblText = CAPTURE;
            this.pyText = "\"" + this.lblText + "\"";
        } else if (this.pyText.startsWith("Pattern")) {
            String[] stringArray;
            for (String string : stringArray = this.pyText.split("\\)\\s*\\.?")) {
                String string2;
                if (string.startsWith("exact")) {
                    this.sim = 0.99f;
                    continue;
                }
                if (string.startsWith("Pattern")) {
                    this.setFileNames(string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\"")));
                    continue;
                }
                if (string.startsWith("similar")) {
                    string2 = string.substring(string.lastIndexOf("(") + 1);
                    try {
                        this.sim = Float.valueOf(string2).floatValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.sim = 0.7f;
                    }
                    continue;
                }
                if (!string.startsWith("targetOffset")) continue;
                string2 = string.substring(string.lastIndexOf("(") + 1);
                String[] stringArray2 = string2.split(",");
                try {
                    this.off = new Location(0, 0);
                    this.off.x = Integer.valueOf(stringArray2[0]);
                    this.off.y = Integer.valueOf(stringArray2[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.setLabelText();
        } else {
            this.setFileNames(this.pyText.replaceAll("\"", ""));
        }
        this.setText(this.lblText);
        this.setLabelPyText();
    }

    private void setFileNames(String string) {
        File file = this.pane.getFileInBundle(string);
        if (file != null && file.exists()) {
            this.imgFile = file.getAbsolutePath();
            this.img = file.getName();
            this.imgFileName = this.img.replaceFirst(".png", "").replaceFirst(".jpg", "");
        } else {
            this.imgFileName = "!? " + string + " ?!";
        }
        this.lblText = this.imgFileName;
    }

    public void showPopup(boolean bl) {
        if (bl) {
            Serializable serializable;
            Serializable serializable2;
            Object object;
            if (this.imgpop == null) {
                try {
                    object = ImageIO.read(new File(this.imgFile));
                }
                catch (IOException iOException) {
                    Debug.error((String)("EditorPatternLabel: mouseEntered: not found " + this.img), (Object[])new Object[0]);
                    return;
                }
                this.imgpop = new JFrame();
                this.imgpop.setAlwaysOnTop(true);
                this.imgpop.setUndecorated(true);
                this.imgpop.setResizable(false);
                this.imgpop.setFocusableWindowState(false);
                this.imgpop.setBackground(Color.WHITE);
                serializable2 = this.imgpop.getContentPane();
                ((Container)serializable2).setLayout(new BoxLayout((Container)serializable2, 0));
                serializable = new JLabel();
                ((JLabel)serializable).setIcon(new ImageIcon((Image)object));
                ((JComponent)serializable).setBorder(this.brd);
                ((Container)serializable2).add(Box.createHorizontalGlue());
                ((Container)serializable2).add((Component)serializable);
                ((Container)serializable2).add(Box.createHorizontalGlue());
                this.imgpop.pack();
            }
            object = this.getLocationOnScreen();
            serializable2 = new Location((Point)object).getScreen().getRect();
            serializable = new Point();
            ((Point)serializable).y = ((Point)object).y < (((Rectangle)serializable2).y + ((Rectangle)serializable2).height) / 2 ? ((Point)object).y + this.getHeight() + 3 : ((Point)object).y - 3 - this.imgpop.getHeight();
            ((Point)serializable).x = ((Point)object).x < (((Rectangle)serializable2).x + ((Rectangle)serializable2).width) / 2 ? ((Point)object).x : ((Point)object).x - this.imgpop.getWidth() + this.getWidth();
            this.imgpop.setLocation((Point)serializable);
            this.imgpop.setVisible(true);
        } else if (this.imgpop != null) {
            this.imgpop.setVisible(false);
        }
    }

    public boolean isCaptureButton() {
        return CAPTURE.equals(this.lblText) || this.lblText.startsWith(NOTFOUND);
    }

    public void resetLabel(String string, float f, Location location) {
        this.imgFile = string;
        this.img = new File(string).getName();
        this.imgFileName = this.img.replaceFirst(".png", "").replaceFirst(".jpg", "");
        this.sim = f;
        this.off = location;
        this.setLabelText();
        this.setLabelPyText();
    }

    public void setLabelText() {
        String string = "";
        if (this.sim != 0.7f) {
            string = String.format(Locale.ENGLISH, " .%d", (int)(this.sim * 100.0f));
        }
        String string2 = "";
        if (this.off != null && (this.off.x != 0 || this.off.y != 0)) {
            string2 = String.format(" (%d,%d)", this.off.x, this.off.y);
        }
        this.lblText = this.imgFileName + string + string2;
        this.setText(this.lblText);
    }

    public void setLabelPyText() {
        if (!this.lblText.startsWith(NOTFOUND)) {
            this.pyText = this.pane.getPatternString(this.img, this.sim, this.off);
        }
    }

    public void setFile(String string) {
        this.img = new File(string).getName();
        this.pyText = "\"" + this.img + "\"";
        this.lblText = this.imgFileName = this.pyText.replaceAll("\"", "").replaceFirst(".png", "").replaceFirst(".jpg", "");
        this.setText(this.lblText);
    }

    public String getFile() {
        return this.imgFile;
    }

    public void setFileName(String string) {
        this.img = string;
    }

    public void setTargetOffset(Location location) {
        this.off = location;
    }

    public Location getTargetOffset() {
        return this.off;
    }

    public void setSimilarity(float f) {
        this.sim = f;
    }

    public float getSimilarity() {
        return this.sim;
    }

    public EditorPane getPane() {
        return this.pane;
    }

    public static EditorPatternLabel labelFromString(EditorPane editorPane, String string) {
        EditorPatternLabel editorPatternLabel = new EditorPatternLabel(editorPane, string);
        return editorPatternLabel;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.clickToShow) {
            if (this.imgpop == null) {
                this.showPopup(true);
                return;
            }
            if (!this.imgpop.isShowing()) {
                this.showPopup(true);
                return;
            }
            this.showPopup(false);
        } else if (this.imgpop != null && this.imgpop.isShowing()) {
            this.showPopup(false);
        }
        if (!CAPTURE.equals(this.lblText) && !this.lblText.startsWith(NOTFOUND)) {
            new EditorPatternButton(this).actionPerformed(null);
            return;
        }
        Element element = this.pane.getLineAtPoint(mouseEvent);
        if (element == null) return;
        if (this.lblText.startsWith(NOTFOUND)) {
            return;
        }
        new ButtonCapture(this.pane, element).actionPerformed(null);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        super.mouseEntered(mouseEvent);
        if (CAPTURE.equals(this.lblText) || this.lblText.startsWith(NOTFOUND)) {
            return;
        }
        if (!this.clickToShow) {
            this.showPopup(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        super.mouseExited(mouseEvent);
        if (CAPTURE.equals(this.lblText)) {
            return;
        }
        this.showPopup(false);
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

