/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.sikuli.ide.EditorPane;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.script.Debug;
import org.sikuli.script.EventObserver;
import org.sikuli.script.EventSubject;
import org.sikuli.script.OverlayCapturePrompt;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;

class EditorRegionButton
extends JButton
implements ActionListener,
EventObserver {
    EditorPane _pane;
    int _x;
    int _y;
    int _w;
    int _h;

    public EditorRegionButton(EditorPane editorPane, int n, int n2, int n3, int n4) {
        this._pane = editorPane;
        this._x = n;
        this._y = n2;
        this._w = n3;
        this._h = n4;
        this.setIcon(new ImageIcon(this.getRegionImage(n, n2, n3, n4)));
        this.setBorderPainted(true);
        this.setToolTipText(this.toString());
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SikuliIDE sikuliIDE = SikuliIDE.getInstance();
        EditorPane editorPane = sikuliIDE.getCurrentCodePane();
        sikuliIDE.setVisible(false);
        OverlayCapturePrompt overlayCapturePrompt = new OverlayCapturePrompt(null, (EventObserver)this);
        overlayCapturePrompt.prompt(SikuliIDE._I("msgCapturePrompt", new Object[0]), 500);
    }

    public void update(EventSubject eventSubject) {
        if (eventSubject instanceof OverlayCapturePrompt) {
            OverlayCapturePrompt overlayCapturePrompt = (OverlayCapturePrompt)eventSubject;
            ScreenImage screenImage = overlayCapturePrompt.getSelection();
            overlayCapturePrompt.close();
            if (screenImage != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Rectangle rectangle = screenImage.getROI();
                this._x = (int)rectangle.getX();
                this._y = (int)rectangle.getY();
                this._w = (int)rectangle.getWidth();
                this._h = (int)rectangle.getHeight();
                BufferedImage bufferedImage = this.getRegionImage(this._x, this._y, this._w, this._h);
                this.setIcon(new ImageIcon(bufferedImage));
                this.setToolTipText(this.toString());
            }
        }
        SikuliIDE.getInstance().setVisible(true);
    }

    private BufferedImage getRegionImage(int n, int n2, int n3, int n4) {
        Region region = Region.create((int)n, (int)n2, (int)n3, (int)n4);
        Screen screen = region.getScreen();
        ScreenImage screenImage = screen.capture();
        int n5 = screenImage.w;
        int n6 = screenImage.h;
        int n7 = 80;
        float f = (float)n7 / (float)n6;
        n5 = (int)((float)n5 * f);
        n6 = (int)((float)n6 * f);
        BufferedImage bufferedImage = new BufferedImage(n5, n6, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.drawImage(screenImage.getImage(), 0, 0, n5, n6, null);
            int n8 = (int)((float)(n - screenImage.x) * f);
            int n9 = (int)((float)(n2 - screenImage.y) * f);
            int n10 = (int)((float)n3 * f);
            int n11 = (int)((float)n4 * f);
            graphics2D.setColor(new Color(255, 0, 0, 150));
            graphics2D.fillRect(n8, n9, n10, n11);
        }
        catch (RasterFormatException rasterFormatException) {
            rasterFormatException.printStackTrace();
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public static EditorRegionButton createFromString(EditorPane editorPane, String string) {
        String[] stringArray = string.split("[(),]");
        try {
            int n = Integer.valueOf(stringArray[1].trim());
            int n2 = Integer.valueOf(stringArray[2].trim());
            int n3 = Integer.valueOf(stringArray[3].trim());
            int n4 = Integer.valueOf(stringArray[4].trim());
            return new EditorRegionButton(editorPane, n, n2, n3, n4);
        }
        catch (Exception exception) {
            Debug.error((String)("Can't parse Region: " + exception.getMessage()), (Object[])new Object[0]);
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public String toString() {
        return String.format("Region(%d,%d,%d,%d)", this._x, this._y, this._w, this._h);
    }
}

