/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.sikuli.ide.EditorPane;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.script.EventObserver;
import org.sikuli.script.EventSubject;
import org.sikuli.script.OverlayCapturePrompt;
import org.sikuli.script.ScreenImage;

public class EditorRegionLabel
extends JLabel
implements MouseListener,
EventObserver {
    protected String pyText;
    protected String oldPyText = null;
    private EditorPane editor;
    private Color bc = Color.BLACK;
    private Color bcs = Color.RED;
    private Color fc;
    private Color fcs = Color.RED;
    private Border paddingBorder = BorderFactory.createEmptyBorder(0, 4, 0, 3);
    private Border border = BorderFactory.createLineBorder(this.bc);
    private Border borders = BorderFactory.createLineBorder(this.bcs);
    private Border bfinal = BorderFactory.createCompoundBorder(this.paddingBorder, this.border);
    private Border bfinals = BorderFactory.createCompoundBorder(this.paddingBorder, this.borders);

    EditorRegionLabel() {
    }

    EditorRegionLabel(EditorPane editorPane, String string) {
        this.init(editorPane, string);
    }

    EditorRegionLabel(EditorPane editorPane, String string, String string2) {
        this.oldPyText = string2;
        this.init(editorPane, string);
    }

    public void init(EditorPane editorPane, String string) {
        this.editor = editorPane;
        this.pyText = string;
        this.setFont(new Font(this.editor.getFont().getFontName(), 0, this.editor.getFont().getSize()));
        this.setBorder(this.bfinal);
        this.setCursor(new Cursor(12));
        this.addMouseListener(this);
        this.setText(this.pyText.replaceAll("Region", "").replaceAll("\\(", "").replaceAll("\\)", ""));
    }

    public static EditorRegionLabel labelFromString(EditorPane editorPane, String string) {
        EditorRegionLabel editorRegionLabel = new EditorRegionLabel(editorPane, string);
        return editorRegionLabel;
    }

    public void update(EventSubject eventSubject) {
        if (eventSubject instanceof OverlayCapturePrompt) {
            OverlayCapturePrompt overlayCapturePrompt = (OverlayCapturePrompt)eventSubject;
            ScreenImage screenImage = overlayCapturePrompt.getSelection();
            overlayCapturePrompt.close();
            if (screenImage != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.doUpdate(screenImage);
            }
        }
        SikuliIDE.getInstance().setVisible(true);
    }

    public void doUpdate(ScreenImage screenImage) {
        Rectangle rectangle = screenImage.getROI();
        this.pyText = String.format("%d,%d,%d,%d", rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.setText(this.pyText);
        this.pyText = "Region(" + this.pyText + ")";
    }

    @Override
    public String toString() {
        return this.pyText;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        SikuliIDE sikuliIDE = SikuliIDE.getInstance();
        EditorPane editorPane = sikuliIDE.getCurrentCodePane();
        sikuliIDE.setVisible(false);
        this.setForeground(this.fc);
        this.setBorder(this.bfinal);
        OverlayCapturePrompt overlayCapturePrompt = new OverlayCapturePrompt(null, (EventObserver)this);
        overlayCapturePrompt.prompt(SikuliIDE._I("msgCapturePrompt", new Object[0]), 500);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setForeground(this.fcs);
        this.setBorder(this.bfinals);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setForeground(this.fc);
        this.setBorder(this.bfinal);
    }
}

