/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ide;

import java.util.ArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.sikuli.ide.MyCompoundEdit;
import org.sikuli.ide.SikuliIDE;
import org.sikuli.script.Debug;

public class EditorUndoManager
extends AbstractUndoableEdit
implements UndoableEditListener {
    String lastEditName = null;
    ArrayList<MyCompoundEdit> edits = new ArrayList();
    MyCompoundEdit current;
    int pointer = -1;

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        UndoableEdit undoableEdit = undoableEditEvent.getEdit();
        if (undoableEdit instanceof AbstractDocument.DefaultDocumentEvent) {
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)undoableEdit;
            int n = defaultDocumentEvent.getOffset();
            int n2 = defaultDocumentEvent.getLength();
            Debug.log((int)9, (String)("undoableEditHappened " + n + "," + n2), (Object[])new Object[0]);
            boolean bl = false;
            if (defaultDocumentEvent.getType().equals(DocumentEvent.EventType.CHANGE) || defaultDocumentEvent.getType().equals(DocumentEvent.EventType.INSERT)) {
                try {
                    String string = defaultDocumentEvent.getDocument().getText(n, n2);
                    if (string.contains("\n")) {
                        bl = true;
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            if (this.current == null) {
                bl = true;
            } else if (this.lastEditName == null || !this.lastEditName.equals(undoableEdit.getPresentationName())) {
                bl = true;
            }
            while (this.pointer < this.edits.size() - 1) {
                this.edits.remove(this.edits.size() - 1);
                bl = true;
            }
            if (bl) {
                this.createCompoundEdit();
            }
            this.current.addEdit(undoableEdit);
            this.lastEditName = undoableEdit.getPresentationName();
            this.refreshControls();
        }
    }

    public void createCompoundEdit() {
        if (this.current == null) {
            this.current = new MyCompoundEdit();
        } else if (this.current.getLength() > 0) {
            this.current = new MyCompoundEdit();
        }
        this.edits.add(this.current);
        ++this.pointer;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        MyCompoundEdit myCompoundEdit = this.edits.get(this.pointer);
        myCompoundEdit.undo();
        --this.pointer;
        this.refreshControls();
    }

    @Override
    public void redo() throws CannotUndoException {
        if (!this.canRedo()) {
            throw new CannotUndoException();
        }
        ++this.pointer;
        MyCompoundEdit myCompoundEdit = this.edits.get(this.pointer);
        myCompoundEdit.redo();
        this.refreshControls();
    }

    @Override
    public boolean canUndo() {
        return this.pointer >= 0;
    }

    @Override
    public boolean canRedo() {
        return this.edits.size() > 0 && this.pointer < this.edits.size() - 1;
    }

    public void refreshControls() {
        SikuliIDE.getInstance().updateUndoRedoStates();
    }
}

